/*
 * Decompiled with CFR 0.152.
 */
package net.satisfyu.meadow.block;

import de.cristelknight.doapi.common.block.FacingBlock;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfyu.meadow.registry.ObjectRegistry;

public class FireLog
extends FacingBlock {
    public static final IntegerProperty STAGE = IntegerProperty.m_61631_((String)"stage", (int)0, (int)3);
    private static final VoxelShape SHAPE_AXE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0);
    private static final VoxelShape SHAPE_SMALL = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    private static final VoxelShape SHAPE_MID = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0);
    private static final VoxelShape SHAPE_BIG = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public FireLog(BlockBehaviour.Properties setting) {
        super(setting);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)STAGE, (Comparable)Integer.valueOf(1)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        int stage = (Integer)state.m_61143_((Property)STAGE);
        if (stage == 0) {
            return SHAPE_AXE;
        }
        if (stage == 1) {
            return SHAPE_SMALL;
        }
        if (stage == 2) {
            return SHAPE_MID;
        }
        if (stage == 3) {
            return SHAPE_BIG;
        }
        return SHAPE_AXE;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        int stage = (Integer)state.m_61143_((Property)STAGE);
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            if (stack.m_41619_() && stage > 0) {
                player.m_36356_(new ItemStack((ItemLike)ObjectRegistry.FIRE_LOG.get()));
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(--stage)));
                world.m_5594_(null, pos, SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        } else if (stack.m_150930_(this.m_5456_())) {
            if (stage < 3 && stage > 0) {
                ++stage;
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
            }
        } else if (stack.m_150930_(Items.f_42386_) && stage == 1 && stack.m_41773_() == 0) {
            stage = 0;
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
        }
        if (stage == (Integer)state.m_61143_((Property)STAGE)) {
            return InteractionResult.PASS;
        }
        world.m_46597_(pos, (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(stage)));
        world.m_5594_(null, pos, SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 1.0f);
        return InteractionResult.SUCCESS;
    }

    private void dropItemStack(Level world, BlockPos pos) {
        Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ObjectRegistry.FIRE_LOG.get(), 1));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{STAGE});
    }

    public void m_5871_(ItemStack itemStack, BlockGetter world, List<Component> tooltip, TooltipFlag tooltipContext) {
        tooltip.add((Component)Component.m_237115_((String)"block.meadow.canbeplaced.tooltip").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        tooltip.add((Component)Component.m_237115_((String)"block.meadow.fuel_item.tooltip").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
    }
}

