/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.serial.wrapper;

import dev.xkmc.l2library.serial.wrapper.ClassCache;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class TypeInfo {
    private final Class<?> cls;
    private final Type type;

    public static TypeInfo of(Class<?> cls) {
        return new TypeInfo(cls, null);
    }

    public static TypeInfo of(Field field) {
        return new TypeInfo(field.getType(), field.getGenericType());
    }

    private static TypeInfo of(Type type) {
        ParameterizedType ptype;
        Type type2;
        if (type instanceof Class) {
            Class cls = (Class)type;
            return new TypeInfo(cls, null);
        }
        if (type instanceof ParameterizedType && (type2 = (ptype = (ParameterizedType)type).getRawType()) instanceof Class) {
            Class cls = (Class)type2;
            return new TypeInfo(cls, ptype);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType array = (GenericArrayType)type;
            TypeInfo sub = TypeInfo.of(array.getGenericComponentType());
            return new TypeInfo((Class<?>)sub.cls.arrayType(), array);
        }
        throw new IllegalStateException("type parameter cannot be converted to class. Generic Type: " + type + ", class: " + type.getClass());
    }

    private TypeInfo(Class<?> cls, Type type) {
        this.cls = cls;
        this.type = type;
    }

    public Class<?> getAsClass() {
        return this.cls;
    }

    public TypeInfo getComponentType() {
        Type com = null;
        Type type = this.type;
        if (type instanceof GenericArrayType) {
            GenericArrayType array = (GenericArrayType)type;
            com = array.getGenericComponentType();
        }
        return new TypeInfo(this.cls.getComponentType(), com);
    }

    public TypeInfo getGenericType(int i) {
        Type type = this.type;
        if (type instanceof ParameterizedType) {
            ParameterizedType param = (ParameterizedType)type;
            Type[] types = param.getActualTypeArguments();
            if (types.length <= i) {
                throw new IllegalArgumentException("generic type " + this.type + "has " + types.length + " fields, accessing index " + i);
            }
            return TypeInfo.of(types[i]);
        }
        throw new IllegalStateException("type parameter is missing. Type: " + this.type + ", Class: " + this.cls);
    }

    public Object newInstance() throws Exception {
        return this.cls.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public boolean isArray() {
        return this.cls.isArray();
    }

    public String toString() {
        return "{cls = " + this.cls + ", type = " + this.type + "}";
    }

    public ClassCache toCache() {
        return ClassCache.get(this.cls);
    }
}

