/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.serial.wrapper;

import dev.xkmc.l2library.serial.SerialClass;
import dev.xkmc.l2library.serial.wrapper.FieldCache;
import dev.xkmc.l2library.serial.wrapper.MethodCache;
import dev.xkmc.l2library.util.code.LazyExc;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class ClassCache {
    private static final Map<Class<?>, ClassCache> CACHE = new ConcurrentHashMap();
    public final Class<?> cls;
    private final LazyExc<SerialClass> annotation;
    private final LazyExc<ClassCache> superClass;
    private final LazyExc<Constructor<?>> constructor;
    private final LazyExc<FieldCache[]> fields;
    private final LazyExc<MethodCache[]> methods;

    public static ClassCache get(Class<?> cls) {
        return CACHE.computeIfAbsent(cls, ClassCache::new);
    }

    private ClassCache(Class<?> cls) {
        this.cls = cls;
        this.constructor = new LazyExc<Constructor>(() -> {
            Constructor ans = cls.getConstructor(new Class[0]);
            ans.setAccessible(true);
            return ans;
        });
        this.annotation = new LazyExc<SerialClass>(() -> cls.getAnnotation(SerialClass.class));
        this.fields = new LazyExc<FieldCache[]>(() -> (FieldCache[])Arrays.stream(cls.getDeclaredFields()).map(FieldCache::new).toArray(FieldCache[]::new));
        this.methods = new LazyExc<MethodCache[]>(() -> (MethodCache[])Arrays.stream(cls.getDeclaredMethods()).map(MethodCache::new).toArray(MethodCache[]::new));
        this.superClass = new LazyExc<ClassCache>(() -> ClassCache.get(cls.getSuperclass()));
    }

    public Object create() throws Exception {
        return this.constructor.get().newInstance(new Object[0]);
    }

    @Nullable
    public SerialClass getSerialAnnotation() throws Exception {
        return this.annotation.get();
    }

    public FieldCache[] getFields() throws Exception {
        return this.fields.get();
    }

    public ClassCache getSuperclass() throws Exception {
        return this.superClass.get();
    }

    public MethodCache[] getMethods() throws Exception {
        return this.methods.get();
    }
}

