/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.serial.stack;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.xkmc.l2library.serial.stack.JsonStackCodec;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraftforge.registries.ForgeRegistries;

public class EnchantmentStackCodec
extends JsonStackCodec {
    @Override
    public Optional<ItemStack> deserialize(JsonElement elem) {
        if (elem.isJsonObject() && elem.getAsJsonObject().has("enchanted_book")) {
            JsonObject book = elem.getAsJsonObject().getAsJsonObject("enchanted_book");
            Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(book.get("id").getAsString()));
            int lvl = book.get("lvl").getAsInt();
            assert (ench != null);
            return Optional.of(EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(ench, lvl)));
        }
        return Optional.empty();
    }

    @Override
    public Optional<JsonElement> serialize(ItemStack stack) {
        Map map;
        if (stack.m_41720_() == Items.f_42690_ && (map = EnchantmentHelper.m_44831_((ItemStack)stack)).size() == 1) {
            Map.Entry entry = (Map.Entry)map.entrySet().stream().findFirst().get();
            JsonObject obj = new JsonObject();
            obj.addProperty("id", ForgeRegistries.ENCHANTMENTS.getKey((Object)((Enchantment)entry.getKey())).toString());
            obj.addProperty("lvl", (Number)entry.getValue());
            return Optional.of(obj);
        }
        return Optional.empty();
    }
}

