/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.serial.network;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import dev.xkmc.l2library.init.L2Library;
import dev.xkmc.l2library.serial.codec.JsonCodec;
import dev.xkmc.l2library.serial.network.BaseConfig;
import dev.xkmc.l2library.serial.network.PacketHandler;
import dev.xkmc.l2library.serial.network.SyncPacket;
import dev.xkmc.l2library.util.code.Wrappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.fml.ModList;

public class PacketHandlerWithConfig
extends PacketHandler {
    static final Map<ResourceLocation, PacketHandlerWithConfig> INTERNAL = new ConcurrentHashMap<ResourceLocation, PacketHandlerWithConfig>();
    public HashMap<String, BaseConfig> configs = new HashMap();
    private final PreparableReloadListener listener;
    private final Map<String, CachedConfig<?>> cache = new HashMap();
    final List<Runnable> listener_before = new ArrayList<Runnable>();
    final List<Runnable> listener_after = new ArrayList<Runnable>();

    public static void onDatapackSync(OnDatapackSyncEvent event) {
        for (PacketHandlerWithConfig handler : INTERNAL.values()) {
            SyncPacket packet = new SyncPacket(handler, handler.configs);
            if (event.getPlayer() == null) {
                L2Library.PACKET_HANDLER.toAllClient(packet);
                continue;
            }
            L2Library.PACKET_HANDLER.toClientPlayer(packet, event.getPlayer());
        }
    }

    public static void addReloadListeners(AddReloadListenerEvent event) {
        for (PacketHandlerWithConfig handler : INTERNAL.values()) {
            if (handler.listener == null) continue;
            event.addListener(handler.listener);
        }
    }

    @SafeVarargs
    public PacketHandlerWithConfig(ResourceLocation id, int version, String config_path, Function<PacketHandler, PacketHandler.LoadedPacket<?>> ... values) {
        super(id, version, values);
        INTERNAL.put(id, this);
        this.listener = new ConfigReloadListener(config_path);
    }

    public void addBeforeReloadListener(Runnable runnable) {
        this.listener_before.add(runnable);
    }

    public void addAfterReloadListener(Runnable runnable) {
        this.listener_after.add(runnable);
    }

    public <T extends BaseConfig> void addCachedConfig(String id, Function<Stream<Map.Entry<String, BaseConfig>>, T> loader) {
        CachedConfig<T> c = new CachedConfig<T>(id, loader);
        this.cache.put(id, c);
        this.addAfterReloadListener(() -> {
            c.result = null;
        });
    }

    public <T extends BaseConfig> T getCachedConfig(String id) {
        return (T)((BaseConfig)Wrappers.cast(this.cache.get(id).load()));
    }

    public Stream<Map.Entry<String, BaseConfig>> getConfigs(String id) {
        return this.configs.entrySet().stream().filter(e -> new ResourceLocation((String)e.getKey()).m_135815_().split("/")[0].equals(id));
    }

    private class ConfigReloadListener
    extends SimpleJsonResourceReloadListener {
        public ConfigReloadListener(String path) {
            super(new Gson(), path);
        }

        protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager manager, ProfilerFiller filler) {
            PacketHandlerWithConfig.this.listener_before.forEach(Runnable::run);
            map.forEach((k, v) -> {
                if (!k.m_135827_().startsWith("_") && !ModList.get().isLoaded(k.m_135827_())) {
                    return;
                }
                BaseConfig config = JsonCodec.from(v, BaseConfig.class, null);
                if (config != null) {
                    config.id = k;
                    PacketHandlerWithConfig.this.configs.put(k.toString(), config);
                }
            });
            PacketHandlerWithConfig.this.listener_after.forEach(Runnable::run);
        }
    }

    private class CachedConfig<T extends BaseConfig> {
        private final Function<Stream<Map.Entry<String, BaseConfig>>, T> function;
        private final String id;
        private T result;

        CachedConfig(String id, Function<Stream<Map.Entry<String, BaseConfig>>, T> function) {
            this.id = id;
            this.function = function;
        }

        T load() {
            if (this.result != null) {
                return this.result;
            }
            this.result = (BaseConfig)this.function.apply(PacketHandlerWithConfig.this.getConfigs(this.id));
            return this.result;
        }
    }
}

