/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.repack.registrate.providers;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import dev.xkmc.l2library.repack.registrate.AbstractRegistrate;
import dev.xkmc.l2library.repack.registrate.providers.ProviderType;
import dev.xkmc.l2library.repack.registrate.providers.RegistrateProvider;
import dev.xkmc.l2library.repack.registrate.util.DataIngredient;
import dev.xkmc.l2library.repack.registrate.util.nullness.NonNullSupplier;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCookingSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.registries.ForgeRegistries;

public class RegistrateRecipeProvider
extends RecipeProvider
implements RegistrateProvider,
Consumer<FinishedRecipe> {
    private final AbstractRegistrate<?> owner;
    @Nullable
    private Consumer<FinishedRecipe> callback;
    public static final int DEFAULT_SMELT_TIME = 200;
    public static final int DEFAULT_BLAST_TIME = 100;
    public static final int DEFAULT_SMOKE_TIME = 100;
    public static final int DEFAULT_CAMPFIRE_TIME = 600;
    private static final String SMELTING_NAME = "smelting";
    private static final ImmutableMap<SimpleCookingSerializer<?>, String> COOKING_TYPE_NAMES = ImmutableMap.builder().put((Object)RecipeSerializer.f_44091_, (Object)"smelting").put((Object)RecipeSerializer.f_44092_, (Object)"blasting").put((Object)RecipeSerializer.f_44093_, (Object)"smoking").put((Object)RecipeSerializer.f_44094_, (Object)"campfire").build();

    public RegistrateRecipeProvider(AbstractRegistrate<?> owner, DataGenerator generatorIn) {
        super(generatorIn);
        this.owner = owner;
    }

    @Override
    public LogicalSide getSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void accept(@Nullable FinishedRecipe t) {
        if (this.callback == null) {
            throw new IllegalStateException("Cannot accept recipes outside of a call to registerRecipes");
        }
        this.callback.accept(t);
    }

    protected void m_176531_(Consumer<FinishedRecipe> consumer) {
        this.callback = consumer;
        this.owner.genData(ProviderType.RECIPE, this);
        this.callback = null;
    }

    public ResourceLocation safeId(ResourceLocation id) {
        return new ResourceLocation(this.owner.getModid(), this.safeName(id));
    }

    public ResourceLocation safeId(DataIngredient source) {
        return this.safeId(source.getId());
    }

    public ResourceLocation safeId(ItemLike registryEntry) {
        return this.safeId(ForgeRegistries.ITEMS.getKey((Object)registryEntry.m_5456_()));
    }

    public String safeName(ResourceLocation id) {
        return id.m_135815_().replace('/', '_');
    }

    public String safeName(DataIngredient source) {
        return this.safeName(source.getId());
    }

    public String safeName(ItemLike registryEntry) {
        return this.safeName(ForgeRegistries.ITEMS.getKey((Object)registryEntry.m_5456_()));
    }

    public <T extends ItemLike> void cooking(DataIngredient source, Supplier<? extends T> result, float experience, int cookingTime, SimpleCookingSerializer<?> serializer) {
        this.cooking(source, result, experience, cookingTime, (String)COOKING_TYPE_NAMES.get(serializer), serializer);
    }

    public <T extends ItemLike> void cooking(DataIngredient source, Supplier<? extends T> result, float experience, int cookingTime, String typeName, SimpleCookingSerializer<?> serializer) {
        SimpleCookingRecipeBuilder.m_126248_((Ingredient)source, (ItemLike)((ItemLike)result.get()), (float)experience, (int)cookingTime, serializer).m_126132_("has_" + this.safeName(source), (CriterionTriggerInstance)source.getCritereon(this)).m_176500_((Consumer)this, this.safeId((ItemLike)result.get()) + "_from_" + this.safeName(source) + "_" + typeName);
    }

    public <T extends ItemLike> void smelting(DataIngredient source, Supplier<? extends T> result, float experience) {
        this.smelting(source, result, experience, 200);
    }

    public <T extends ItemLike> void smelting(DataIngredient source, Supplier<? extends T> result, float experience, int cookingTime) {
        this.cooking(source, result, experience, cookingTime, RecipeSerializer.f_44091_);
    }

    public <T extends ItemLike> void blasting(DataIngredient source, Supplier<? extends T> result, float experience) {
        this.blasting(source, result, experience, 100);
    }

    public <T extends ItemLike> void blasting(DataIngredient source, Supplier<? extends T> result, float experience, int cookingTime) {
        this.cooking(source, result, experience, cookingTime, RecipeSerializer.f_44092_);
    }

    public <T extends ItemLike> void smoking(DataIngredient source, Supplier<? extends T> result, float experience) {
        this.smoking(source, result, experience, 100);
    }

    public <T extends ItemLike> void smoking(DataIngredient source, Supplier<? extends T> result, float experience, int cookingTime) {
        this.cooking(source, result, experience, cookingTime, RecipeSerializer.f_44093_);
    }

    public <T extends ItemLike> void campfire(DataIngredient source, Supplier<? extends T> result, float experience) {
        this.campfire(source, result, experience, 600);
    }

    public <T extends ItemLike> void campfire(DataIngredient source, Supplier<? extends T> result, float experience, int cookingTime) {
        this.cooking(source, result, experience, cookingTime, RecipeSerializer.f_44094_);
    }

    public <T extends ItemLike> void stonecutting(DataIngredient source, Supplier<? extends T> result) {
        this.stonecutting(source, result, 1);
    }

    public <T extends ItemLike> void stonecutting(DataIngredient source, Supplier<? extends T> result, int resultAmount) {
        SingleItemRecipeBuilder.m_126316_((Ingredient)source, (ItemLike)((ItemLike)result.get()), (int)resultAmount).m_126132_("has_" + this.safeName(source), (CriterionTriggerInstance)source.getCritereon(this)).m_176500_((Consumer)this, this.safeId((ItemLike)result.get()) + "_from_" + this.safeName(source) + "_stonecutting");
    }

    public <T extends ItemLike> void smeltingAndBlasting(DataIngredient source, Supplier<? extends T> result, float xp) {
        this.smelting(source, result, xp);
        this.blasting(source, result, xp);
    }

    public <T extends ItemLike> void food(DataIngredient source, Supplier<? extends T> result, float xp) {
        this.smelting(source, result, xp);
        this.smoking(source, result, xp);
        this.campfire(source, result, xp);
    }

    public <T extends ItemLike> void square(DataIngredient source, Supplier<? extends T> output, boolean small) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)output.get())).m_126124_(Character.valueOf('X'), (Ingredient)source);
        if (small) {
            builder.m_126130_("XX").m_126130_("XX");
        } else {
            builder.m_126130_("XXX").m_126130_("XXX").m_126130_("XXX");
        }
        builder.m_126132_("has_" + this.safeName(source), (CriterionTriggerInstance)source.getCritereon(this)).m_126140_((Consumer)this, this.safeId((ItemLike)output.get()));
    }

    @Deprecated
    public <T extends ItemLike> void storage(DataIngredient source, NonNullSupplier<? extends T> output) {
        this.square(source, output, false);
        this.singleItemUnfinished(source, output, 1, 9).m_176500_((Consumer)this, this.safeId(source) + "_from_" + this.safeName((ItemLike)output.get()));
    }

    public <T extends ItemLike> void storage(NonNullSupplier<? extends T> source, NonNullSupplier<? extends T> output) {
        this.storage(DataIngredient.items(source, new NonNullSupplier[0]), source, DataIngredient.items(output, new NonNullSupplier[0]), output);
    }

    public <T extends ItemLike> void storage(DataIngredient sourceIngredient, NonNullSupplier<? extends T> source, DataIngredient outputIngredient, NonNullSupplier<? extends T> output) {
        this.square(sourceIngredient, output, false);
        this.singleItemUnfinished(outputIngredient, source, 1, 9).m_176500_((Consumer)this, this.safeId(sourceIngredient) + "_from_" + this.safeName((ItemLike)output.get()));
    }

    @CheckReturnValue
    public <T extends ItemLike> ShapelessRecipeBuilder singleItemUnfinished(DataIngredient source, Supplier<? extends T> result, int required, int amount) {
        return ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)result.get()), (int)amount).m_126186_((Ingredient)source, required).m_126132_("has_" + this.safeName(source), (CriterionTriggerInstance)source.getCritereon(this));
    }

    public <T extends ItemLike> void singleItem(DataIngredient source, Supplier<? extends T> result, int required, int amount) {
        this.singleItemUnfinished(source, result, required, amount).m_126140_((Consumer)this, this.safeId((ItemLike)result.get()));
    }

    public <T extends ItemLike> void planks(DataIngredient source, Supplier<? extends T> result) {
        this.singleItemUnfinished(source, result, 1, 4).m_126145_("planks").m_126140_((Consumer)this, this.safeId((ItemLike)result.get()));
    }

    public <T extends ItemLike> void stairs(DataIngredient source, Supplier<? extends T> result, @Nullable String group, boolean stone) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)4).m_126130_("X  ").m_126130_("XX ").m_126130_("XXX").m_126124_(Character.valueOf('X'), (Ingredient)source).m_126145_(group).m_126132_("has_" + this.safeName(source), (CriterionTriggerInstance)source.getCritereon(this)).m_126140_((Consumer)this, this.safeId((ItemLike)result.get()));
        if (stone) {
            this.stonecutting(source, result);
        }
    }

    public <T extends ItemLike> void slab(DataIngredient source, Supplier<? extends T> result, @Nullable String group, boolean stone) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)6).m_126130_("XXX").m_126124_(Character.valueOf('X'), (Ingredient)source).m_126145_(group).m_126132_("has_" + this.safeName(source), (CriterionTriggerInstance)source.getCritereon(this)).m_126140_((Consumer)this, this.safeId((ItemLike)result.get()));
        if (stone) {
            this.stonecutting(source, result, 2);
        }
    }

    public <T extends ItemLike> void fence(DataIngredient source, Supplier<? extends T> result, @Nullable String group) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)3).m_126130_("W#W").m_126130_("W#W").m_126124_(Character.valueOf('W'), (Ingredient)source).m_206416_(Character.valueOf('#'), Tags.Items.RODS_WOODEN).m_126145_(group).m_126132_("has_" + this.safeName(source), (CriterionTriggerInstance)source.getCritereon(this)).m_126140_((Consumer)this, this.safeId((ItemLike)result.get()));
    }

    public <T extends ItemLike> void fenceGate(DataIngredient source, Supplier<? extends T> result, @Nullable String group) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)result.get())).m_126130_("#W#").m_126130_("#W#").m_126124_(Character.valueOf('W'), (Ingredient)source).m_206416_(Character.valueOf('#'), Tags.Items.RODS_WOODEN).m_126145_(group).m_126132_("has_" + this.safeName(source), (CriterionTriggerInstance)source.getCritereon(this)).m_126140_((Consumer)this, this.safeId((ItemLike)result.get()));
    }

    public <T extends ItemLike> void wall(DataIngredient source, Supplier<? extends T> result) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)6).m_126130_("XXX").m_126130_("XXX").m_126124_(Character.valueOf('X'), (Ingredient)source).m_126132_("has_" + this.safeName(source), (CriterionTriggerInstance)source.getCritereon(this)).m_126140_((Consumer)this, this.safeId((ItemLike)result.get()));
        this.stonecutting(source, result);
    }

    public <T extends ItemLike> void door(DataIngredient source, Supplier<? extends T> result, @Nullable String group) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)3).m_126130_("XX").m_126130_("XX").m_126130_("XX").m_126124_(Character.valueOf('X'), (Ingredient)source).m_126145_(group).m_126132_("has_" + this.safeName(source), (CriterionTriggerInstance)source.getCritereon(this)).m_126140_((Consumer)this, this.safeId((ItemLike)result.get()));
    }

    public <T extends ItemLike> void trapDoor(DataIngredient source, Supplier<? extends T> result, @Nullable String group) {
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)result.get()), (int)2).m_126130_("XXX").m_126130_("XXX").m_126124_(Character.valueOf('X'), (Ingredient)source).m_126145_(group).m_126132_("has_" + this.safeName(source), (CriterionTriggerInstance)source.getCritereon(this)).m_126140_((Consumer)this, this.safeId((ItemLike)result.get()));
    }

    public void m_236367_(CachedOutput p_236368_, JsonObject p_236369_, Path p_236370_) {
        super.m_236367_(p_236368_, p_236369_, p_236370_);
    }

    public static void oreSmelting(Consumer<FinishedRecipe> p_176592_, List<ItemLike> p_176593_, ItemLike p_176594_, float p_176595_, int p_176596_, String p_176597_) {
        RecipeProvider.m_176591_(p_176592_, p_176593_, (ItemLike)p_176594_, (float)p_176595_, (int)p_176596_, (String)p_176597_);
    }

    public static void oreBlasting(Consumer<FinishedRecipe> p_176626_, List<ItemLike> p_176627_, ItemLike p_176628_, float p_176629_, int p_176630_, String p_176631_) {
        RecipeProvider.m_176625_(p_176626_, p_176627_, (ItemLike)p_176628_, (float)p_176629_, (int)p_176630_, (String)p_176631_);
    }

    public static void oreCooking(Consumer<FinishedRecipe> p_176534_, SimpleCookingSerializer<?> p_176535_, List<ItemLike> p_176536_, ItemLike p_176537_, float p_176538_, int p_176539_, String p_176540_, String p_176541_) {
        RecipeProvider.m_176533_(p_176534_, p_176535_, p_176536_, (ItemLike)p_176537_, (float)p_176538_, (int)p_176539_, (String)p_176540_, (String)p_176541_);
    }

    public static void netheriteSmithing(Consumer<FinishedRecipe> p_125995_, Item p_125996_, Item p_125997_) {
        RecipeProvider.m_125994_(p_125995_, (Item)p_125996_, (Item)p_125997_);
    }

    public static void planksFromLog(Consumer<FinishedRecipe> p_206409_, ItemLike p_206410_, TagKey<Item> p_206411_) {
        RecipeProvider.m_206408_(p_206409_, (ItemLike)p_206410_, p_206411_);
    }

    public static void planksFromLogs(Consumer<FinishedRecipe> p_206413_, ItemLike p_206414_, TagKey<Item> p_206415_) {
        RecipeProvider.m_206412_(p_206413_, (ItemLike)p_206414_, p_206415_);
    }

    public static void woodFromLogs(Consumer<FinishedRecipe> p_126003_, ItemLike p_126004_, ItemLike p_126005_) {
        RecipeProvider.m_126002_(p_126003_, (ItemLike)p_126004_, (ItemLike)p_126005_);
    }

    public static void woodenBoat(Consumer<FinishedRecipe> p_126022_, ItemLike p_126023_, ItemLike p_126024_) {
        RecipeProvider.m_126021_(p_126022_, (ItemLike)p_126023_, (ItemLike)p_126024_);
    }

    public static RecipeBuilder buttonBuilder(ItemLike p_176659_, Ingredient p_176660_) {
        return RecipeProvider.m_176658_((ItemLike)p_176659_, (Ingredient)p_176660_);
    }

    public static RecipeBuilder doorBuilder(ItemLike p_176671_, Ingredient p_176672_) {
        return RecipeProvider.m_176670_((ItemLike)p_176671_, (Ingredient)p_176672_);
    }

    public static RecipeBuilder fenceBuilder(ItemLike p_176679_, Ingredient p_176680_) {
        return RecipeProvider.m_176678_((ItemLike)p_176679_, (Ingredient)p_176680_);
    }

    public static RecipeBuilder fenceGateBuilder(ItemLike p_176685_, Ingredient p_176686_) {
        return RecipeProvider.m_176684_((ItemLike)p_176685_, (Ingredient)p_176686_);
    }

    public static void pressurePlate(Consumer<FinishedRecipe> p_176691_, ItemLike p_176692_, ItemLike p_176693_) {
        RecipeProvider.m_176690_(p_176691_, (ItemLike)p_176692_, (ItemLike)p_176693_);
    }

    public static RecipeBuilder pressurePlateBuilder(ItemLike p_176695_, Ingredient p_176696_) {
        return RecipeProvider.m_176694_((ItemLike)p_176695_, (Ingredient)p_176696_);
    }

    public static void slab(Consumer<FinishedRecipe> p_176701_, ItemLike p_176702_, ItemLike p_176703_) {
        RecipeProvider.m_176700_(p_176701_, (ItemLike)p_176702_, (ItemLike)p_176703_);
    }

    public static RecipeBuilder slabBuilder(ItemLike p_176705_, Ingredient p_176706_) {
        return RecipeProvider.m_176704_((ItemLike)p_176705_, (Ingredient)p_176706_);
    }

    public static RecipeBuilder stairBuilder(ItemLike p_176711_, Ingredient p_176712_) {
        return RecipeProvider.m_176710_((ItemLike)p_176711_, (Ingredient)p_176712_);
    }

    public static RecipeBuilder trapdoorBuilder(ItemLike p_176721_, Ingredient p_176722_) {
        return RecipeProvider.m_176720_((ItemLike)p_176721_, (Ingredient)p_176722_);
    }

    public static RecipeBuilder signBuilder(ItemLike p_176727_, Ingredient p_176728_) {
        return RecipeProvider.m_176726_((ItemLike)p_176727_, (Ingredient)p_176728_);
    }

    public static void coloredWoolFromWhiteWoolAndDye(Consumer<FinishedRecipe> p_126062_, ItemLike p_126063_, ItemLike p_126064_) {
        RecipeProvider.m_126061_(p_126062_, (ItemLike)p_126063_, (ItemLike)p_126064_);
    }

    public static void carpet(Consumer<FinishedRecipe> p_176717_, ItemLike p_176718_, ItemLike p_176719_) {
        RecipeProvider.m_176716_(p_176717_, (ItemLike)p_176718_, (ItemLike)p_176719_);
    }

    public static void coloredCarpetFromWhiteCarpetAndDye(Consumer<FinishedRecipe> p_126070_, ItemLike p_126071_, ItemLike p_126072_) {
        RecipeProvider.m_126069_(p_126070_, (ItemLike)p_126071_, (ItemLike)p_126072_);
    }

    public static void bedFromPlanksAndWool(Consumer<FinishedRecipe> p_126074_, ItemLike p_126075_, ItemLike p_126076_) {
        RecipeProvider.m_126073_(p_126074_, (ItemLike)p_126075_, (ItemLike)p_126076_);
    }

    public static void bedFromWhiteBedAndDye(Consumer<FinishedRecipe> p_126078_, ItemLike p_126079_, ItemLike p_126080_) {
        RecipeProvider.m_126077_(p_126078_, (ItemLike)p_126079_, (ItemLike)p_126080_);
    }

    public static void banner(Consumer<FinishedRecipe> p_126082_, ItemLike p_126083_, ItemLike p_126084_) {
        RecipeProvider.m_126081_(p_126082_, (ItemLike)p_126083_, (ItemLike)p_126084_);
    }

    public static void stainedGlassFromGlassAndDye(Consumer<FinishedRecipe> p_126086_, ItemLike p_126087_, ItemLike p_126088_) {
        RecipeProvider.m_126085_(p_126086_, (ItemLike)p_126087_, (ItemLike)p_126088_);
    }

    public static void stainedGlassPaneFromStainedGlass(Consumer<FinishedRecipe> p_126090_, ItemLike p_126091_, ItemLike p_126092_) {
        RecipeProvider.m_126089_(p_126090_, (ItemLike)p_126091_, (ItemLike)p_126092_);
    }

    public static void stainedGlassPaneFromGlassPaneAndDye(Consumer<FinishedRecipe> p_126094_, ItemLike p_126095_, ItemLike p_126096_) {
        RecipeProvider.m_126093_(p_126094_, (ItemLike)p_126095_, (ItemLike)p_126096_);
    }

    public static void coloredTerracottaFromTerracottaAndDye(Consumer<FinishedRecipe> p_126098_, ItemLike p_126099_, ItemLike p_126100_) {
        RecipeProvider.m_126097_(p_126098_, (ItemLike)p_126099_, (ItemLike)p_126100_);
    }

    public static void concretePowder(Consumer<FinishedRecipe> p_126102_, ItemLike p_126103_, ItemLike p_126104_) {
        RecipeProvider.m_126101_(p_126102_, (ItemLike)p_126103_, (ItemLike)p_126104_);
    }

    public static void stonecutterResultFromBase(Consumer<FinishedRecipe> p_176736_, ItemLike p_176737_, ItemLike p_176738_) {
        RecipeProvider.m_176735_(p_176736_, (ItemLike)p_176737_, (ItemLike)p_176738_);
    }

    public static void stonecutterResultFromBase(Consumer<FinishedRecipe> p_176547_, ItemLike p_176548_, ItemLike p_176549_, int p_176550_) {
        RecipeProvider.m_176546_(p_176547_, (ItemLike)p_176548_, (ItemLike)p_176549_, (int)p_176550_);
    }

    public static void smeltingResultFromBase(Consumer<FinishedRecipe> p_176740_, ItemLike p_176741_, ItemLike p_176742_) {
        RecipeProvider.m_176739_(p_176740_, (ItemLike)p_176741_, (ItemLike)p_176742_);
    }

    public static void nineBlockStorageRecipes(Consumer<FinishedRecipe> p_176744_, ItemLike p_176745_, ItemLike p_176746_) {
        RecipeProvider.m_176743_(p_176744_, (ItemLike)p_176745_, (ItemLike)p_176746_);
    }

    public static void nineBlockStorageRecipesWithCustomPacking(Consumer<FinishedRecipe> p_176563_, ItemLike p_176564_, ItemLike p_176565_, String p_176566_, String p_176567_) {
        RecipeProvider.m_176562_(p_176563_, (ItemLike)p_176564_, (ItemLike)p_176565_, (String)p_176566_, (String)p_176567_);
    }

    public static void nineBlockStorageRecipesRecipesWithCustomUnpacking(Consumer<FinishedRecipe> p_176617_, ItemLike p_176618_, ItemLike p_176619_, String p_176620_, String p_176621_) {
        RecipeProvider.m_176616_(p_176617_, (ItemLike)p_176618_, (ItemLike)p_176619_, (String)p_176620_, (String)p_176621_);
    }

    public static void cookRecipes(Consumer<FinishedRecipe> p_126007_, String p_126008_, SimpleCookingSerializer<?> p_126009_, int p_126010_) {
        RecipeProvider.m_126006_(p_126007_, (String)p_126008_, p_126009_, (int)p_126010_);
    }

    public static void simpleCookingRecipe(Consumer<FinishedRecipe> p_176584_, String p_176585_, SimpleCookingSerializer<?> p_176586_, int p_176587_, ItemLike p_176588_, ItemLike p_176589_, float p_176590_) {
        RecipeProvider.m_176583_(p_176584_, (String)p_176585_, p_176586_, (int)p_176587_, (ItemLike)p_176588_, (ItemLike)p_176589_, (float)p_176590_);
    }

    public static void waxRecipes(Consumer<FinishedRecipe> p_176611_) {
        RecipeProvider.m_176610_(p_176611_);
    }

    public static void generateRecipes(Consumer<FinishedRecipe> p_176581_, BlockFamily p_176582_) {
        RecipeProvider.m_176580_(p_176581_, (BlockFamily)p_176582_);
    }

    public static Block getBaseBlock(BlockFamily p_176524_, BlockFamily.Variant p_176525_) {
        return RecipeProvider.m_176523_((BlockFamily)p_176524_, (BlockFamily.Variant)p_176525_);
    }

    public static EnterBlockTrigger.TriggerInstance insideOf(Block p_125980_) {
        return RecipeProvider.m_125979_((Block)p_125980_);
    }

    public static InventoryChangeTrigger.TriggerInstance has(MinMaxBounds.Ints p_176521_, ItemLike p_176522_) {
        return RecipeProvider.m_176520_((MinMaxBounds.Ints)p_176521_, (ItemLike)p_176522_);
    }

    public static InventoryChangeTrigger.TriggerInstance has(ItemLike p_125978_) {
        return RecipeProvider.m_125977_((ItemLike)p_125978_);
    }

    public static InventoryChangeTrigger.TriggerInstance has(TagKey<Item> p_206407_) {
        return RecipeProvider.m_206406_(p_206407_);
    }

    public static InventoryChangeTrigger.TriggerInstance inventoryTrigger(ItemPredicate ... p_126012_) {
        return RecipeProvider.m_126011_((ItemPredicate[])p_126012_);
    }

    public static String getHasName(ItemLike p_176603_) {
        return RecipeProvider.m_176602_((ItemLike)p_176603_);
    }

    public static String getItemName(ItemLike p_176633_) {
        return RecipeProvider.m_176632_((ItemLike)p_176633_);
    }

    public static String getSimpleRecipeName(ItemLike p_176645_) {
        return RecipeProvider.m_176644_((ItemLike)p_176645_);
    }

    public static String getConversionRecipeName(ItemLike p_176518_, ItemLike p_176519_) {
        return RecipeProvider.m_176517_((ItemLike)p_176518_, (ItemLike)p_176519_);
    }

    public static String getSmeltingRecipeName(ItemLike p_176657_) {
        return RecipeProvider.m_176656_((ItemLike)p_176657_);
    }

    public static String getBlastingRecipeName(ItemLike p_176669_) {
        return RecipeProvider.m_176668_((ItemLike)p_176669_);
    }
}

