/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.repack.registrate.providers;

import dev.xkmc.l2library.repack.registrate.AbstractRegistrate;
import dev.xkmc.l2library.repack.registrate.providers.ProviderType;
import dev.xkmc.l2library.repack.registrate.providers.RegistrateProvider;
import dev.xkmc.l2library.repack.registrate.util.nullness.NonNullSupplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.registries.ForgeRegistries;

public class RegistrateItemModelProvider
extends ItemModelProvider
implements RegistrateProvider {
    private final AbstractRegistrate<?> parent;

    public RegistrateItemModelProvider(AbstractRegistrate<?> parent, DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, parent.getModid(), existingFileHelper);
        this.parent = parent;
    }

    @Override
    public LogicalSide getSide() {
        return LogicalSide.CLIENT;
    }

    protected void registerModels() {
        this.parent.genData(ProviderType.ITEM_MODEL, this);
    }

    public String m_6055_() {
        return "Item models";
    }

    public String modid(NonNullSupplier<? extends ItemLike> item) {
        return ForgeRegistries.ITEMS.getKey((Object)item.get().m_5456_()).m_135827_();
    }

    public String name(NonNullSupplier<? extends ItemLike> item) {
        return ForgeRegistries.ITEMS.getKey((Object)item.get().m_5456_()).m_135815_();
    }

    public ResourceLocation itemTexture(NonNullSupplier<? extends ItemLike> item) {
        return this.modLoc("item/" + this.name(item));
    }

    public ItemModelBuilder blockItem(NonNullSupplier<? extends ItemLike> block) {
        return this.blockItem(block, "");
    }

    public ItemModelBuilder blockItem(NonNullSupplier<? extends ItemLike> block, String suffix) {
        return (ItemModelBuilder)this.withExistingParent(this.name(block), new ResourceLocation(this.modid(block), "block/" + this.name(block) + suffix));
    }

    public ItemModelBuilder blockWithInventoryModel(NonNullSupplier<? extends ItemLike> block) {
        return (ItemModelBuilder)this.withExistingParent(this.name(block), new ResourceLocation(this.modid(block), "block/" + this.name(block) + "_inventory"));
    }

    public ItemModelBuilder blockSprite(NonNullSupplier<? extends ItemLike> block) {
        return this.blockSprite(block, this.modLoc("block/" + this.name(block)));
    }

    public ItemModelBuilder blockSprite(NonNullSupplier<? extends ItemLike> block, ResourceLocation texture) {
        return this.generated(() -> ((ItemLike)block.get()).m_5456_(), texture);
    }

    public ItemModelBuilder generated(NonNullSupplier<? extends ItemLike> item) {
        return this.generated(item, this.itemTexture(item));
    }

    public ItemModelBuilder generated(NonNullSupplier<? extends ItemLike> item, ResourceLocation ... layers) {
        ItemModelBuilder ret = (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(this.name(item))).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"));
        for (int i = 0; i < layers.length; ++i) {
            ret = (ItemModelBuilder)ret.texture("layer" + i, layers[i]);
        }
        return ret;
    }

    public ItemModelBuilder handheld(NonNullSupplier<? extends ItemLike> item) {
        return this.handheld(item, this.itemTexture(item));
    }

    public ItemModelBuilder handheld(NonNullSupplier<? extends ItemLike> item, ResourceLocation texture) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.name(item), "item/handheld")).texture("layer0", texture);
    }
}

