/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.init.events;

import com.google.gson.JsonElement;
import dev.xkmc.l2library.base.menu.SpriteManager;
import dev.xkmc.l2library.base.overlay.OverlayManager;
import dev.xkmc.l2library.init.events.BaseJsonReloadListener;
import dev.xkmc.l2library.serial.network.PacketHandlerWithConfig;
import dev.xkmc.l2library.util.raytrace.EntityTarget;
import dev.xkmc.l2library.util.raytrace.RayTraceUtil;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GenericEventHandler {
    @SubscribeEvent
    public static void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new BaseJsonReloadListener("gui/coords", map -> {
            SpriteManager.CACHE.clear();
            SpriteManager.CACHE.putAll((Map<ResourceLocation, JsonElement>)map);
        }));
        PacketHandlerWithConfig.addReloadListeners(event);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new BaseJsonReloadListener("textures/gui/overlays", map -> map.forEach((k, v) -> {
            String modid = k.m_135827_();
            String[] paths = k.m_135815_().split("/");
            String path = paths[paths.length - 1];
            OverlayManager.get(modid, path).reset((JsonElement)v);
        })));
    }

    @SubscribeEvent
    public static void onDatapackSync(OnDatapackSyncEvent event) {
        PacketHandlerWithConfig.onDatapackSync(event);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        for (EntityTarget target : EntityTarget.LIST) {
            target.tickRender();
        }
    }

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent event) {
        RayTraceUtil.serverTick();
    }
}

