/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.idea.maze.objective;

import dev.xkmc.l2library.idea.maze.objective.MazeCellData;
import dev.xkmc.l2library.idea.maze.objective.MazeGeneralData;
import dev.xkmc.l2library.idea.maze.objective.MazeRegistry;
import java.lang.reflect.Array;
import java.util.Arrays;

public class MazeIterator<T extends MazeCellData<T, E>, E extends MazeGeneralData> {
    public static final int[][] DIRE = new int[][]{{0, -1, 4}, {0, 1, 8}, {-1, 0, 1}, {1, 0, 2}};
    public final T[][] value;
    public final int[][] maze;
    public final int n;
    public final MazeRegistry.Entry<T, E> ent;
    public final E global;

    public MazeIterator(int[][] maze, MazeRegistry.Entry<T, E> entry) {
        this.maze = maze;
        this.ent = entry;
        this.global = (MazeGeneralData)entry.gen.get();
        this.n = maze.length;
        this.value = (MazeCellData[][])Array.newInstance(entry.cls, this.n, maze.length);
    }

    public T iterate(int x, int y, int dire) {
        this.value[x][y] = ((MazeCellData)this.ent.sup.get()).setAccessDire(x, y, dire, this.n);
        int cell = this.maze[x][y];
        MazeCellData[] ans = (MazeCellData[])Array.newInstance(this.ent.cls, 4);
        int j = 0;
        for (int i = 0; i < DIRE.length; ++i) {
            if ((cell & DIRE[i][2]) == 0) continue;
            int nx = x + DIRE[i][0];
            int ny = y + DIRE[i][1];
            if (nx < 0 || nx == this.n || ny < 0 || ny >= this.n || this.value[nx][ny] != null) continue;
            ans[j++] = this.iterate(nx, ny, i);
        }
        this.value[x][y].fillData(this.global, Arrays.copyOf(ans, j));
        return this.value[x][y];
    }
}

