/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.idea.magic;

import dev.xkmc.l2library.idea.magic.HexCell;
import dev.xkmc.l2library.idea.magic.HexDirection;
import dev.xkmc.l2library.idea.magic.HexHandler;
import dev.xkmc.l2library.util.math.Frac;

public class SubHex {
    public final HexHandler.SubHexCore core;
    public int rotation;
    public boolean flip;

    public SubHex(HexHandler.SubHexCore core, int rotation, boolean flip) {
        this.core = core;
        this.rotation = (rotation % 6 + 6) % 6;
        this.flip = flip;
    }

    public Frac[][] getMatrix() {
        Frac[][] ans = new Frac[6][];
        for (int i = 0; i < 6; ++i) {
            int ni = ((this.flip ? 6 - i : i) + this.rotation) % 6;
            for (int j = 0; j < 6; ++j) {
                int nj = ((this.flip ? 6 - j : j) + this.rotation) % 6;
                if (this.core.otho[i][j] == null) continue;
                if (ans[nj] == null) {
                    ans[nj] = new Frac[6];
                }
                ans[nj][ni] = this.core.otho[i][j];
            }
        }
        return ans;
    }

    public int isInvalid(HexCell c) {
        int ans = 0;
        for (int i = 0; i < 6; ++i) {
            boolean set;
            int ni = ((this.flip ? 6 - i : i) + this.rotation) % 6;
            HexDirection dir = HexDirection.values()[ni];
            boolean bl = set = (this.core.exist & 1 << i) != 0;
            if (!c.canWalk(dir)) {
                if (!set) continue;
                ans |= 1 << ni;
                continue;
            }
            if (c.isConnected(dir) == set) continue;
            return ans |= 1 << ni;
        }
        return ans;
    }
}

