/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.idea.infmaze.dim3d;

import dev.xkmc.l2library.idea.infmaze.dim3d.CubeEdge;
import dev.xkmc.l2library.idea.infmaze.dim3d.CubicTree;
import dev.xkmc.l2library.idea.infmaze.dim3d.MazeCell3D;
import dev.xkmc.l2library.idea.infmaze.init.CellContent;
import dev.xkmc.l2library.idea.infmaze.init.GenerationConfig;
import dev.xkmc.l2library.idea.infmaze.pos.BasePos;
import dev.xkmc.l2library.idea.infmaze.pos.MazeAxis;
import java.util.Random;
import javax.annotation.Nullable;

public class GenerationHelper {
    private static final long SEED = -7536165130657561361L;
    private static final long[] SEEDS;
    private final GenerationConfig config;
    public int cellCount;
    public int wallCount;

    private static long shift(long seed, int n) {
        return seed >>> n | seed << 64 - n;
    }

    public GenerationHelper(GenerationConfig config) {
        this.config = config;
    }

    public long getRootCellSeed(long seed, BasePos raw) {
        long sx = (GenerationHelper.shift(seed, 6) + raw.x()) * (GenerationHelper.shift(seed + raw.x(), 12) + SEEDS[0]) + SEEDS[1];
        long sy = (GenerationHelper.shift(seed, 8) + raw.y()) * (GenerationHelper.shift(seed + raw.y(), 14) + SEEDS[2]) + SEEDS[3];
        long sz = (GenerationHelper.shift(seed, 10) + raw.z()) * (GenerationHelper.shift(seed + raw.z(), 16) + SEEDS[4]) + SEEDS[5];
        return seed ^ sx ^ sy ^ sz;
    }

    public long getRootWallSeed(long seed, BasePos raw, MazeAxis axis) {
        long sx = (GenerationHelper.shift(seed, 7) + raw.x()) * (GenerationHelper.shift(seed + raw.x(), 15) + SEEDS[6]) + SEEDS[7];
        long sy = (GenerationHelper.shift(seed, 9) + raw.y()) * (GenerationHelper.shift(seed + raw.y(), 17) + SEEDS[8]) + SEEDS[9];
        long sz = (GenerationHelper.shift(seed, 11) + raw.z()) * (GenerationHelper.shift(seed + raw.z(), 19) + SEEDS[10]) + SEEDS[11];
        long sf = (GenerationHelper.shift(seed, 13) + (long)axis.ordinal()) * (GenerationHelper.shift(seed + (long)axis.ordinal(), 21) + SEEDS[12]) + SEEDS[13];
        return seed ^ sx ^ sy ^ sz ^ sf;
    }

    public int randomizeWallState(long seed) {
        Random r = new Random(GenerationHelper.shift(seed, 23));
        int pass = r.nextInt(4);
        int ans = 1 << pass;
        for (int i = 0; i < 4; ++i) {
            if (!(r.nextDouble() < this.config.wallExtra())) continue;
            ans |= 1 << i;
        }
        return ans;
    }

    public int randomizeCellInternalState(long seed) {
        int i;
        Random r = new Random(GenerationHelper.shift(seed, 25));
        int tree = CubicTree.CUBES[r.nextInt(CubicTree.CUBES.length)];
        int ans = 0;
        for (i = 0; i < 12; ++i) {
            if ((tree >> i & 1) == 0) continue;
            CubeEdge edge = CubeEdge.EDGES[i];
            ans |= 1 << edge.cubeIndex();
        }
        for (i = 0; i < 12; ++i) {
            if (!(r.nextDouble() < this.config.cellExtra())) continue;
            ans |= 1 << i;
        }
        return ans;
    }

    public void getChildrenSeeds(long seed, long[] toFill) {
        Random r = new Random(seed);
        for (int i = 0; i < toFill.length; ++i) {
            toFill[i] = GenerationHelper.shift(r.nextLong(), (i * 3 + 7) % 64);
        }
    }

    @Nullable
    public CellContent getLeaf(MazeCell3D cell, long seed) {
        return this.config.getLeaf(new Random(GenerationHelper.shift(seed, 27) ^ SEEDS[14]), cell);
    }

    static {
        int n = 15;
        SEEDS = new long[n];
        Random r = new Random(-7536165130657561361L);
        for (int i = 0; i < n; ++i) {
            GenerationHelper.SEEDS[i] = GenerationHelper.shift(r.nextLong(), (i * 3 + 7) % 64);
        }
    }
}

