/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.idea.infmaze.dim3d;

import dev.xkmc.l2library.idea.infmaze.dim3d.CubeEdge;
import it.unimi.dsi.fastutil.ints.IntArrayList;

public class CubicTree {
    public static final int[] CUBES;
    private final int[] dots = new int[8];
    private final int conn;

    public CubicTree(int conn) {
        for (int i = 0; i < 8; ++i) {
            this.dots[i] = i;
        }
        this.conn = conn;
    }

    private boolean validate() {
        int count = 0;
        for (int i = 0; i < 12; ++i) {
            if ((this.conn >> i & 1) == 0) continue;
            ++count;
            CubeEdge edge = CubeEdge.EDGES[i];
            if (this.add(edge.a(), edge.b())) continue;
            return false;
        }
        if (count != 7) {
            return false;
        }
        int root = this.root(0);
        for (int i = 1; i < 8; ++i) {
            if (this.root(i) == root) continue;
            return false;
        }
        return true;
    }

    private boolean add(int a, int b) {
        if (this.root(a) == this.root(b)) {
            return false;
        }
        this.dots[this.root((int)a)] = this.root(b);
        return true;
    }

    private int root(int i) {
        if (this.dots[i] == i) {
            return i;
        }
        return this.root(this.dots[i]);
    }

    static {
        IntArrayList list = new IntArrayList();
        for (int i = 0; i < 4096; ++i) {
            CubicTree cube = new CubicTree(i);
            if (!cube.validate()) continue;
            list.add(i);
        }
        CUBES = list.toIntArray();
    }
}

