/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.base.recipe;

import com.google.gson.JsonObject;
import dev.xkmc.l2library.base.recipe.BaseRecipe;
import dev.xkmc.l2library.serial.codec.JsonCodec;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistries;

public class BaseRecipeBuilder<T extends BaseRecipeBuilder<T, Rec, SRec, Inv>, Rec extends SRec, SRec extends BaseRecipe<?, SRec, Inv>, Inv extends Container> {
    protected final BaseRecipe.RecType<Rec, SRec, Inv> type;
    protected final Rec recipe;
    protected final Advancement.Builder advancement = Advancement.Builder.m_138353_();

    public BaseRecipeBuilder(BaseRecipe.RecType<Rec, SRec, Inv> type) {
        this.type = type;
        this.recipe = (BaseRecipe)type.blank();
    }

    public T getThis() {
        return (T)this;
    }

    public T unlockedBy(String name, CriterionTriggerInstance trigger) {
        this.advancement.m_138386_(name, trigger);
        return this.getThis();
    }

    public void save(Consumer<FinishedRecipe> pvd, ResourceLocation id) {
        this.ensureValid(id);
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        pvd.accept(new Result<Rec, SRec, Inv>(this.type, this.recipe, id, this.advancement, new ResourceLocation(id.m_135827_(), "recipes/" + ForgeRegistries.RECIPE_SERIALIZERS.getKey(this.type).m_135815_() + "/" + id.m_135815_())));
    }

    protected void ensureValid(ResourceLocation id) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
    }

    public record Result<Rec extends SRec, SRec extends BaseRecipe<?, SRec, Inv>, Inv extends Container>(BaseRecipe.RecType<Rec, SRec, Inv> type, Rec recipe, ResourceLocation id, Advancement.Builder advancement, ResourceLocation advancementId) implements FinishedRecipe
    {
        public void m_7917_(@Nullable JsonObject json) {
        }

        public JsonObject m_125966_() {
            JsonObject jsonobject = JsonCodec.toJson(this.recipe).getAsJsonObject();
            jsonobject.addProperty("type", ForgeRegistries.RECIPE_SERIALIZERS.getKey(this.m_6637_()).toString());
            return jsonobject;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.type;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

