/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.base.overlay;

import dev.xkmc.l2library.base.overlay.OverlayUtils;

public class TextBox
extends OverlayUtils {
    private final int anchorX;
    private final int anchorY;
    private final int x;
    private final int y;
    private final int width;

    public TextBox(int screenWidth, int screenHeight, int anchorX, int anchorY, int x, int y, int width) {
        super(screenWidth, screenHeight);
        this.anchorX = anchorX;
        this.anchorY = anchorY;
        this.x = x;
        this.y = y;
        this.width = width;
    }

    @Override
    public int getX(int w) {
        return this.x - w * this.anchorX / 2;
    }

    @Override
    public int getY(int h) {
        return this.y - h * this.anchorY / 2;
    }

    @Override
    public int getMaxWidth() {
        if (this.width > 0) {
            return this.width;
        }
        if (this.anchorX == 0) {
            return this.screenWidth - this.x - 8;
        }
        if (this.anchorX == 1) {
            return Math.max(this.x / 2 - 4, this.screenWidth - this.x / 2 - 4);
        }
        if (this.anchorX == 2) {
            return this.x - 8;
        }
        return this.screenWidth;
    }
}

