/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.base.ingredients;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.xkmc.l2library.serial.SerialClass;
import dev.xkmc.l2library.serial.codec.JsonCodec;
import dev.xkmc.l2library.serial.codec.PacketCodec;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;

@SerialClass
public abstract class BaseIngredient<T extends BaseIngredient<T>>
extends AbstractIngredient {
    @Deprecated
    protected BaseIngredient() {
    }

    public BaseIngredient(ItemStack display) {
        super(Stream.of(new Ingredient.ItemValue(display)));
    }

    protected abstract T validate();

    public abstract boolean test(@Nullable ItemStack var1);

    public boolean isSimple() {
        return false;
    }

    public abstract Serializer<T> getSerializer();

    public JsonElement m_43942_() {
        JsonObject obj = JsonCodec.toJson(this).getAsJsonObject();
        obj.addProperty("type", this.getSerializer().id().toString());
        return obj;
    }

    public record Serializer<T extends BaseIngredient<T>>(Class<T> cls, ResourceLocation id) implements IIngredientSerializer<T>
    {
        public T parse(FriendlyByteBuf buffer) {
            return ((BaseIngredient)PacketCodec.from(buffer, this.cls, null)).validate();
        }

        public T parse(JsonObject json) {
            return ((BaseIngredient)JsonCodec.from((JsonElement)json, this.cls, null)).validate();
        }

        public void write(FriendlyByteBuf buffer, T ingredient) {
            PacketCodec.to(buffer, ingredient, this.cls);
        }
    }
}

