/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.base.effects;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.xkmc.l2library.base.effects.EffectSyncEvents;
import dev.xkmc.l2library.base.effects.api.ClientRenderEffect;
import dev.xkmc.l2library.base.effects.api.FirstPlayerRenderEffect;
import dev.xkmc.l2library.util.Proxy;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientEntityEffectRenderEvents {
    private static final ArrayList<DelayedEntityRender> ICONS = new ArrayList();

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (Proxy.getClientPlayer() != null) {
            LocalPlayer player = Proxy.getClientPlayer();
            for (Map.Entry entry : player.m_21221_().entrySet()) {
                Object k = entry.getKey();
                if (!(k instanceof FirstPlayerRenderEffect)) continue;
                FirstPlayerRenderEffect effect = (FirstPlayerRenderEffect)k;
                effect.onClientLevelRender((AbstractClientPlayer)player, (MobEffectInstance)entry.getValue());
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void levelRenderLast(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_WEATHER) {
            return;
        }
        LevelRenderer renderer = event.getLevelRenderer();
        MultiBufferSource.BufferSource buffers = Minecraft.m_91087_().m_91269_().m_110104_();
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        PoseStack stack = event.getPoseStack();
        PoseStack posestack = RenderSystem.m_157191_();
        PoseStack.Pose last = posestack.m_85850_();
        posestack.m_85849_();
        RenderSystem.m_157182_();
        RenderSystem.m_69465_();
        for (DelayedEntityRender icon : ICONS) {
            ClientEntityEffectRenderEvents.renderIcon(icon.entity(), stack, (MultiBufferSource)buffers, icon.rl(), event.getPartialTick(), camera, renderer.f_109463_);
        }
        buffers.m_109911_();
        posestack.m_85836_();
        posestack.m_166856_();
        posestack.m_85850_().m_85861_().m_27644_(last.m_85861_());
        posestack.m_85850_().m_85864_().m_8178_(last.m_85864_());
        RenderSystem.m_157182_();
        RenderSystem.m_69482_();
        ICONS.clear();
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onLivingEntityRender(RenderLivingEvent.Post<?, ?> event) {
        LivingEntity entity = event.getEntity();
        if (EffectSyncEvents.EFFECT_MAP.containsKey(entity.m_20148_())) {
            Map<MobEffect, Integer> map = EffectSyncEvents.EFFECT_MAP.get(entity.m_20148_());
            for (Map.Entry<MobEffect, Integer> entry : map.entrySet()) {
                MobEffect mobEffect = entry.getKey();
                if (!(mobEffect instanceof ClientRenderEffect)) continue;
                ClientRenderEffect effect = (ClientRenderEffect)mobEffect;
                int lv = entry.getValue();
                effect.render(entity, lv, rl -> ICONS.add(new DelayedEntityRender(entity, (ResourceLocation)rl)));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderIcon(LivingEntity entity, PoseStack matrix, MultiBufferSource buffer, ResourceLocation rl, float partial, Camera camera, EntityRenderDispatcher dispatcher) {
        float f = entity.m_20206_() / 2.0f;
        double x0 = Mth.m_14139_((double)partial, (double)entity.f_19790_, (double)entity.m_20185_());
        double y0 = Mth.m_14139_((double)partial, (double)entity.f_19791_, (double)entity.m_20186_());
        double z0 = Mth.m_14139_((double)partial, (double)entity.f_19792_, (double)entity.m_20189_());
        Vec3 offset = dispatcher.m_114382_((Entity)entity).m_7860_((Entity)entity, partial);
        Vec3 cam_pos = camera.m_90583_();
        double d2 = x0 - cam_pos.f_82479_ + offset.m_7096_();
        double d3 = y0 - cam_pos.f_82480_ + offset.m_7098_();
        double d0 = z0 - cam_pos.f_82481_ + offset.m_7094_();
        matrix.m_85836_();
        matrix.m_85837_(d2, d3 + (double)f, d0);
        matrix.m_85845_(camera.m_90591_());
        PoseStack.Pose entry = matrix.m_85850_();
        VertexConsumer ivertexbuilder = buffer.m_6299_(ClientEntityEffectRenderEvents.get2DIcon(rl));
        ClientEntityEffectRenderEvents.iconVertex(entry, ivertexbuilder, 0.5f, -0.5f, 0.0f, 1.0f);
        ClientEntityEffectRenderEvents.iconVertex(entry, ivertexbuilder, -0.5f, -0.5f, 1.0f, 1.0f);
        ClientEntityEffectRenderEvents.iconVertex(entry, ivertexbuilder, -0.5f, 0.5f, 1.0f, 0.0f);
        ClientEntityEffectRenderEvents.iconVertex(entry, ivertexbuilder, 0.5f, 0.5f, 0.0f, 0.0f);
        matrix.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void iconVertex(PoseStack.Pose entry, VertexConsumer builder, float x, float y, float u, float v) {
        builder.m_85982_(entry.m_85861_(), x, y, 0.0f).m_7421_(u, v).m_85977_(entry.m_85864_(), 0.0f, 1.0f, 0.0f).m_5752_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RenderType get2DIcon(ResourceLocation rl) {
        return RenderType.m_173215_((String)"entity_body_icon", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173083_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(rl, false, false)).m_110685_(RenderStateShard.f_110135_).m_110663_(RenderStateShard.f_110111_).m_110691_(false));
    }

    private record DelayedEntityRender(LivingEntity entity, ResourceLocation rl) {
    }
}

