/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.network;

import dev.xkmc.l2backpack.compat.CuriosCompat;
import dev.xkmc.l2backpack.content.backpack.EnderBackpackItem;
import dev.xkmc.l2backpack.content.common.BaseBagItem;
import dev.xkmc.l2backpack.content.common.PlayerSlot;
import dev.xkmc.l2backpack.content.remote.worldchest.WorldChestItem;
import dev.xkmc.l2backpack.content.remote.worldchest.WorldChestMenuPvd;
import dev.xkmc.l2backpack.content.restore.ScreenTracker;
import dev.xkmc.l2backpack.events.ClientEventHandler;
import dev.xkmc.l2backpack.events.quickaccess.QuickAccessClickHandler;
import dev.xkmc.l2backpack.init.advancement.BackpackTriggers;
import dev.xkmc.l2library.serial.SerialClass;
import dev.xkmc.l2library.serial.network.SerialPacketBase;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

@SerialClass
public class SlotClickToServer
extends SerialPacketBase {
    @SerialClass.SerialField
    private int index;
    @SerialClass.SerialField
    private int slot;
    @SerialClass.SerialField
    private int wid;

    @Deprecated
    public SlotClickToServer() {
    }

    public SlotClickToServer(int index, int slot, int wid) {
        this.index = index;
        this.slot = slot;
        this.wid = wid;
    }

    public void handle(NetworkEvent.Context ctx) {
        Item item;
        PlayerSlot playerSlot;
        ItemStack stack;
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        Container container = null;
        AbstractContainerMenu menu = player.f_36096_;
        if (this.wid == -1) {
            stack = player.m_6844_(EquipmentSlot.CHEST);
            playerSlot = PlayerSlot.ofInventory(36 + EquipmentSlot.CHEST.m_20749_());
            if (!ClientEventHandler.canOpen(stack)) {
                stack = CuriosCompat.getSlot((Player)player, ClientEventHandler::canOpen);
                playerSlot = PlayerSlot.ofCurio((Player)player);
            }
        } else if (this.slot >= 0) {
            stack = player.m_150109_().m_8020_(this.slot);
            playerSlot = PlayerSlot.ofInventory(this.slot);
        } else {
            if (this.wid == 0 || menu.f_38840_ == 0 || this.wid != menu.f_38840_) {
                return;
            }
            playerSlot = PlayerSlot.ofOtherInventory(this.slot, this.index, this.wid, menu);
            stack = menu.m_38853_(this.index).m_7993_();
            container = menu.m_38853_((int)this.index).f_40218_;
        }
        if (QuickAccessClickHandler.isAllowed(stack)) {
            QuickAccessClickHandler.handle(player, stack);
            return;
        }
        boolean others = false;
        if (playerSlot != null && (item = stack.m_41720_()) instanceof BaseBagItem) {
            BaseBagItem bag = (BaseBagItem)item;
            bag.open(player, playerSlot, stack);
            if (this.wid != -1 || this.slot != -1 || this.index != -1) {
                ScreenTracker.onServerOpen(player, menu, playerSlot);
            }
        } else if (stack.m_41720_() instanceof EnderBackpackItem) {
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((id, inv, pl) -> ChestMenu.m_39237_((int)id, (Inventory)inv, (Container)pl.m_36327_()), stack.m_41786_()));
        } else {
            item = stack.m_41720_();
            if (item instanceof WorldChestItem) {
                WorldChestItem chest = (WorldChestItem)item;
                others = WorldChestItem.getOwner(stack).map(e -> !e.equals(player.m_20148_())).orElse(false);
                new WorldChestMenuPvd(player, stack, chest).open();
                if (playerSlot != null && (this.wid != -1 || this.slot != -1 || this.index != -1)) {
                    ScreenTracker.onServerOpen(player, menu, playerSlot);
                }
            }
        }
        if (container != null) {
            container.m_6596_();
        }
        if (playerSlot != null) {
            BackpackTriggers.SLOT_CLICK.trigger(player, playerSlot.type(), this.wid == -1 && this.slot == -1 && this.index == -1);
        }
        if (others) {
            BackpackTriggers.SHARE.trigger(player);
        }
    }
}

