/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.events;

import dev.xkmc.l2backpack.content.drawer.BaseDrawerItem;
import dev.xkmc.l2backpack.content.remote.drawer.EnderDrawerBlockEntity;
import dev.xkmc.l2backpack.content.remote.drawer.EnderDrawerItem;
import dev.xkmc.l2backpack.init.L2Backpack;
import dev.xkmc.l2backpack.network.drawer.RequestTooltipUpdateEvent;
import dev.xkmc.l2library.serial.network.SimplePacketBase;
import dev.xkmc.l2library.util.Proxy;
import dev.xkmc.l2library.util.raytrace.RayTraceUtil;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TooltipUpdateEvents {
    private static final int MAX_COOLDOWN = 5;
    private static Step step = Step.NONE;
    private static UUID id = null;
    private static Item focus = null;
    private static int count = 0;
    private static int cooldown = 0;

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!TooltipUpdateEvents.continueSession()) {
            TooltipUpdateEvents.endSession();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean continueSession() {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen cont = (AbstractContainerScreen)screen;
            return TooltipUpdateEvents.screenSession(cont);
        }
        if (screen == null) {
            return TooltipUpdateEvents.blockSession();
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean screenSession(AbstractContainerScreen<?> cont) {
        Slot slot = cont.getSlotUnderMouse();
        if (slot == null) {
            return false;
        }
        ItemStack stack = slot.m_7993_();
        if (!(stack.m_41720_() instanceof EnderDrawerItem)) {
            return false;
        }
        if (BaseDrawerItem.getItem(stack) == Items.f_41852_) {
            return false;
        }
        TooltipUpdateEvents.startSession(BaseDrawerItem.getItem(stack), stack.m_41784_().m_128342_("owner_id"));
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean blockSession() {
        BlockPos pos;
        BlockEntity entity;
        LocalPlayer player = Proxy.getClientPlayer();
        BlockHitResult ray = RayTraceUtil.rayTraceBlock((Level)player.f_19853_, (Player)player, (double)player.getReachDistance());
        if (ray.m_6662_() == HitResult.Type.BLOCK && (entity = player.f_19853_.m_7702_(pos = ray.m_82425_())) instanceof EnderDrawerBlockEntity) {
            EnderDrawerBlockEntity drawer = (EnderDrawerBlockEntity)entity;
            TooltipUpdateEvents.startSession(drawer.item, drawer.owner_id);
            return true;
        }
        return false;
    }

    private static void endSession() {
        step = Step.NONE;
        focus = null;
        count = 0;
        id = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void startSession(Item content, UUID owner) {
        if (step == Step.NONE) {
            focus = content;
            id = owner;
            step = Step.SENT;
            L2Backpack.HANDLER.toServer((SimplePacketBase)new RequestTooltipUpdateEvent(focus, Proxy.getClientPlayer().m_20148_()));
        } else if (step == Step.COOLDOWN) {
            if (cooldown > 0) {
                --cooldown;
            }
            if (cooldown <= 0) {
                cooldown = 0;
                step = Step.NONE;
            }
        }
    }

    public static void updateInfo(Item item, UUID uuid, int val) {
        if (focus != item) {
            return;
        }
        if (step != Step.SENT) {
            return;
        }
        count = val;
        id = uuid;
        step = Step.COOLDOWN;
        cooldown = 5;
    }

    public static int getCount(UUID uuid, Item item) {
        if (id != null && focus != null && id.equals(uuid) && item == focus) {
            return count;
        }
        return -1;
    }

    private static enum Step {
        NONE,
        SENT,
        COOLDOWN;

    }
}

