/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.events;

import com.mojang.datafixers.util.Pair;
import dev.xkmc.l2backpack.content.quickswap.common.IQuickSwapToken;
import dev.xkmc.l2backpack.content.quickswap.common.QuickSwapManager;
import dev.xkmc.l2backpack.content.quickswap.common.QuickSwapOverlay;
import dev.xkmc.l2backpack.content.quickswap.common.QuickSwapType;
import dev.xkmc.l2backpack.init.L2Backpack;
import dev.xkmc.l2backpack.init.data.Keys;
import dev.xkmc.l2backpack.network.SetSelectedToServer;
import dev.xkmc.l2library.serial.network.SimplePacketBase;
import java.util.List;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.entity.living.LivingGetProjectileEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ArrowBagEvents {
    private static final ThreadLocal<Pair<ItemStack, IntConsumer>> TEMP = new ThreadLocal();

    @SubscribeEvent
    public static void onProjectileSearch(LivingGetProjectileEvent event) {
        int selected;
        ItemStack stack;
        Item item = event.getProjectileWeaponItemStack().m_41720_();
        if (!(item instanceof ProjectileWeaponItem)) {
            return;
        }
        ProjectileWeaponItem weapon = (ProjectileWeaponItem)item;
        IQuickSwapToken token = QuickSwapManager.getToken(event.getEntity(), false);
        if (token == null) {
            return;
        }
        if (token.type() != QuickSwapType.ARROW) {
            return;
        }
        List<ItemStack> arrows = token.getList();
        Predicate pred = weapon.m_6437_();
        if (pred.test(stack = arrows.get(selected = token.getSelected()))) {
            TEMP.set((Pair<ItemStack, IntConsumer>)Pair.of((Object)stack, token::shrink));
            event.setProjectileItemStack(stack);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void keyEvent(InputEvent.Key event) {
        if (QuickSwapOverlay.INSTANCE.isScreenOn()) {
            if (event.getKey() == Keys.SWAP.map.getKey().m_84873_() && event.getAction() == 1) {
                L2Backpack.HANDLER.toServer((SimplePacketBase)new SetSelectedToServer(-3));
            } else if (event.getKey() == Keys.UP.map.getKey().m_84873_() && event.getAction() == 1) {
                L2Backpack.HANDLER.toServer((SimplePacketBase)new SetSelectedToServer(-1));
            } else if (event.getKey() == Keys.DOWN.map.getKey().m_84873_() && event.getAction() == 1) {
                L2Backpack.HANDLER.toServer((SimplePacketBase)new SetSelectedToServer(-2));
            } else if (Minecraft.m_91087_().f_91066_.f_92090_.m_90857_()) {
                for (int i = 0; i < 9; ++i) {
                    if (!Minecraft.m_91087_().f_91066_.f_92056_[i].m_90859_()) continue;
                    L2Backpack.HANDLER.toServer((SimplePacketBase)new SetSelectedToServer(i));
                }
            }
        }
    }

    public static void shrink(ItemStack stack, int count) {
        if (TEMP.get() != null && TEMP.get().getFirst() == stack) {
            ((IntConsumer)TEMP.get().getSecond()).accept(count);
        }
    }
}

