/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.restore;

import dev.xkmc.l2backpack.content.common.BaseOpenableContainer;
import dev.xkmc.l2backpack.content.common.ContainerType;
import dev.xkmc.l2backpack.content.common.PlayerSlot;
import dev.xkmc.l2backpack.content.remote.worldchest.WorldChestContainer;
import dev.xkmc.l2backpack.content.restore.LayerPopType;
import dev.xkmc.l2backpack.content.restore.TrackedEntry;
import dev.xkmc.l2backpack.init.L2Backpack;
import dev.xkmc.l2backpack.network.restore.AddTrackedToClient;
import dev.xkmc.l2backpack.network.restore.PopLayerToClient;
import dev.xkmc.l2library.capability.player.PlayerCapabilityHolder;
import dev.xkmc.l2library.capability.player.PlayerCapabilityNetworkHandler;
import dev.xkmc.l2library.capability.player.PlayerCapabilityTemplate;
import dev.xkmc.l2library.serial.SerialClass;
import dev.xkmc.l2library.serial.network.SimplePacketBase;
import java.util.Stack;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;

@SerialClass
public class ScreenTracker
extends PlayerCapabilityTemplate<ScreenTracker> {
    public static final Capability<ScreenTracker> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ScreenTracker>(){});
    public static final PlayerCapabilityHolder<ScreenTracker> HOLDER = new PlayerCapabilityHolder(new ResourceLocation("l2backpack", "screen_tracker"), CAPABILITY, ScreenTracker.class, ScreenTracker::new, PlayerCapabilityNetworkHandler::new);
    final Stack<TrackedEntry> stack = new Stack();
    int wid;
    private BaseOpenableContainer<?> current;
    boolean isWaiting;

    public static void register() {
    }

    public static ScreenTracker get(Player player) {
        return (ScreenTracker)HOLDER.get(player);
    }

    public static void onServerOpen(ServerPlayer player, AbstractContainerMenu prev, PlayerSlot slot) {
        Component component;
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (!(abstractContainerMenu instanceof BaseOpenableContainer)) {
            return;
        }
        BaseOpenableContainer cont = (BaseOpenableContainer)abstractContainerMenu;
        if (prev instanceof BaseOpenableContainer) {
            BaseOpenableContainer prevOpen = (BaseOpenableContainer)prev;
            component = prevOpen.title;
        } else {
            component = null;
        }
        Component comp = component;
        ScreenTracker.get((Player)player).serverOpen(player, ScreenTracker.formPlayerSlot(slot, comp), cont);
    }

    public static void onServerClose(Player player, int wid) {
    }

    private static TrackedEntry formPlayerSlot(PlayerSlot slot, @Nullable Component title) {
        int color = slot.type() == ContainerType.DIMENSION ? slot.slot() / 27 : 0;
        return TrackedEntry.of(slot.type(), slot.uuid(), color, title);
    }

    private void serverOpen(ServerPlayer player, TrackedEntry prev, BaseOpenableContainer<?> cont) {
        int toRemove = 0;
        if (!this.stack.isEmpty()) {
            if (!prev.match(this.current)) {
                toRemove = this.stack.size();
                this.stack.clear();
            } else {
                for (int i = 0; i < this.stack.size(); ++i) {
                    TrackedEntry itr = (TrackedEntry)this.stack.get(i);
                    if (itr.type() != prev.type() || itr.type() == ContainerType.DIMENSION && (!itr.id().equals(prev.id()) || itr.slot() != prev.slot())) continue;
                    toRemove = this.stack.size() - i;
                    for (int j = 0; j < toRemove; ++j) {
                        this.stack.pop();
                    }
                }
            }
        }
        this.stack.push(prev);
        this.current = cont;
        this.wid = cont.f_38840_;
        L2Backpack.HANDLER.toClientPlayer((SimplePacketBase)new AddTrackedToClient(prev, toRemove, this.wid), player);
    }

    public boolean serverRestore(ServerPlayer player, int wid) {
        LayerPopType type;
        if (this.stack.isEmpty()) {
            return false;
        }
        if (this.wid == wid && (type = this.stack.pop().restoreServerMenu(player)) != LayerPopType.FAIL) {
            int id = 0;
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof WorldChestContainer) {
                WorldChestContainer cont = (WorldChestContainer)abstractContainerMenu;
                id = player.f_36096_.f_38840_;
            }
            this.wid = id;
            L2Backpack.HANDLER.toClientPlayer((SimplePacketBase)new PopLayerToClient(type, id), player);
            return true;
        }
        return false;
    }
}

