/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.remote.worldchest;

import dev.xkmc.l2backpack.content.backpack.BackpackContainer;
import dev.xkmc.l2backpack.content.common.BaseOpenableContainer;
import dev.xkmc.l2backpack.content.remote.common.StorageContainer;
import dev.xkmc.l2backpack.content.remote.worldchest.WorldChestBlockEntity;
import dev.xkmc.l2backpack.init.registrate.BackpackMenu;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;

public class WorldChestContainer
extends BaseOpenableContainer<WorldChestContainer> {
    @Nullable
    protected final StorageContainer storage;
    @Nullable
    private final WorldChestBlockEntity activeChest;

    public static WorldChestContainer fromNetwork(MenuType<WorldChestContainer> type, int windowId, Inventory inv) {
        return new WorldChestContainer(windowId, inv, new SimpleContainer(27), null, null, null);
    }

    public WorldChestContainer(int windowId, Inventory inventory, SimpleContainer cont, @Nullable StorageContainer storage, @Nullable WorldChestBlockEntity entity, @Nullable Component title) {
        super((MenuType)BackpackMenu.MT_WORLD_CHEST.get(), windowId, inventory, BackpackContainer.MANAGERS[2], (T menu) -> cont, title);
        this.addSlot("grid", stack -> true);
        this.storage = storage;
        this.activeChest = entity;
    }

    public int getColor() {
        assert (this.storage != null);
        return this.storage.color;
    }

    public UUID getOwner() {
        assert (this.storage != null);
        return this.storage.id;
    }

    public boolean m_6875_(Player player) {
        if (this.activeChest != null && !this.activeChest.stillValid(player)) {
            return false;
        }
        return this.storage == null || this.storage.isValid();
    }
}

