/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.remote.worldchest;

import dev.xkmc.l2backpack.content.remote.common.StorageContainer;
import dev.xkmc.l2backpack.content.remote.common.WorldStorage;
import dev.xkmc.l2backpack.content.remote.worldchest.WorldChestContainer;
import dev.xkmc.l2backpack.content.remote.worldchest.WorldChestInvWrapper;
import dev.xkmc.l2backpack.init.data.LangData;
import dev.xkmc.l2library.base.tile.BaseBlockEntity;
import dev.xkmc.l2library.block.NameSetable;
import dev.xkmc.l2library.serial.SerialClass;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class WorldChestBlockEntity
extends BaseBlockEntity
implements MenuProvider,
NameSetable,
ContainerListener {
    @SerialClass.SerialField
    public UUID owner_id;
    @SerialClass.SerialField(toClient=true)
    public String owner_name;
    @SerialClass.SerialField
    long password;
    @SerialClass.SerialField(toClient=true)
    private int color;
    private Component name;
    private LazyOptional<IItemHandler> handler;
    private boolean added = false;

    public WorldChestBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.f_58857_ != null && !this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER) {
            if (this.f_58857_.m_5776_()) {
                return LazyOptional.of(() -> new InvWrapper((Container)new SimpleContainer(27))).cast();
            }
            if (this.handler == null) {
                Optional<StorageContainer> storage = WorldStorage.get((ServerLevel)this.f_58857_).getOrCreateStorage(this.owner_id, this.color, this.password);
                this.handler = storage.isEmpty() ? LazyOptional.empty() : LazyOptional.of(() -> new WorldChestInvWrapper((Container)((StorageContainer)storage.get()).container, this.owner_id));
            }
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void setColor(int color) {
        if (this.color == color) {
            return;
        }
        this.handler = null;
        this.color = color;
        this.password = color;
        this.m_6596_();
    }

    public Component m_7755_() {
        return this.name == null ? LangData.IDS.STORAGE_OWNER.get(this.owner_name) : this.name;
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int wid, Inventory inventory, Player player) {
        if (this.f_58857_ == null || this.owner_id == null) {
            return null;
        }
        Optional<StorageContainer> storage = this.getAccess();
        if (storage.isEmpty()) {
            return null;
        }
        return new WorldChestContainer(wid, inventory, storage.get().container, storage.get(), this, this.m_5446_());
    }

    public void setCustomName(Component component) {
        this.name = component;
    }

    public boolean stillValid(Player player) {
        assert (this.f_58857_ != null);
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    private Optional<StorageContainer> getAccess() {
        assert (this.f_58857_ != null);
        return WorldStorage.get((ServerLevel)this.f_58857_).getOrCreateStorage(this.owner_id, this.color, this.password);
    }

    public void onChunkUnloaded() {
        this.removeFromListener();
        super.onChunkUnloaded();
    }

    public void m_7651_() {
        this.removeFromListener();
        super.m_7651_();
    }

    public void onLoad() {
        super.onLoad();
        this.addToListener();
    }

    public void addToListener() {
        if (!this.added && this.f_58857_ != null && !this.f_58857_.m_5776_() && this.owner_id != null) {
            this.added = true;
            this.getAccess().ifPresent(e -> e.container.m_19164_((ContainerListener)this));
        }
    }

    public void removeFromListener() {
        if (this.added && this.f_58857_ != null && !this.f_58857_.m_5776_() && this.owner_id != null) {
            this.added = false;
            this.getAccess().ifPresent(e -> e.container.m_19181_((ContainerListener)this));
        }
    }

    public void m_5757_(Container p_18983_) {
        this.m_6596_();
    }
}

