/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.remote.drawer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.xkmc.l2backpack.content.drawer.DrawerBlockEntity;
import dev.xkmc.l2backpack.content.remote.drawer.EnderDrawerBlockEntity;
import dev.xkmc.l2backpack.events.TooltipUpdateEvents;
import dev.xkmc.l2backpack.init.data.LangData;
import dev.xkmc.l2library.util.Proxy;
import dev.xkmc.l2library.util.raytrace.RayTraceUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class EnderPreviewOverlay
implements IGuiOverlay {
    public void render(ForgeGui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        LocalPlayer player = Proxy.getClientPlayer();
        BlockHitResult ray = RayTraceUtil.rayTraceBlock((Level)player.f_19853_, (Player)player, (double)player.getReachDistance());
        if (ray.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos pos = ray.m_82425_();
            BlockEntity entity = player.f_19853_.m_7702_(pos);
            int count = 0;
            Item item = Items.f_41852_;
            if (entity instanceof EnderDrawerBlockEntity) {
                EnderDrawerBlockEntity drawer = (EnderDrawerBlockEntity)entity;
                count = TooltipUpdateEvents.getCount(drawer.owner_id, drawer.item);
                item = drawer.getItem();
            } else if (entity instanceof DrawerBlockEntity) {
                DrawerBlockEntity drawer = (DrawerBlockEntity)entity;
                count = drawer.handler.count;
                item = drawer.getItem();
            }
            if (item != Items.f_41852_) {
                gui.setupOverlayRenderState(true, false);
                MutableComponent text = LangData.IDS.DRAWER_CONTENT.get(item.m_41466_(), count < 0 ? "???" : Integer.valueOf(count));
                EnderPreviewOverlay.renderText(gui, poseStack, (float)screenWidth / 2.0f, (float)screenHeight / 2.0f + 16.0f, (Component)text);
            }
        }
    }

    private static void renderText(ForgeGui gui, PoseStack stack, float x, float y, Component text) {
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        Minecraft mc = gui.getMinecraft();
        Font font = gui.m_93082_();
        font.m_92763_(stack, text, x -= (float)font.m_92852_((FormattedText)text) / 2.0f, y, -1);
        RenderSystem.m_69461_();
    }
}

