/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.remote.drawer;

import dev.xkmc.l2backpack.content.common.ContentTransfer;
import dev.xkmc.l2backpack.content.drawer.BaseDrawerItem;
import dev.xkmc.l2backpack.content.remote.common.DrawerAccess;
import dev.xkmc.l2backpack.content.remote.drawer.EnderDawerItemHandler;
import dev.xkmc.l2backpack.content.remote.drawer.EnderDrawerAnalogBlockEntity;
import dev.xkmc.l2backpack.content.remote.drawer.EnderDrawerBlockEntity;
import dev.xkmc.l2backpack.init.registrate.BackpackBlocks;
import dev.xkmc.l2backpack.init.registrate.BackpackItems;
import dev.xkmc.l2library.block.mult.OnClickBlockMethod;
import dev.xkmc.l2library.block.mult.SetPlacedByBlockMethod;
import dev.xkmc.l2library.block.one.BlockEntityBlockMethod;
import dev.xkmc.l2library.block.one.GetBlockItemBlockMethod;
import dev.xkmc.l2library.block.one.SpecialDropBlockMethod;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class EnderDrawerBlock
implements OnClickBlockMethod,
GetBlockItemBlockMethod,
SpecialDropBlockMethod,
SetPlacedByBlockMethod {
    public static final EnderDrawerBlock INSTANCE = new EnderDrawerBlock();
    public static final BlockEntityBlockMethod<EnderDrawerBlockEntity> TILE_ENTITY_SUPPLIER_BUILDER = new EnderDrawerAnalogBlockEntity<EnderDrawerBlockEntity>(BackpackBlocks.TE_ENDER_DRAWER, EnderDrawerBlockEntity.class);

    public InteractionResult onClick(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockentity = level.m_7702_(pos);
        ItemStack stack = player.m_21120_(hand);
        if (blockentity instanceof EnderDrawerBlockEntity) {
            EnderDrawerBlockEntity chest = (EnderDrawerBlockEntity)blockentity;
            if (!stack.m_41619_() && !stack.m_41782_() && stack.m_41720_() == chest.item) {
                if (!level.m_5776_()) {
                    stack = new EnderDawerItemHandler(chest.getAccess(), false).insertItem(0, stack, false);
                    player.m_21008_(hand, stack);
                } else {
                    ContentTransfer.playDrawerSound(player);
                }
                return InteractionResult.SUCCESS;
            }
            if (stack.m_41619_()) {
                if (!level.m_5776_()) {
                    DrawerAccess access = chest.getAccess();
                    stack = new EnderDawerItemHandler(access, false).extractItem(0, access.item().m_41459_(), false);
                    player.m_21008_(hand, stack);
                } else {
                    ContentTransfer.playDrawerSound(player);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack stack) {
        BlockEntity blockentity = level.m_7702_(pos);
        UUID id = stack.m_41784_().m_128342_("owner_id");
        String name = stack.m_41784_().m_128461_("owner_name");
        if (blockentity instanceof EnderDrawerBlockEntity) {
            EnderDrawerBlockEntity chest = (EnderDrawerBlockEntity)blockentity;
            chest.owner_id = id;
            chest.owner_name = name;
            chest.item = BaseDrawerItem.getItem(stack);
            chest.addToListener();
        }
    }

    public ItemStack getCloneItemStack(BlockGetter world, BlockPos pos, BlockState state) {
        BlockEntity be = world.m_7702_(pos);
        if (be instanceof EnderDrawerBlockEntity) {
            EnderDrawerBlockEntity chest = (EnderDrawerBlockEntity)be;
            return this.buildStack(chest);
        }
        return BackpackItems.ENDER_DRAWER.asStack();
    }

    public List<ItemStack> getDrops(BlockState state, LootContext.Builder builder) {
        BlockEntity blockentity = (BlockEntity)builder.m_78982_(LootContextParams.f_81462_);
        if (blockentity instanceof EnderDrawerBlockEntity) {
            EnderDrawerBlockEntity chest = (EnderDrawerBlockEntity)blockentity;
            return List.of(this.buildStack(chest));
        }
        return List.of(BackpackItems.ENDER_DRAWER.asStack());
    }

    private ItemStack buildStack(EnderDrawerBlockEntity chest) {
        ItemStack stack = BackpackItems.ENDER_DRAWER.asStack();
        if (chest.owner_id != null) {
            stack.m_41784_().m_128362_("owner_id", chest.owner_id);
            stack.m_41784_().m_128359_("owner_name", chest.owner_name);
            ResourceLocation rl = ForgeRegistries.ITEMS.getKey((Object)chest.item);
            assert (rl != null);
            stack.m_41784_().m_128359_("drawerItem", rl.toString());
        }
        return stack;
    }
}

