/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.remote.common;

import dev.xkmc.l2backpack.content.remote.common.WorldStorage;
import dev.xkmc.l2library.serial.SerialClass;
import dev.xkmc.l2library.serial.codec.TagCodec;
import dev.xkmc.l2library.util.code.Wrappers;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.logging.log4j.LogManager;

@SerialClass
public class WorldStorageCapability
implements ICapabilitySerializable<CompoundTag> {
    public final ServerLevel w;
    public final WorldStorage handler;
    public final LazyOptional<WorldStorage> lo;

    public WorldStorageCapability(ServerLevel level) {
        this.w = level;
        if (level == null) {
            LogManager.getLogger().error("world not present");
        }
        this.handler = new WorldStorage(level);
        this.lo = LazyOptional.of(() -> this.handler);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction direction) {
        if (capability == WorldStorage.CAPABILITY) {
            return this.lo.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return TagCodec.toTag((CompoundTag)new CompoundTag(), this.lo.resolve().get());
    }

    public void deserializeNBT(CompoundTag tag) {
        Wrappers.get(() -> (WorldStorage)TagCodec.fromTag((CompoundTag)tag, WorldStorage.class, (Object)this.handler, f -> true));
        this.handler.init();
    }
}

