/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.remote.common;

import dev.xkmc.l2backpack.content.remote.common.DrawerAccess;
import dev.xkmc.l2backpack.content.remote.common.StorageContainer;
import dev.xkmc.l2library.serial.SerialClass;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;

@SerialClass
public class WorldStorage {
    public static Capability<WorldStorage> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<WorldStorage>(){});
    public final ServerLevel level;
    @SerialClass.SerialField
    private final HashMap<String, CompoundTag> storage = new HashMap();
    private final HashMap<UUID, StorageContainer[]> cache = new HashMap();
    @SerialClass.SerialField
    final HashMap<String, HashMap<Item, Integer>> drawer = new HashMap();
    private final HashMap<String, HashMap<Item, DrawerAccess>> drawer_cache = new HashMap();

    public static WorldStorage get(ServerLevel level) {
        return (WorldStorage)level.m_7654_().m_129783_().getCapability(CAPABILITY).resolve().get();
    }

    public WorldStorage(ServerLevel level) {
        this.level = level;
    }

    public Optional<StorageContainer> getOrCreateStorage(UUID id, int color, long password) {
        StorageContainer storage;
        if (this.cache.containsKey(id) && (storage = this.cache.get(id)[color]) != null) {
            if (storage.password == password) {
                return Optional.of(storage);
            }
            return Optional.empty();
        }
        CompoundTag col = this.getColor(id, color, password);
        if (col.m_128454_("password") != password) {
            return Optional.empty();
        }
        StorageContainer storage2 = new StorageContainer(id, color, col);
        this.putStorage(id, color, storage2);
        return Optional.of(storage2);
    }

    public Optional<StorageContainer> getStorageWithoutPassword(UUID id, int color) {
        StorageContainer storage;
        if (this.cache.containsKey(id) && (storage = this.cache.get(id)[color]) != null) {
            return Optional.of(storage);
        }
        Optional<CompoundTag> colOptional = this.getColorWithoutPassword(id, color);
        if (colOptional.isEmpty()) {
            return Optional.empty();
        }
        StorageContainer storage2 = new StorageContainer(id, color, colOptional.get());
        this.putStorage(id, color, storage2);
        return Optional.of(storage2);
    }

    public StorageContainer changePassword(UUID id, int color, long password) {
        this.cache.remove(id);
        CompoundTag col = this.getColor(id, color, password);
        col.m_128356_("password", password);
        StorageContainer storage = new StorageContainer(id, color, col);
        this.putStorage(id, color, storage);
        return storage;
    }

    private void putStorage(UUID id, int color, StorageContainer storage) {
        if (this.cache.containsKey(id)) {
            arr = this.cache.get(id);
        } else {
            arr = new StorageContainer[16];
            this.cache.put(id, arr);
        }
        arr[color] = storage;
    }

    private CompoundTag getColor(UUID id, int color, long password) {
        CompoundTag col;
        CompoundTag ans;
        String sid = id.toString();
        if (!this.storage.containsKey(sid)) {
            ans = new CompoundTag();
            this.storage.put(sid, ans);
            ans.m_128362_("owner_id", id);
        } else {
            ans = this.storage.get(sid);
        }
        if (ans.m_128441_("color_" + color)) {
            col = ans.m_128469_("color_" + color);
        } else {
            col = new CompoundTag();
            col.m_128356_("password", password);
            ans.m_128365_("color_" + color, (Tag)col);
        }
        return col;
    }

    private Optional<CompoundTag> getColorWithoutPassword(UUID id, int color) {
        String sid = id.toString();
        if (!this.storage.containsKey(sid)) {
            return Optional.empty();
        }
        CompoundTag ans = this.storage.get(sid);
        if (!ans.m_128441_("color_" + color)) {
            return Optional.empty();
        }
        CompoundTag col = ans.m_128469_("color_" + color);
        return Optional.of(col);
    }

    public void init() {
    }

    public DrawerAccess getOrCreateDrawer(UUID id, Item item) {
        return this.drawer_cache.computeIfAbsent(id.toString(), e -> new HashMap()).computeIfAbsent(item, i -> new DrawerAccess(this, id, item));
    }
}

