/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.quickswap.quiver;

import dev.xkmc.l2backpack.content.common.PlayerSlot;
import dev.xkmc.l2backpack.content.quickswap.common.IQuickSwapToken;
import dev.xkmc.l2backpack.content.quickswap.common.QuickSwapType;
import dev.xkmc.l2backpack.content.quickswap.common.SimpleMenuPvd;
import dev.xkmc.l2backpack.content.quickswap.common.SingleSwapItem;
import dev.xkmc.l2backpack.content.quickswap.common.SingleSwapToken;
import dev.xkmc.l2backpack.content.quickswap.quiver.QuiverContainer;
import dev.xkmc.l2backpack.content.render.ItemOnBackItem;
import dev.xkmc.l2backpack.init.data.LangData;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class Quiver
extends SingleSwapItem
implements ItemOnBackItem {
    public static float displayArrow(ItemStack stack) {
        int disp = 0;
        for (ItemStack arrow : Quiver.getItems(stack)) {
            if (arrow.m_41619_()) continue;
            ++disp;
        }
        return disp == 0 ? 0.0f : (float)(Math.ceil((float)disp / 3.0f) + 0.5);
    }

    public static boolean isValidStack(ItemStack stack) {
        return stack.m_41720_().m_142095_() && stack.m_41720_() instanceof ArrowItem;
    }

    public Quiver(Item.Properties props) {
        super(props.m_41487_(1).m_41486_());
    }

    @Override
    public void open(ServerPlayer player, PlayerSlot slot, ItemStack stack) {
        new SimpleMenuPvd(player, slot, stack, QuiverContainer::new).open();
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        LangData.addInfo(list, LangData.Info.ARROW_INFO, LangData.Info.INHERIT);
    }

    @Override
    @Nullable
    public IQuickSwapToken getTokenOfType(ItemStack stack, LivingEntity player, QuickSwapType type) {
        if (type != QuickSwapType.ARROW) {
            return null;
        }
        Item item = player.m_21205_().m_41720_();
        if (!(item instanceof ProjectileWeaponItem)) {
            return null;
        }
        ProjectileWeaponItem bow = (ProjectileWeaponItem)item;
        List<ItemStack> list = Quiver.getItems(stack);
        if (list.isEmpty()) {
            return null;
        }
        for (ItemStack arrow : list) {
            if (arrow.m_41619_() || !bow.m_6437_().test(arrow)) continue;
            return new SingleSwapToken(this, stack, QuickSwapType.ARROW);
        }
        return null;
    }

    @Override
    public boolean isValidContent(ItemStack stack) {
        return Quiver.isValidStack(stack);
    }
}

