/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.quickswap.common;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.datafixers.util.Pair;
import dev.xkmc.l2backpack.content.common.BaseBagItem;
import dev.xkmc.l2backpack.content.quickswap.common.IQuickSwapToken;
import dev.xkmc.l2backpack.content.quickswap.common.QuickSwapManager;
import dev.xkmc.l2backpack.content.quickswap.common.QuickSwapType;
import dev.xkmc.l2backpack.init.data.BackpackConfig;
import dev.xkmc.l2library.base.overlay.OverlayUtils;
import dev.xkmc.l2library.base.overlay.SelectionSideBar;
import dev.xkmc.l2library.util.Proxy;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraftforge.client.gui.overlay.ForgeGui;

public class QuickSwapOverlay
extends SelectionSideBar {
    public static QuickSwapOverlay INSTANCE = new QuickSwapOverlay();

    public QuickSwapOverlay() {
        super(40.0f, 3.0f);
    }

    public boolean isScreenOn() {
        IQuickSwapToken token;
        if (Minecraft.m_91087_().f_91080_ != null) {
            return false;
        }
        LocalPlayer player = Proxy.getClientPlayer();
        if (player == null) {
            return false;
        }
        QuickSwapType type = QuickSwapManager.getValidType((LivingEntity)player, Screen.m_96639_());
        if (!Minecraft.m_91087_().f_91066_.f_92090_.m_90857_()) {
            if (type == QuickSwapType.ARROW && ((Boolean)BackpackConfig.CLIENT.showArrowOnlyWithShift.get()).booleanValue()) {
                return false;
            }
            if (type == QuickSwapType.TOOL && ((Boolean)BackpackConfig.CLIENT.showToolOnlyWithShift.get()).booleanValue()) {
                return false;
            }
            if (type == QuickSwapType.ARMOR && ((Boolean)BackpackConfig.CLIENT.showArmorOnlyWithShift.get()).booleanValue()) {
                return false;
            }
        }
        return (token = QuickSwapManager.getToken((LivingEntity)player, Screen.m_96639_())) != null;
    }

    public Pair<List<ItemStack>, Integer> getItems() {
        LocalPlayer player = Proxy.getClientPlayer();
        IQuickSwapToken token = QuickSwapManager.getToken((LivingEntity)player, Screen.m_96639_());
        assert (token != null);
        List<ItemStack> list = token.getList();
        int selected = token.getSelected();
        return Pair.of(list, (Object)selected);
    }

    public int getSignature() {
        LocalPlayer player = Proxy.getClientPlayer();
        IQuickSwapToken token = QuickSwapManager.getToken((LivingEntity)player, Screen.m_96639_());
        assert (token != null);
        int selected = token.getSelected();
        int focus = player.m_150109_().f_35977_;
        int ans = focus * 10 + selected;
        ans += token.type().ordinal() * 100;
        if (token.type() == QuickSwapType.ARROW) {
            return ans;
        }
        if (token.type() == QuickSwapType.TOOL) {
            ans += player.m_21205_().hashCode() & 0xFFFF;
        } else {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (slot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
                ans += player.m_6844_(slot).hashCode() & 0xFFFF;
            }
        }
        return ans;
    }

    public boolean isAvailable(ItemStack stack) {
        LocalPlayer player = Proxy.getClientPlayer();
        QuickSwapType type = QuickSwapManager.getValidType((LivingEntity)player, Screen.m_96639_());
        if (type == QuickSwapType.ARROW) {
            ItemStack bowStack = player.m_21205_();
            Item item = bowStack.m_41720_();
            if (item instanceof ProjectileWeaponItem) {
                ProjectileWeaponItem bow = (ProjectileWeaponItem)item;
                return !stack.m_41619_() && bow.m_6437_().test(stack);
            }
            return false;
        }
        if (type == QuickSwapType.ARMOR) {
            if (stack.m_41619_()) {
                return false;
            }
            EquipmentSlot slot = LivingEntity.m_147233_((ItemStack)stack);
            if (player.m_6844_(slot).m_41720_() instanceof BaseBagItem) {
                return false;
            }
        }
        return true;
    }

    public boolean onCenter() {
        return (Boolean)BackpackConfig.CLIENT.previewOnCenter.get();
    }

    public void render(ForgeGui gui, PoseStack poseStack, float partialTick, int width, int height) {
        super.render(gui, poseStack, partialTick, width, height);
        LocalPlayer player = Proxy.getClientPlayer();
        if (QuickSwapManager.getValidType((LivingEntity)player, Screen.m_96639_()) == QuickSwapType.ARMOR && this.ease_time == this.max_ease) {
            int x = this.getXOffset(width);
            int y = 45 + this.getYOffset(height);
            x = this.onCenter() ? (x -= 18) : (x += 18);
            ItemRenderer renderer = gui.getMinecraft().m_91291_();
            Pair<List<ItemStack>, Integer> pair = this.getItems();
            ItemStack hover = (ItemStack)((List)pair.getFirst()).get((Integer)pair.getSecond());
            EquipmentSlot target = LivingEntity.m_147233_((ItemStack)hover);
            for (int i = 0; i < 4; ++i) {
                EquipmentSlot slot = EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)(3 - i));
                ItemStack stack = player.m_6844_(slot);
                Font font = gui.getMinecraft().f_91062_;
                ItemStack targetStack = player.m_6844_(target);
                this.renderArmorSlot(x, y, 64, target == slot, targetStack.m_41720_() instanceof BaseBagItem);
                if (!stack.m_41619_()) {
                    renderer.m_115203_(stack, x, y);
                    renderer.m_115169_(font, stack, x, y);
                }
                y += 18;
            }
        }
    }

    public void renderSelection(int x, int y, int a, boolean available, boolean selected) {
        RenderSystem.m_69465_();
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        Tesselator tex = Tesselator.m_85913_();
        BufferBuilder builder = tex.m_85915_();
        if (available) {
            OverlayUtils.fillRect((BufferBuilder)builder, (int)x, (int)y, (int)16, (int)16, (int)255, (int)255, (int)255, (int)a);
        } else {
            OverlayUtils.fillRect((BufferBuilder)builder, (int)x, (int)y, (int)16, (int)16, (int)255, (int)0, (int)0, (int)a);
        }
        if (selected) {
            OverlayUtils.drawRect((BufferBuilder)builder, (int)x, (int)y, (int)16, (int)16, (int)255, (int)170, (int)0, (int)255);
        }
        RenderSystem.m_69493_();
        RenderSystem.m_69482_();
    }

    public void renderArmorSlot(int x, int y, int a, boolean target, boolean invalid) {
        RenderSystem.m_69465_();
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        Tesselator tex = Tesselator.m_85913_();
        BufferBuilder builder = tex.m_85915_();
        OverlayUtils.fillRect((BufferBuilder)builder, (int)x, (int)y, (int)16, (int)16, (int)255, (int)255, (int)255, (int)a);
        if (target) {
            if (invalid) {
                OverlayUtils.drawRect((BufferBuilder)builder, (int)x, (int)y, (int)16, (int)16, (int)220, (int)70, (int)70, (int)255);
            } else {
                OverlayUtils.drawRect((BufferBuilder)builder, (int)x, (int)y, (int)16, (int)16, (int)70, (int)150, (int)185, (int)255);
            }
        }
        RenderSystem.m_69493_();
        RenderSystem.m_69482_();
    }

    protected int getXOffset(int width) {
        float progress = (this.max_ease - this.ease_time) / this.max_ease;
        if (this.onCenter()) {
            return width / 2 + 54 + 1 + Math.round(progress * (float)width / 2.0f);
        }
        return width - 36 + Math.round(progress * 20.0f);
    }

    protected int getYOffset(int height) {
        return height / 2 - 81 + 1;
    }
}

