/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.drawer;

import dev.xkmc.l2backpack.content.common.ContentTransfer;
import dev.xkmc.l2backpack.content.drawer.BaseDrawerItem;
import dev.xkmc.l2backpack.content.drawer.DrawerBlockEntity;
import dev.xkmc.l2backpack.content.drawer.DrawerItem;
import dev.xkmc.l2backpack.init.registrate.BackpackBlocks;
import dev.xkmc.l2backpack.init.registrate.BackpackItems;
import dev.xkmc.l2library.block.impl.BlockEntityBlockMethodImpl;
import dev.xkmc.l2library.block.mult.OnClickBlockMethod;
import dev.xkmc.l2library.block.mult.SetPlacedByBlockMethod;
import dev.xkmc.l2library.block.one.BlockEntityBlockMethod;
import dev.xkmc.l2library.block.one.GetBlockItemBlockMethod;
import dev.xkmc.l2library.block.one.SpecialDropBlockMethod;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class DrawerBlock
implements OnClickBlockMethod,
GetBlockItemBlockMethod,
SpecialDropBlockMethod,
SetPlacedByBlockMethod {
    public static final DrawerBlock INSTANCE = new DrawerBlock();
    public static final BlockEntityBlockMethod<DrawerBlockEntity> BLOCK_ENTITY = new BlockEntityBlockMethodImpl(BackpackBlocks.TE_DRAWER, DrawerBlockEntity.class);

    public InteractionResult onClick(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockentity = level.m_7702_(pos);
        ItemStack stack = player.m_21120_(hand);
        if (blockentity instanceof DrawerBlockEntity) {
            DrawerBlockEntity chest = (DrawerBlockEntity)blockentity;
            if (!stack.m_41619_() && !stack.m_41782_() && stack.m_41720_() == chest.getItem() || chest.getItem() == Items.f_41852_) {
                if (!level.m_5776_()) {
                    stack = chest.handler.insertItem(0, stack, false);
                    player.m_21008_(hand, stack);
                } else {
                    ContentTransfer.playDrawerSound(player);
                }
                return InteractionResult.SUCCESS;
            }
            if (stack.m_41619_()) {
                if (!level.m_5776_()) {
                    stack = chest.handler.extractItem(0, chest.getItem().m_41459_(), false);
                    player.m_21008_(hand, stack);
                } else {
                    ContentTransfer.playDrawerSound(player);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack stack) {
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof DrawerBlockEntity) {
            DrawerBlockEntity chest = (DrawerBlockEntity)blockentity;
            chest.handler.count = DrawerItem.getCount(stack);
            chest.handler.item = chest.handler.count == 0 ? Items.f_41852_ : BaseDrawerItem.getItem(stack);
        }
    }

    public ItemStack getCloneItemStack(BlockGetter world, BlockPos pos, BlockState state) {
        BlockEntity be = world.m_7702_(pos);
        if (be instanceof DrawerBlockEntity) {
            DrawerBlockEntity chest = (DrawerBlockEntity)be;
            return this.buildStack(chest);
        }
        return BackpackItems.DRAWER.asStack();
    }

    public List<ItemStack> getDrops(BlockState state, LootContext.Builder builder) {
        BlockEntity blockentity = (BlockEntity)builder.m_78982_(LootContextParams.f_81462_);
        if (blockentity instanceof DrawerBlockEntity) {
            DrawerBlockEntity chest = (DrawerBlockEntity)blockentity;
            return List.of(this.buildStack(chest));
        }
        return List.of(BackpackItems.DRAWER.asStack());
    }

    private ItemStack buildStack(DrawerBlockEntity chest) {
        ItemStack stack = BackpackItems.DRAWER.asStack();
        ResourceLocation rl = ForgeRegistries.ITEMS.getKey((Object)chest.getItem());
        assert (rl != null);
        stack.m_41784_().m_128359_("drawerItem", rl.toString());
        DrawerItem.setCount(stack, chest.handler.count);
        return stack;
    }
}

