/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.common;

import dev.xkmc.l2backpack.init.advancement.BackpackTriggers;
import dev.xkmc.l2backpack.init.advancement.BagInteractTrigger;
import dev.xkmc.l2backpack.init.data.LangData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ContentTransfer {
    public static int transfer(List<ItemStack> list, IItemHandler cap) {
        int n = list.size();
        int count = 0;
        for (int i = 0; i < n; ++i) {
            ItemStack stack = list.get(i);
            count += stack.m_41613_();
            stack = ItemHandlerHelper.insertItemStacked((IItemHandler)cap, (ItemStack)stack, (boolean)false);
            count -= stack.m_41613_();
            list.set(i, stack);
        }
        return count;
    }

    public static int transfer(Item item, int count, IItemHandler cap) {
        int maxSize = item.m_41459_();
        while (count > 0) {
            int step = Math.min(maxSize, count);
            ItemStack toInsert = new ItemStack((ItemLike)item, step);
            ItemStack remainer = ItemHandlerHelper.insertItemStacked((IItemHandler)cap, (ItemStack)toInsert, (boolean)false);
            count = count - step + remainer.m_41613_();
            if (remainer.m_41619_()) continue;
            return count;
        }
        return 0;
    }

    public static int loadFrom(List<ItemStack> list, IItemHandler cap, Player player, Predicate<ItemStack> pred) {
        int i;
        SimpleContainer cont = new SimpleContainer(list.toArray(new ItemStack[0]));
        InvWrapper handler = new InvWrapper((Container)cont);
        int n = cap.getSlots();
        int count = 0;
        block0: for (i = 0; i < n; ++i) {
            ItemStack stack;
            while (!(stack = cap.getStackInSlot(i)).m_41619_() && pred.test(stack)) {
                if (!stack.m_41753_()) {
                    boolean hasSpace = false;
                    int j = 0;
                    while (j < list.size()) {
                        if (cont.m_8020_(i).m_41619_()) {
                            hasSpace = true;
                            break;
                        }
                        ++i;
                    }
                    if (!hasSpace) continue block0;
                    ItemStack removal = cap.extractItem(i, 1, false);
                    ItemStack error = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)removal, (boolean)false);
                    if (!error.m_41619_()) {
                        player.m_36176_(error, true);
                        continue block0;
                    }
                    ++count;
                    continue block0;
                }
                int maxAttempt = Math.min(stack.m_41613_(), stack.m_41741_());
                ItemStack removalSim = cap.extractItem(i, maxAttempt, true);
                ItemStack remain = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)removalSim, (boolean)true);
                if (removalSim.m_41613_() == remain.m_41613_()) continue block0;
                ItemStack removalReal = cap.extractItem(i, removalSim.m_41613_() - remain.m_41613_(), false);
                ItemStack error = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)removalReal, (boolean)false);
                count += removalReal.m_41613_() - error.m_41613_();
                if (!error.m_41619_()) {
                    player.m_36176_(error, true);
                }
                if (error.m_41619_() && removalReal.m_41613_() == maxAttempt) continue;
                continue block0;
            }
        }
        for (i = 0; i < list.size(); ++i) {
            list.set(i, cont.m_8020_(i));
        }
        return count;
    }

    public static int loadFrom(Item item, int space, IItemHandler cap) {
        int n = cap.getSlots();
        int count = 0;
        for (int i = 0; i < n; ++i) {
            ItemStack stack;
            if (space <= 0) {
                return count;
            }
            while (!(stack = cap.getStackInSlot(i)).m_41619_() && !stack.m_41782_() && stack.m_41720_() == item) {
                int allow = Math.min(space, Math.min(stack.m_41741_(), stack.m_41613_()));
                ItemStack removal = cap.extractItem(i, allow, false);
                int toRemove = removal.m_41613_();
                count += toRemove;
                if ((space -= toRemove) > 0) continue;
                return count;
            }
        }
        return count;
    }

    public static InteractionResult blockInteract(UseOnContext context, Quad item) {
        Player player = context.m_43723_();
        if (player != null) {
            LazyOptional capLazy;
            BlockPos pos = context.m_8083_();
            BlockEntity target = context.m_43725_().m_7702_(pos);
            if (target != null && (capLazy = target.getCapability(ForgeCapabilities.ITEM_HANDLER)).resolve().isPresent()) {
                IItemHandler cap = (IItemHandler)capLazy.resolve().get();
                item.click(player, context.m_43722_(), context.m_43725_().m_5776_(), player.m_6144_(), true, cap);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public static void leftClick(Quad load, Level level, BlockPos pos, ItemStack stack, @Nullable Player player) {
        LazyOptional capLazy;
        BlockEntity target;
        if (player != null && (target = level.m_7702_(pos)) != null && (capLazy = target.getCapability(ForgeCapabilities.ITEM_HANDLER)).resolve().isPresent()) {
            IItemHandler cap = (IItemHandler)capLazy.resolve().get();
            load.click(player, stack, level.m_5776_(), player.m_6144_(), false, cap);
        }
    }

    public static void onDump(Player player, int count, ItemStack stack) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_240418_((Component)LangData.IDS.DUMP_FEEDBACK.get(count), true);
            BackpackTriggers.INTERACT.trigger(serverPlayer, stack, BagInteractTrigger.Type.DUMP, count);
        }
    }

    public static void onLoad(Player player, int count, ItemStack stack) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_240418_((Component)LangData.IDS.LOAD_FEEDBACK.get(count), true);
            BackpackTriggers.INTERACT.trigger(serverPlayer, stack, BagInteractTrigger.Type.LOAD, count);
        }
    }

    public static void onExtract(Player player, int count, ItemStack stack) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_240418_((Component)LangData.IDS.EXTRACT_FEEDBACK.get(count), true);
            BackpackTriggers.INTERACT.trigger(serverPlayer, stack, BagInteractTrigger.Type.EXTRACT, count);
        }
    }

    public static void onCollect(Player player, int count, ItemStack stack) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_240418_((Component)LangData.IDS.COLLECT_FEEDBACK.get(count), true);
            BackpackTriggers.INTERACT.trigger(serverPlayer, stack, BagInteractTrigger.Type.COLLECT, count);
        }
    }

    public static void playSound(Player player) {
        player.m_5496_(SoundEvents.f_11678_, 1.0f, 1.0f);
    }

    public static void playDrawerSound(Player player) {
        player.m_5496_(SoundEvents.f_144048_, 1.0f, 1.0f);
    }

    public static Item filterMaxItem(IItemHandler target) {
        HashMap<Item, Integer> map = new HashMap<Item, Integer>();
        for (int i = 0; i < target.getSlots(); ++i) {
            ItemStack stack = target.getStackInSlot(i);
            if (stack.m_41782_()) continue;
            map.compute(stack.m_41720_(), (k, v) -> (v == null ? 0 : v) + stack.m_41613_());
        }
        Item max = Items.f_41852_;
        int count = 0;
        for (Map.Entry ent : map.entrySet()) {
            if ((Integer)ent.getValue() <= count) continue;
            max = (Item)ent.getKey();
            count = (Integer)ent.getValue();
        }
        return max;
    }

    public static interface Quad {
        public void click(Player var1, ItemStack var2, boolean var3, boolean var4, boolean var5, @Nullable IItemHandler var6);
    }
}

