/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.bag;

import dev.xkmc.l2backpack.content.common.ContentTransfer;
import dev.xkmc.l2backpack.init.data.LangData;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class AbstractBag
extends Item
implements ContentTransfer.Quad {
    public static final int SIZE = 64;

    public AbstractBag(Item.Properties props) {
        super(props.m_41487_(1));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        return ContentTransfer.blockInteract(context, this);
    }

    @Override
    public void click(Player player, ItemStack stack, boolean client, boolean shift, boolean right, @Nullable IItemHandler target) {
        CompoundTag tag;
        NonNullList list;
        if (!client && shift && right && target != null) {
            list = NonNullList.m_122780_((int)64, (Object)ItemStack.f_41583_);
            tag = stack.m_41698_("BlockEntityTag");
            if (tag.m_128441_("Items")) {
                ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)list);
            }
            int pre = 0;
            for (ItemStack inv : list) {
                pre += inv.m_41613_();
            }
            ContentTransfer.transfer((List<ItemStack>)list, target);
            int post = 0;
            for (ItemStack inv : list) {
                post += inv.m_41613_();
            }
            ContainerHelper.m_18973_((CompoundTag)tag, (NonNullList)list);
            ContentTransfer.onDump(player, pre - post, stack);
        } else if (client && shift && right && target != null) {
            ContentTransfer.playSound(player);
        }
        if (!client && shift && !right && target != null) {
            list = NonNullList.m_122780_((int)64, (Object)ItemStack.f_41583_);
            tag = stack.m_41698_("BlockEntityTag");
            if (tag.m_128441_("Items")) {
                ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)list);
            }
            int count = ContentTransfer.loadFrom((List<ItemStack>)list, target, player, e -> this.matches(stack, (ItemStack)e));
            ContainerHelper.m_18973_((CompoundTag)tag, (NonNullList)list);
            ContentTransfer.onLoad(player, count, stack);
        } else if (client && shift && !right && target != null) {
            ContentTransfer.playSound(player);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (world.m_5776_()) {
            ContentTransfer.playSound(player);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        NonNullList list = NonNullList.m_122780_((int)64, (Object)ItemStack.f_41583_);
        CompoundTag tag = stack.m_41698_("BlockEntityTag");
        if (tag.m_128441_("Items")) {
            ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)list);
        }
        if (player.m_6144_()) {
            this.throwOut((NonNullList<ItemStack>)list, player, stack);
        } else {
            ArrayDeque<Holder<ItemStack>> queue = new ArrayDeque<Holder<ItemStack>>();
            player.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve().ifPresent(e -> {
                for (int i = 9; i < 36; ++i) {
                    ItemStack inv_stack = (ItemStack)player.m_150109_().f_35974_.get(i);
                    if (!this.matches(stack, inv_stack)) continue;
                    int finalI = i;
                    queue.add(new Holder<ItemStack>(() -> e.getStackInSlot(finalI), () -> e.extractItem(finalI, 1, false)));
                }
            });
            int moved = AbstractBag.add((NonNullList<ItemStack>)list, queue);
            ContentTransfer.onCollect(player, moved, stack);
        }
        ContainerHelper.m_18973_((CompoundTag)tag, (NonNullList)list);
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public abstract boolean matches(ItemStack var1, ItemStack var2);

    public void m_7373_(ItemStack stack, @javax.annotation.Nullable Level world, List<Component> list, TooltipFlag flag) {
        list.add((Component)LangData.IDS.BAG_SIZE.get(this.getSize(stack), 64));
        LangData.addInfo(list, LangData.Info.COLLECT_BAG, LangData.Info.DUMP, LangData.Info.LOAD, LangData.Info.EXTRACT_BAG);
    }

    public boolean m_142522_(ItemStack stack) {
        return this.getSize(stack) < 64;
    }

    public int m_142158_(ItemStack stack) {
        return (int)Math.ceil((float)this.getSize(stack) * 13.0f / 64.0f);
    }

    public int m_142159_(ItemStack stack) {
        return 0xFFFFFF;
    }

    public boolean m_142095_() {
        return false;
    }

    private int getSize(ItemStack stack) {
        NonNullList list = NonNullList.m_122780_((int)64, (Object)ItemStack.f_41583_);
        CompoundTag tag = stack.m_41698_("BlockEntityTag");
        if (tag.m_128441_("Items")) {
            ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)list);
        }
        int ans = 0;
        for (ItemStack is : list) {
            if (is.m_41619_()) continue;
            ++ans;
        }
        return ans;
    }

    private void throwOut(NonNullList<ItemStack> list, Player player, ItemStack bag) {
        int count = 0;
        for (ItemStack stack : list) {
            if (stack.m_41619_()) continue;
            count += stack.m_41613_();
            player.m_150109_().m_150079_(stack.m_41777_());
        }
        ContentTransfer.onExtract(player, count, bag);
        list.clear();
    }

    private static int add(NonNullList<ItemStack> list, Queue<Holder<ItemStack>> toAdd) {
        int count = 0;
        for (int i = 0; i < 64; ++i) {
            if (!((ItemStack)list.get(i)).m_41619_()) continue;
            if (toAdd.isEmpty()) {
                return count;
            }
            Holder<ItemStack> item = toAdd.poll();
            list.set(i, (Object)((ItemStack)item.getter.get()).m_41777_());
            item.remove.run();
            ++count;
        }
        return count;
    }

    private record Holder<T>(Supplier<T> getter, Runnable remove) {
    }
}

