/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.gui.content;

import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.IMenu;
import de.keksuccino.konkrete.input.MouseInput;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;

public class DropdownMenu
implements IMenu {
    private int width;
    private int height;
    private int x;
    private int y;
    private List<AdvancedButton> content = new ArrayList<AdvancedButton>();
    private AdvancedButton dropdown;
    private boolean opened = false;
    private boolean hovered = false;
    private boolean autoclose = false;
    private int space;

    public DropdownMenu(String label, int width, int height, int x, int y, int space) {
        this.width = width;
        this.height = height;
        this.x = x;
        this.y = y;
        this.space = space;
        this.dropdown = new AdvancedButton(0, 0, 0, 0, label, true, press -> this.toggleMenu());
    }

    public void render(PoseStack matrix, int mouseX, int mouseY) {
        float ticks = Minecraft.m_91087_().m_91296_();
        this.updateHovered(mouseX, mouseY);
        this.dropdown.setHeight(this.height);
        this.dropdown.m_93674_(this.width);
        this.dropdown.setX(this.x);
        this.dropdown.setY(this.y);
        this.dropdown.m_6305_(matrix, mouseX, mouseY, ticks);
        int stackedHeight = this.height + this.space;
        if (this.opened) {
            for (AdvancedButton b : this.content) {
                b.setHandleClick(true);
                b.m_93674_(this.width);
                b.setX(this.x);
                b.setY(this.y + stackedHeight);
                b.m_6305_(matrix, mouseX, mouseY, ticks);
                stackedHeight += b.m_93694_() + this.space;
            }
        }
        if (this.autoclose && !this.isHoveredOrFocused() && (MouseInput.isLeftMouseDown() || MouseInput.isRightMouseDown())) {
            this.opened = false;
        }
    }

    private void updateHovered(int mouseX, int mouseY) {
        if (mouseX >= this.dropdown.getX() && mouseX <= this.dropdown.getX() + this.dropdown.m_93694_() && mouseY >= this.dropdown.getY() && mouseY <= this.dropdown.getY() + this.dropdown.m_93694_()) {
            this.hovered = true;
            return;
        }
        for (AdvancedButton b : this.content) {
            if (mouseX < b.getX() || mouseX > b.getX() + b.m_5711_() || mouseY < b.getY() || mouseY > b.getY() + b.m_93694_()) continue;
            this.hovered = true;
            return;
        }
        this.hovered = false;
    }

    public boolean isHoveredOrFocused() {
        if (!this.isOpen()) {
            return false;
        }
        return this.hovered;
    }

    @Override
    public void setUseable(boolean b) {
        this.dropdown.setUseable(b);
        for (AdvancedButton bt : this.content) {
            bt.setUseable(b);
        }
        if (!b) {
            this.opened = false;
        }
    }

    @Override
    public boolean isUseable() {
        if (this.dropdown == null) {
            return false;
        }
        return this.dropdown.isUseable();
    }

    public void setAutoclose(boolean b) {
        this.autoclose = b;
    }

    @Override
    public boolean isOpen() {
        return this.opened;
    }

    public void openMenu() {
        this.opened = true;
    }

    @Override
    public void closeMenu() {
        this.opened = false;
    }

    private void toggleMenu() {
        this.opened = !this.opened;
    }

    public void addContent(AdvancedButton button) {
        this.content.add(button);
    }

    public void setLabel(String text) {
        this.dropdown.setMessage(text);
    }

    public AdvancedButton getDropdownParent() {
        return this.dropdown;
    }
}

