/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiKeyMapping;
import mezz.jei.common.Internal;
import mezz.jei.common.config.DebugConfig;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class JeiTooltip
implements ITooltipBuilder {
    private final List<Component> lines = new ArrayList<Component>();
    @Nullable
    private ITypedIngredient<?> typedIngredient;

    @Override
    public void add(@Nullable Component formattedText) {
        if (formattedText == null) {
            if (Services.PLATFORM.getModHelper().isInDev()) {
                throw new NullPointerException("Tried to add null tooltip text");
            }
            return;
        }
        this.lines.add(formattedText);
    }

    @Override
    public void setIngredient(ITypedIngredient<?> typedIngredient) {
        this.typedIngredient = typedIngredient;
    }

    public void addKeyUsageComponent(String translationKey, IJeiKeyMapping keyMapping) {
        MutableComponent translatedKeyMessage = keyMapping.getTranslatedKeyMessage().m_6881_();
        this.addKeyUsageComponent(translationKey, translatedKeyMessage);
    }

    public void addKeyUsageComponent(String translationKey, MutableComponent keyMapping) {
        MutableComponent boldKeyMapping = keyMapping.m_130940_(ChatFormatting.BOLD);
        MutableComponent component = Component.m_237110_((String)translationKey, (Object[])new Object[]{boldKeyMapping}).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY);
        this.add((Component)component);
    }

    @Override
    public void addAll(Collection<? extends Component> components) {
        for (Component component : components) {
            this.add(component);
        }
    }

    @Override
    public void clear() {
        this.lines.clear();
        this.typedIngredient = null;
    }

    public void addAll(JeiTooltip tooltip) {
        this.lines.addAll(tooltip.lines);
    }

    public boolean isEmpty() {
        return this.lines.isEmpty() && this.typedIngredient == null;
    }

    public String toString() {
        return this.lines.stream().map(FormattedText::getString).collect(Collectors.joining("\n", "[\n", "\n]"));
    }

    public void draw(PoseStack poseStack, int x, int y) {
        if (this.typedIngredient != null) {
            this.draw(poseStack, x, y, this.typedIngredient);
            return;
        }
        if (this.isEmpty()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        Screen screen = minecraft.f_91080_;
        if (screen == null) {
            return;
        }
        Font font = minecraft.f_91062_;
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        try {
            renderHelper.renderTooltip(screen, poseStack, this.lines, Optional.empty(), x, y, font, ItemStack.f_41583_);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Crashed when rendering tooltip:\n" + this);
        }
    }

    private <T> void draw(PoseStack poseStack, int x, int y, ITypedIngredient<T> typedIngredient) {
        IIngredientType<T> ingredientType = typedIngredient.getType();
        IIngredientManager ingredientManager = Internal.getJeiRuntime().getIngredientManager();
        IIngredientRenderer<T> ingredientRenderer = ingredientManager.getIngredientRenderer(ingredientType);
        this.draw(poseStack, x, y, typedIngredient, ingredientRenderer, ingredientManager);
    }

    public <T> void draw(PoseStack poseStack, int x, int y, ITypedIngredient<T> typedIngredient, IIngredientRenderer<T> ingredientRenderer, IIngredientManager ingredientManager) {
        Minecraft minecraft = Minecraft.m_91087_();
        Screen screen = minecraft.f_91080_;
        if (screen == null) {
            return;
        }
        T ingredient = typedIngredient.getIngredient();
        Font font = ingredientRenderer.getFontRenderer(minecraft, ingredient);
        ItemStack itemStack = typedIngredient.getItemStack().orElse(ItemStack.f_41583_);
        Optional tooltipImage = itemStack.m_150921_();
        this.addDebugInfo(ingredientManager, typedIngredient);
        IJeiHelpers jeiHelpers = Internal.getJeiRuntime().getJeiHelpers();
        IModIdHelper modIdHelper = jeiHelpers.getModIdHelper();
        modIdHelper.getModNameForTooltip(typedIngredient).ifPresent(this::add);
        if (this.isEmpty()) {
            return;
        }
        try {
            IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
            renderHelper.renderTooltip(screen, poseStack, this.lines, tooltipImage, x, y, font, itemStack);
        }
        catch (RuntimeException e) {
            CrashReport crashReport = ErrorUtil.createIngredientCrashReport(e, "Rendering ingredient tooltip", ingredientManager, typedIngredient);
            crashReport.m_127514_("tooltip").m_128159_("value", (Object)this);
            throw new ReportedException(crashReport);
        }
    }

    private <T> void addDebugInfo(IIngredientManager ingredientManager, ITypedIngredient<T> typedIngredient) {
        if (!DebugConfig.isDebugInfoTooltipsEnabled() || !Minecraft.m_91087_().f_91066_.f_92125_) {
            return;
        }
        T ingredient = typedIngredient.getIngredient();
        IIngredientType<T> type = typedIngredient.getType();
        IIngredientHelper<T> ingredientHelper = ingredientManager.getIngredientHelper(type);
        this.add((Component)Component.m_237119_());
        this.add((Component)Component.m_237113_((String)"JEI Debug:").m_130940_(ChatFormatting.DARK_GRAY));
        this.add((Component)Component.m_237113_((String)("\u2022 type: " + ingredientHelper.getIngredientType().getIngredientClass())).m_130940_(ChatFormatting.DARK_GRAY));
        this.add((Component)Component.m_237113_((String)("\u2022 uid: " + ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient))).m_130940_(ChatFormatting.DARK_GRAY));
        this.add((Component)Component.m_237113_((String)("\u2022 extra info: " + ingredientHelper.getErrorInfo(ingredient))).m_130940_(ChatFormatting.DARK_GRAY));
        this.add((Component)Component.m_237119_());
    }

    @Override
    public List<Component> getLegacyComponents() {
        return this.lines;
    }
}

