/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.particle.FogParticleOptions;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class FogParticle
extends TextureSheetParticle {
    private static final Vector3f ROTATION_VECTOR = (Vector3f)Util.m_137469_((Object)new Vector3f(0.5f, 0.5f, 0.5f), Vector3f::m_122278_);
    private static final Vector3f TRANSFORM_VECTOR = new Vector3f(-1.0f, -1.0f, 0.0f);
    private static final float DEGREES_90 = 1.5707964f;

    FogParticle(ClientLevel pLevel, double pX, double pY, double pZ, double xd, double yd, double zd, FogParticleOptions options) {
        super(pLevel, pX, pY, pZ, 0.0, 0.0, 0.0);
        float mag = 0.3f;
        this.f_107215_ = xd + (Math.random() * 2.0 - 1.0) * (double)mag;
        this.f_107216_ = yd + (Math.random() * 2.0 - 1.0) * (double)mag;
        this.f_107217_ = zd + (Math.random() * 2.0 - 1.0) * (double)mag;
        double d0 = (Math.random() + Math.random() + 1.0) * (double)mag * (double)0.3f;
        double d1 = Math.sqrt(this.f_107215_ * this.f_107215_ + this.f_107216_ * this.f_107216_ + this.f_107217_ * this.f_107217_);
        this.f_107215_ = this.f_107215_ / d1 * d0 * (double)mag;
        this.f_107216_ = this.f_107216_ / d1 * d0 * (double)mag + (double)(mag * 0.25f);
        this.f_107217_ = this.f_107217_ / d1 * d0 * (double)mag;
        this.f_107663_ = 1.5f * options.m_175813_();
        this.f_107225_ = Utils.random.m_216332_(60, 120);
        this.f_107226_ = 0.1f;
        float f = this.f_107223_.m_188501_() * 0.14f + 0.85f;
        this.f_107227_ = options.m_175812_().m_122239_() * f;
        this.f_107228_ = options.m_175812_().m_122260_() * f;
        this.f_107229_ = options.m_175812_().m_122269_() * f;
        this.f_172258_ = 1.0f;
    }

    public float m_5902_(float pScaleFactor) {
        return this.f_107663_ * (1.0f + Mth.m_14036_((float)(((float)this.f_107224_ + pScaleFactor) / (float)this.f_107225_ * 0.75f), (float)0.0f, (float)1.0f)) * Mth.m_14036_((float)((float)this.f_107224_ / 5.0f), (float)0.0f, (float)1.0f);
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.f_107216_ -= 0.04 * (double)this.f_107226_;
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.f_107216_ *= (double)0.85f;
            this.f_107215_ *= (double)0.94f;
            this.f_107217_ *= (double)0.94f;
        }
    }

    private float noise(float offset) {
        float f = 10.0f * Mth.m_14031_((float)(offset * 0.01f));
        return f;
    }

    public void m_5744_(VertexConsumer buffer, Camera camera, float partialticks) {
        this.f_107230_ = 1.0f - Mth.m_14036_((float)(((float)this.f_107224_ + partialticks - 20.0f) / (float)this.f_107225_), (float)0.2f, (float)0.7f);
        this.renderRotatedParticle(buffer, camera, partialticks, p_234005_ -> {
            p_234005_.m_80148_(Vector3f.f_122225_.m_122270_(0.0f));
            p_234005_.m_80148_(Vector3f.f_122223_.m_122270_(-1.5707964f));
        });
        this.renderRotatedParticle(buffer, camera, partialticks, p_234000_ -> {
            p_234000_.m_80148_(Vector3f.f_122225_.m_122270_((float)(-Math.PI)));
            p_234000_.m_80148_(Vector3f.f_122223_.m_122270_(1.5707964f));
        });
    }

    private void renderRotatedParticle(VertexConsumer pConsumer, Camera camera, float partialTick, Consumer<Quaternion> pQuaternion) {
        Vec3 vec3 = camera.m_90583_();
        float f = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        Quaternion quaternion = new Quaternion(ROTATION_VECTOR, 0.0f, true);
        pQuaternion.accept(quaternion);
        TRANSFORM_VECTOR.m_122251_(quaternion);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f3 = this.m_5902_(partialTick);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.m_122251_(quaternion);
            vector3f.m_122261_(f3);
            vector3f.m_122272_(f, f1, f2);
        }
        int j = this.m_6355_(partialTick);
        this.makeCornerVertex(pConsumer, avector3f[0], this.m_5952_(), this.m_5950_(), j);
        this.makeCornerVertex(pConsumer, avector3f[1], this.m_5952_(), this.m_5951_(), j);
        this.makeCornerVertex(pConsumer, avector3f[2], this.m_5970_(), this.m_5951_(), j);
        this.makeCornerVertex(pConsumer, avector3f[3], this.m_5970_(), this.m_5950_(), j);
    }

    private void makeCornerVertex(VertexConsumer pConsumer, Vector3f pVec3f, float p_233996_, float p_233997_, int p_233998_) {
        Vec3 wiggle = new Vec3((double)this.noise((float)((double)this.f_107224_ + this.f_107212_)), (double)this.noise((float)((double)this.f_107224_ - this.f_107212_)), (double)this.noise((float)((double)this.f_107224_ + this.f_107214_))).m_82490_((double)0.02f);
        pConsumer.m_5483_((double)pVec3f.m_122239_() + wiggle.f_82479_, (double)(pVec3f.m_122260_() + 0.08f + this.f_107230_ * 0.125f), (double)pVec3f.m_122269_() + wiggle.f_82481_).m_7421_(p_233996_, p_233997_).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(p_233998_).m_5752_();
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    protected int m_6355_(float pPartialTick) {
        BlockPos blockpos = new BlockPos(this.f_107212_, this.f_107213_, this.f_107214_).m_7494_();
        return this.f_107208_.m_46805_(blockpos) ? LevelRenderer.m_109541_((BlockAndTintGetter)this.f_107208_, (BlockPos)blockpos) : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<FogParticleOptions> {
        private final SpriteSet sprite;

        public Provider(SpriteSet pSprite) {
            this.sprite = pSprite;
        }

        public Particle createParticle(@NotNull FogParticleOptions options, @NotNull ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            FogParticle shriekparticle = new FogParticle(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed, options);
            shriekparticle.m_108335_(this.sprite);
            shriekparticle.m_107271_(1.0f);
            return shriekparticle;
        }
    }
}

