/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.mixin;

import com.mojang.datafixers.DataFixer;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.datafix.IronsTagTraverser;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.BiFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelStorageSource.class})
public abstract class DataFixLevelStorageSourceMixin {
    @Unique
    private static final Object iron_sSpells_nSpellbooks$sync = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"readLevelData"}, at={@At(value="HEAD")})
    private void readLevelData(LevelStorageSource.LevelDirectory pLevelDirectory, BiFunction<Path, DataFixer, Object> pLevelDatReader, CallbackInfoReturnable<Object> cir) {
        if (Files.exists(pLevelDirectory.f_230850_(), new LinkOption[0])) {
            Path path = pLevelDirectory.m_230858_();
            try {
                Object object = iron_sSpells_nSpellbooks$sync;
                synchronized (object) {
                    CompoundTag compoundTag1 = NbtIo.m_128937_((File)path.toFile());
                    CompoundTag compoundTag2 = compoundTag1.m_128469_("Data");
                    CompoundTag compoundTag3 = compoundTag2.m_128469_("Player");
                    IronsTagTraverser ironsTraverser = new IronsTagTraverser();
                    ironsTraverser.visit((Tag)compoundTag3);
                    if (ironsTraverser.changesMade()) {
                        NbtIo.m_128944_((CompoundTag)compoundTag1, (File)path.toFile());
                        IronsSpellbooks.LOGGER.debug("DataFixLevelStorageSourceMixin: Single player inventory updated: {} updates", (Object)ironsTraverser.totalChanges());
                    }
                }
            }
            catch (Exception exception) {
                IronsSpellbooks.LOGGER.warn("DataFixLevelStorageSourceMixin failed to load {}, {}", (Object)path, (Object)exception.getMessage());
            }
        }
    }
}

