/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.mobs;

import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.effect.SummonTimer;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;

public interface MagicSummon
extends AntiMagicSusceptible {
    public LivingEntity getSummoner();

    public void onUnSummon();

    @Override
    default public void onAntiMagic(MagicData playerMagicData) {
        this.onUnSummon();
    }

    default public boolean shouldIgnoreDamage(DamageSource damageSource) {
        if (!damageSource.m_19378_() && damageSource instanceof EntityDamageSource && !((Boolean)ServerConfigs.CAN_ATTACK_OWN_SUMMONS.get()).booleanValue()) {
            return this.getSummoner() != null && damageSource.m_7639_() != null && (damageSource.m_7639_().equals((Object)this.getSummoner()) || this.getSummoner().m_7307_(damageSource.m_7639_()));
        }
        return false;
    }

    default public boolean isAlliedHelper(Entity entity) {
        OwnableEntity ownableEntity;
        if (this.getSummoner() == null) {
            return false;
        }
        boolean isFellowSummon = entity == this.getSummoner() || entity.m_7307_((Entity)this.getSummoner());
        boolean hasCommonOwner = entity instanceof OwnableEntity && (ownableEntity = (OwnableEntity)entity).m_21826_() == this.getSummoner();
        return isFellowSummon || hasCommonOwner;
    }

    default public void onDeathHelper() {
        MagicSummon magicSummon = this;
        if (magicSummon instanceof LivingEntity) {
            LivingEntity livingEntity;
            LivingEntity entity = (LivingEntity)magicSummon;
            Level level = entity.f_19853_;
            Component deathMessage = entity.m_21231_().m_19293_();
            if (!level.f_46443_ && level.m_46469_().m_46207_(GameRules.f_46142_) && (livingEntity = this.getSummoner()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                player.m_213846_(deathMessage);
            }
        }
    }

    default public void onRemovedHelper(Entity entity, SummonTimer timer) {
        LivingEntity livingEntity;
        Entity.RemovalReason reason = entity.m_146911_();
        if (reason != null && (livingEntity = this.getSummoner()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (reason.m_146965_()) {
                MobEffectInstance effect = player.m_21124_((MobEffect)timer);
                if (effect != null) {
                    MobEffectInstance decrement = new MobEffectInstance((MobEffect)timer, effect.m_19557_(), effect.m_19564_() - 1, false, false, true);
                    if (decrement.m_19564_() >= 0) {
                        player.m_21221_().put(timer, decrement);
                        player.f_8906_.m_9829_((Packet)new ClientboundUpdateMobEffectPacket(player.m_19879_(), decrement));
                    } else {
                        player.m_21195_((MobEffect)timer);
                    }
                }
                if (reason.equals((Object)Entity.RemovalReason.DISCARDED)) {
                    player.m_213846_((Component)Component.m_237110_((String)"ui.irons_spellbooks.summon_despawn_message", (Object[])new Object[]{((Entity)this).m_5446_()}));
                }
            }
        }
    }
}

