/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.indestructible.world.ai.task;

import com.nameless.indestructible.world.capability.AdvancedCustomHumanoidMobPatch;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BackUpIfTooClose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ProjectileWeaponItem;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class GuardBehavior<E extends Mob>
extends BackUpIfTooClose<E> {
    private final AdvancedCustomHumanoidMobPatch<?> mobpatch;
    private final float radiusSqr;
    private int targetInactiontime = -1;

    public GuardBehavior(AdvancedCustomHumanoidMobPatch<?> customHumanoidMobPatch, float radius) {
        super(1, 1.0f);
        this.mobpatch = customHumanoidMobPatch;
        this.radiusSqr = radius * radius;
    }

    protected boolean m_6114_(ServerLevel level, E mob) {
        return this.checkTargetValid() && this.mobpatch.isBlocking();
    }

    protected boolean canStillUse(ServerLevel level, E mob, long p_22547_) {
        return this.m_6114_(level, mob) && !this.targetInaction();
    }

    public void m_6735_(ServerLevel level, E mob, long p_22507_) {
        this.targetInactiontime = -1;
        this.mobpatch.resetActionTick();
    }

    public void stop(ServerLevel level, E mob, long p_22550_) {
        this.targetInactiontime = -1;
        this.mobpatch.setParryCounter(0);
        this.mobpatch.setBlocking(false);
        this.mobpatch.getAnimator().resetLivingAnimations();
    }

    private boolean checkTargetValid() {
        LivingEntity livingentity = this.mobpatch.getTarget();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
    }

    private boolean withinDistance() {
        LivingEntity target = this.mobpatch.getTarget();
        return ((PathfinderMob)this.mobpatch.getOriginal()).m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_()) <= (double)this.radiusSqr;
    }

    private boolean targetInaction() {
        LivingEntityPatch target = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)this.mobpatch.getTarget(), LivingEntityPatch.class);
        if (target == null) {
            return true;
        }
        return this.targetInactiontime > this.mobpatch.getBlockTick();
    }

    public void tick(ServerLevel level, E mob, long p_22553_) {
        LivingEntityPatch targetPatch;
        LivingEntity target = this.mobpatch.getTarget();
        if (target != null && (targetPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)target, LivingEntityPatch.class)) != null) {
            int phase = targetPatch.getEntityState().getLevel();
            this.targetInactiontime = this.withinDistance() && phase > 0 && phase < 3 ? 0 : (this.mobpatch.canBlockProjectile() && target.m_21211_().m_41720_() instanceof ProjectileWeaponItem && target.m_6117_() ? 0 : ++this.targetInactiontime);
        }
    }
}

