/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.indestructible.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.nameless.indestructible.api.animation.types.CommandEvent;
import com.nameless.indestructible.data.ExtraPredicate;
import com.nameless.indestructible.gameasset.GuardAnimations;
import com.nameless.indestructible.main.Indestructible;
import com.nameless.indestructible.network.SPDatapackSync;
import com.nameless.indestructible.world.capability.AdvancedCustomHumanoidMobPatch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.data.reloader.MobPatchReloadListener;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.mesh.HumanoidMesh;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.network.server.SPPlayAnimation;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.capabilities.provider.EntityPatchProvider;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;

public class AdvancedMobpatchReloader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().create();
    private static final Map<EntityType<?>, CompoundTag> TAGMAP = Maps.newHashMap();
    private static final Map<EntityType<?>, MobPatchReloadListener.AbstractMobPatchProvider> ADVANCED_MOB_PATCH_PROVIDERS = Maps.newHashMap();

    public AdvancedMobpatchReloader() {
        super(GSON, "advanced_mobpatch");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        for (Map.Entry<ResourceLocation, JsonElement> entry : objectIn.entrySet()) {
            ResourceLocation rl = entry.getKey();
            String pathString = rl.m_135815_();
            ResourceLocation registryName = new ResourceLocation(rl.m_135827_(), pathString);
            if (!ForgeRegistries.ENTITY_TYPES.containsKey(registryName)) {
                Indestructible.LOGGER.warn("[Custom Entity] Entity named " + registryName + " does not exist");
                continue;
            }
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(registryName);
            CompoundTag tag = null;
            try {
                tag = TagParser.m_129359_((String)entry.getValue().toString());
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
            ADVANCED_MOB_PATCH_PROVIDERS.put(entityType, AdvancedMobpatchReloader.deserializeMobPatchProvider(entityType, tag, false));
            EntityPatchProvider.putCustomEntityPatch((EntityType)entityType, entity -> () -> ADVANCED_MOB_PATCH_PROVIDERS.get(entity.m_6095_()).get(entity));
            TAGMAP.put(entityType, AdvancedMobpatchReloader.filterClientData(tag));
            if (!EpicFightMod.isPhysicalClient()) continue;
            ClientEngine.getInstance().renderEngine.registerCustomEntityRenderer(entityType, tag.m_128441_("preset") ? tag.m_128461_("preset") : tag.m_128461_("renderer"));
        }
    }

    public static AdvancedCustomHumanoidMobPatchProvider deserializeMobPatchProvider(EntityType<?> entityType, CompoundTag tag, boolean clientSide) {
        AdvancedCustomHumanoidMobPatchProvider provider = new AdvancedCustomHumanoidMobPatchProvider();
        provider.attributeValues = AdvancedMobpatchReloader.deserializeAdvancedAttributes(tag.m_128469_("attributes"));
        ResourceLocation modelLocation = new ResourceLocation(tag.m_128461_("model"));
        ResourceLocation armatureLocation = new ResourceLocation(tag.m_128461_("armature"));
        modelLocation = new ResourceLocation(modelLocation.m_135827_(), "animmodels/" + modelLocation.m_135815_() + ".json");
        armatureLocation = new ResourceLocation(armatureLocation.m_135827_(), "animmodels/" + armatureLocation.m_135815_() + ".json");
        if (EpicFightMod.isPhysicalClient()) {
            Minecraft mc = Minecraft.m_91087_();
            Meshes.getOrCreateAnimatedMesh((ResourceManager)mc.m_91098_(), (ResourceLocation)modelLocation, HumanoidMesh::new);
            Armature armature = Armatures.getOrCreateArmature((ResourceManager)mc.m_91098_(), (ResourceLocation)armatureLocation, HumanoidArmature::new);
            Armatures.registerEntityTypeArmature(entityType, (Armature)armature);
        } else {
            Armature armature = Armatures.getOrCreateArmature(null, (ResourceLocation)armatureLocation, HumanoidArmature::new);
            Armatures.registerEntityTypeArmature(entityType, (Armature)armature);
        }
        provider.hasBossBar = tag.m_128441_("boss_bar") && tag.m_128471_("boss_bar");
        provider.name = tag.m_128441_("boss_bar") && tag.m_128441_("custom_name") ? tag.m_128461_("custom_name") : null;
        provider.bossBar = tag.m_128441_("boss_bar") && tag.m_128441_("custom_texture") ? ResourceLocation.m_135820_((String)tag.m_128461_("custom_texture")) : null;
        provider.defaultAnimations = MobPatchReloadListener.deserializeDefaultAnimations((CompoundTag)tag.m_128469_("default_livingmotions"));
        provider.faction = Faction.valueOf((String)tag.m_128461_("faction").toUpperCase(Locale.ROOT));
        provider.scale = tag.m_128469_("attributes").m_128441_("scale") ? (float)tag.m_128469_("attributes").m_128459_("scale") : 1.0f;
        float f = provider.maxStunShield = tag.m_128469_("attributes").m_128441_("max_stun_shield") ? (float)tag.m_128469_("attributes").m_128459_("max_stun_shield") : 0.0f;
        if (!clientSide) {
            provider.stunAnimations = MobPatchReloadListener.deserializeStunAnimations((CompoundTag)tag.m_128469_("stun_animations"));
            provider.chasingSpeed = tag.m_128469_("attributes").m_128459_("chasing_speed");
            provider.AHCombatBehaviors = AdvancedMobpatchReloader.deserializeAdvancedCombatBehaviors(tag.m_128437_("combat_behavior", 10));
            provider.AHWeaponMotions = MobPatchReloadListener.deserializeHumanoidWeaponMotions((ListTag)tag.m_128437_("humanoid_weapon_motions", 10));
            provider.guardMotions = AdvancedMobpatchReloader.deserializeGuardMotions(tag.m_128437_("custom_guard_motion", 10));
            provider.regenStaminaStandbyTime = tag.m_128469_("attributes").m_128441_("stamina_regan_delay") ? tag.m_128469_("attributes").m_128451_("stamina_regan_delay") : 30;
            provider.hasStunReduction = !tag.m_128469_("attributes").m_128441_("has_stun_reduction") || tag.m_128469_("attributes").m_128471_("has_stun_reduction");
            provider.reganShieldStandbyTime = tag.m_128469_("attributes").m_128441_("stun_shield_regan_delay") ? tag.m_128469_("attributes").m_128451_("stun_shield_regan_delay") : 30;
            provider.reganShieldMultiply = tag.m_128469_("attributes").m_128441_("stun_shield_regan_multiply") ? (float)tag.m_128469_("attributes").m_128459_("stun_shield_multiply") : 1.0f;
            provider.staminaLoseMultiply = tag.m_128469_("attributes").m_128441_("stamina_lose_multiply") ? (float)tag.m_128469_("attributes").m_128459_("stamina_lose_multiply") : 0.0f;
            provider.attackRadius = tag.m_128469_("attributes").m_128441_("attack_radius") ? (float)tag.m_128469_("attributes").m_128459_("attack_radius") : 1.5f;
            provider.guardRadius = tag.m_128469_("attributes").m_128441_("guard_radius") ? (float)tag.m_128469_("attributes").m_128459_("guard_radius") : 3.0f;
            provider.stunEvent = AdvancedMobpatchReloader.deserializeStunCommandList(tag.m_128437_("stun_command_list", 10));
        }
        return provider;
    }

    public static CompoundTag filterClientData(CompoundTag tag) {
        CompoundTag clientTag = new CompoundTag();
        AdvancedMobpatchReloader.extractBranch(clientTag, tag);
        return clientTag;
    }

    public static CompoundTag extractBranch(CompoundTag extract, CompoundTag original) {
        extract.m_128365_("model", original.m_128423_("model"));
        extract.m_128365_("armature", original.m_128423_("armature"));
        extract.m_128379_("isHumanoid", original.m_128441_("isHumanoid") ? original.m_128471_("isHumanoid") : false);
        extract.m_128365_("renderer", original.m_128423_("renderer"));
        extract.m_128365_("faction", original.m_128423_("faction"));
        extract.m_128365_("default_livingmotions", original.m_128423_("default_livingmotions"));
        extract.m_128365_("attributes", original.m_128423_("attributes"));
        if (original.m_128441_("boss_bar")) {
            extract.m_128365_("boss_bar", original.m_128423_("boss_bar"));
            if (original.m_128441_("custom_name")) {
                extract.m_128365_("custom_name", original.m_128423_("custom_name"));
            }
            if (original.m_128441_("custom_texture")) {
                extract.m_128365_("custom_texture", original.m_128423_("custom_texture"));
            }
        }
        return extract;
    }

    public static Stream<CompoundTag> getDataStream() {
        Stream<CompoundTag> tagStream = TAGMAP.entrySet().stream().map(entry -> {
            ((CompoundTag)entry.getValue()).m_128359_("id", ForgeRegistries.ENTITY_TYPES.getKey((Object)((EntityType)entry.getKey())).toString());
            return (CompoundTag)entry.getValue();
        });
        return tagStream;
    }

    public static int getTagCount() {
        return TAGMAP.size();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void processServerPacket(SPDatapackSync packet) {
        for (CompoundTag tag : packet.getTags()) {
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(tag.m_128461_("id")));
            ADVANCED_MOB_PATCH_PROVIDERS.put(entityType, AdvancedMobpatchReloader.deserializeMobPatchProvider(entityType, tag, true));
            EntityPatchProvider.putCustomEntityPatch((EntityType)entityType, entity -> () -> ADVANCED_MOB_PATCH_PROVIDERS.get(entity.m_6095_()).get(entity));
            Minecraft mc = Minecraft.m_91087_();
            ResourceLocation armatureLocation = new ResourceLocation(tag.m_128461_("armature"));
            armatureLocation = new ResourceLocation(armatureLocation.m_135827_(), "animmodels/" + armatureLocation.m_135815_() + ".json");
            boolean humanoid = tag.m_128471_("isHumanoid");
            Armature armature = Armatures.getOrCreateArmature((ResourceManager)mc.m_91098_(), (ResourceLocation)armatureLocation, (Armatures.ArmatureContructor)(humanoid ? Armature::new : HumanoidArmature::new));
            Armatures.registerEntityTypeArmature((EntityType)entityType, (Armature)armature);
            ClientEngine.getInstance().renderEngine.registerCustomEntityRenderer(entityType, tag.m_128441_("preset") ? tag.m_128461_("preset") : tag.m_128461_("renderer"));
        }
    }

    public static Map<Attribute, Double> deserializeAdvancedAttributes(CompoundTag tag) {
        HashMap attributes = Maps.newHashMap();
        attributes.put((Attribute)EpicFightAttributes.WEIGHT.get(), tag.m_128441_("weight") ? tag.m_128459_("weight") : 40.0);
        attributes.put((Attribute)EpicFightAttributes.IMPACT.get(), tag.m_128441_("impact") ? tag.m_128459_("impact") : 0.5);
        attributes.put((Attribute)EpicFightAttributes.ARMOR_NEGATION.get(), tag.m_128441_("armor_negation") ? tag.m_128459_("armor_negation") : 0.0);
        attributes.put((Attribute)EpicFightAttributes.MAX_STAMINA.get(), tag.m_128441_("max_stamina") ? tag.m_128459_("max_stamina") : 15.0);
        attributes.put((Attribute)EpicFightAttributes.STAMINA_REGEN.get(), tag.m_128441_("stamina_regan_multiply") ? tag.m_128459_("stamina_regan_multiply") : 1.0);
        attributes.put((Attribute)EpicFightAttributes.MAX_STRIKES.get(), Double.valueOf(tag.m_128425_("max_strikes", 3) ? tag.m_128451_("max_strikes") : 1));
        if (tag.m_128425_("attack_damage", 6)) {
            attributes.put(Attributes.f_22281_, tag.m_128459_("attack_damage"));
        }
        return attributes;
    }

    public static Map<WeaponCategory, Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>> deserializeAdvancedCombatBehaviors(ListTag tag) {
        HashMap combatBehaviorsMapBuilder = Maps.newHashMap();
        for (int i = 0; i < tag.size(); ++i) {
            CompoundTag combatBehavior = tag.m_128728_(i);
            ListTag categories = combatBehavior.m_128437_("weapon_categories", 8);
            Style style = (Style)Style.ENUM_MANAGER.get(combatBehavior.m_128461_("style"));
            CombatBehaviors.Builder builder = AdvancedMobpatchReloader.deserializeAdvancedBehaviorsBuilder(combatBehavior.m_128437_("behavior_series", 10));
            for (int j = 0; j < categories.size(); ++j) {
                WeaponCategory category = (WeaponCategory)WeaponCategory.ENUM_MANAGER.get(categories.m_128778_(j));
                combatBehaviorsMapBuilder.computeIfAbsent(category, key -> Maps.newHashMap());
                ((Map)combatBehaviorsMapBuilder.get(category)).put(style, builder);
            }
        }
        return combatBehaviorsMapBuilder;
    }

    public static Map<WeaponCategory, Map<Style, AdvancedCustomHumanoidMobPatch.GuardMotion>> deserializeGuardMotions(ListTag tag) {
        HashMap map = Maps.newHashMap();
        for (int i = 0; i < tag.size(); ++i) {
            Tag weponTypeTag;
            CompoundTag list = tag.m_128728_(i);
            Style style = (Style)Style.ENUM_MANAGER.get(list.m_128461_("style"));
            StaticAnimation guard = list.m_128441_("guard") ? EpicFightMod.getInstance().animationManager.findAnimationByPath(list.m_128461_("guard")) : GuardAnimations.MOB_LONGSWORD_GUARD;
            float guard_cost = list.m_128441_("stamina_cost_multiply") ? (float)list.m_128459_("stamina_cost_multiply") : 1.0f;
            boolean canBlockProjectile = list.m_128441_("can_block_projectile") && list.m_128471_("can_block_projectile");
            float parry_cost = list.m_128441_("parry_cost_multiply") ? (float)list.m_128459_("parry_cost_multiply") : 0.5f;
            StaticAnimation[] parry_animations = null;
            if (list.m_128441_("parry_animation")) {
                ListTag animationId = list.m_128437_("parry_animation", 8);
                parry_animations = new StaticAnimation[animationId.size()];
                for (int j = 0; j < animationId.size(); ++j) {
                    StaticAnimation parry_animation;
                    parry_animations[j] = parry_animation = EpicFightMod.getInstance().animationManager.findAnimationByPath(animationId.m_128778_(j));
                }
            }
            if ((weponTypeTag = list.m_128423_("weapon_categories")) instanceof StringTag) {
                WeaponCategory weaponCategory = (WeaponCategory)WeaponCategory.ENUM_MANAGER.get(weponTypeTag.m_7916_());
                if (!map.containsKey(weaponCategory)) {
                    map.put(weaponCategory, Maps.newHashMap());
                }
                ((Map)map.get(weaponCategory)).put(style, new AdvancedCustomHumanoidMobPatch.GuardMotion(guard, canBlockProjectile, guard_cost, parry_cost, parry_animations));
                continue;
            }
            if (!(weponTypeTag instanceof ListTag)) continue;
            ListTag weponTypesTag = (ListTag)weponTypeTag;
            for (int j = 0; j < weponTypesTag.size(); ++j) {
                WeaponCategory weaponCategory = (WeaponCategory)WeaponCategory.ENUM_MANAGER.get(weponTypesTag.m_128778_(j));
                if (!map.containsKey(weaponCategory)) {
                    map.put(weaponCategory, Maps.newHashMap());
                }
                ((Map)map.get(weaponCategory)).put(style, new AdvancedCustomHumanoidMobPatch.GuardMotion(guard, canBlockProjectile, guard_cost, parry_cost, parry_animations));
            }
        }
        return map;
    }

    private static <T extends MobPatch<?>> CombatBehaviors.Builder<T> deserializeAdvancedBehaviorsBuilder(ListTag tag) {
        CombatBehaviors.Builder builder = CombatBehaviors.builder();
        for (int i = 0; i < tag.size(); ++i) {
            CompoundTag behaviorSeries = tag.m_128728_(i);
            float weight = (float)behaviorSeries.m_128459_("weight");
            int cooldown = behaviorSeries.m_128441_("cooldown") ? behaviorSeries.m_128451_("cooldown") : 0;
            boolean canBeInterrupted = behaviorSeries.m_128441_("canBeInterrupted") && behaviorSeries.m_128471_("canBeInterrupted");
            boolean looping = behaviorSeries.m_128441_("looping") && behaviorSeries.m_128471_("looping");
            ListTag behaviorList = behaviorSeries.m_128437_("behaviors", 10);
            CombatBehaviors.BehaviorSeries.Builder behaviorSeriesBuilder = CombatBehaviors.BehaviorSeries.builder();
            behaviorSeriesBuilder.weight(weight).cooldown(cooldown).canBeInterrupted(canBeInterrupted).looping(looping);
            for (int j = 0; j < behaviorList.size(); ++j) {
                int hurt_level;
                CombatBehaviors.Behavior.Builder behaviorBuilder = CombatBehaviors.Behavior.builder();
                CompoundTag behavior = behaviorList.m_128728_(j);
                ListTag conditionList = behavior.m_128437_("conditions", 10);
                int phase = behavior.m_128441_("set_phase") ? behavior.m_128451_("set_phase") : -1;
                int n = hurt_level = behavior.m_128441_("end_by_hurt_level") ? behavior.m_128451_("end_by_hurt_level") : 2;
                if (behavior.m_128441_("animation")) {
                    StaticAnimation animation = EpicFightMod.getInstance().animationManager.findAnimationByPath(behavior.m_128461_("animation"));
                    float speed = behavior.m_128441_("play_speed") ? (float)behavior.m_128459_("play_speed") : 1.0f;
                    float stamina = behavior.m_128441_("stamina") ? (float)behavior.m_128459_("stamina") : 0.0f;
                    float convertTime = behavior.m_128441_("convert_time") ? (float)behavior.m_128459_("convert_time") : 0.0f;
                    AdvancedCustomHumanoidMobPatch.CustomAnimationMotion motion = new AdvancedCustomHumanoidMobPatch.CustomAnimationMotion(animation, convertTime, speed, stamina);
                    List<CommandEvent.TimeStampedEvent> timeCommandList = behavior.m_128441_("command_list") ? AdvancedMobpatchReloader.deserializeTimeCommandList(behavior.m_128437_("command_list", 10)) : null;
                    List<CommandEvent.HitEvent> hitCommandList = behavior.m_128441_("hit_command_list") ? AdvancedMobpatchReloader.deserializeHitCommandList(behavior.m_128437_("hit_command_list", 10)) : null;
                    AdvancedCustomHumanoidMobPatch.DamageSourceModifier modifier = behavior.m_128441_("damage_modifier") ? AdvancedMobpatchReloader.deserializeDamageModifier(behavior.m_128469_("damage_modifier")) : null;
                    behaviorBuilder.behavior(AdvancedMobpatchReloader.customAttackAnimation(motion, modifier, timeCommandList, hitCommandList, phase, hurt_level));
                } else if (behavior.m_128441_("guard")) {
                    int guardTime = behavior.m_128451_("guard");
                    StaticAnimation counter = behavior.m_128441_("counter") ? EpicFightMod.getInstance().animationManager.findAnimationByPath(behavior.m_128461_("counter")) : GuardAnimations.MOB_COUNTER_ATTACK;
                    boolean isParry = behavior.m_128441_("parry") && behavior.m_128471_("parry");
                    int parry_times = behavior.m_128441_("parry_times") ? behavior.m_128451_("parry_times") : Integer.MAX_VALUE;
                    int stun_immunity_time = behavior.m_128441_("stun_immunity_time") ? behavior.m_128451_("stun_immunity_time") : 0;
                    float cost = behavior.m_128441_("counter_cost") ? (float)behavior.m_128459_("counter_cost") : 3.0f;
                    float chance = behavior.m_128441_("counter_chance") ? (float)behavior.m_128459_("counter_chance") : 0.3f;
                    float speed = behavior.m_128441_("counter_speed") ? (float)behavior.m_128459_("counter_speed") : 1.0f;
                    AdvancedCustomHumanoidMobPatch.CounterMotion counterMotion = new AdvancedCustomHumanoidMobPatch.CounterMotion(counter, cost, chance, speed);
                    boolean cancel = !behavior.m_128441_("cancel_after_counter") || behavior.m_128471_("cancel_after_counter");
                    AdvancedCustomHumanoidMobPatch.GuardMotion guardMotion = behavior.m_128441_("specific_guard_motion") ? AdvancedMobpatchReloader.deserializeSpecificGuardMotion(behavior.m_128469_("specific_guard_motion")) : null;
                    behaviorBuilder.behavior(AdvancedMobpatchReloader.setGuardMotion(guardTime, isParry, parry_times, stun_immunity_time, counterMotion, cancel, guardMotion, phase, hurt_level));
                } else if (behavior.m_128441_("wander")) {
                    int strafingTime = behavior.m_128451_("wander");
                    int inactionTime = behavior.m_128441_("inaction_time") ? behavior.m_128451_("inaction_time") : behavior.m_128451_("wander");
                    float forward = behavior.m_128441_("z_axis") ? (float)behavior.m_128459_("z_axis") : 0.0f;
                    float clockwise = behavior.m_128441_("x_axis") ? (float)behavior.m_128459_("x_axis") : 0.0f;
                    behaviorBuilder.behavior(AdvancedMobpatchReloader.setStrafing(strafingTime, inactionTime, forward, clockwise, phase, hurt_level));
                }
                for (int k = 0; k < conditionList.size(); ++k) {
                    CompoundTag condition = conditionList.m_128728_(k);
                    CombatBehaviors.BehaviorPredicate<T> predicate = AdvancedMobpatchReloader.deserializeAdvancedBehaviorPredicate(condition.m_128461_("predicate"), condition);
                    behaviorBuilder.predicate(predicate);
                }
                behaviorSeriesBuilder.nextBehavior(behaviorBuilder);
            }
            builder.newBehaviorSeries(behaviorSeriesBuilder);
        }
        return builder;
    }

    private static <T extends MobPatch<?>> Consumer<T> customAttackAnimation(AdvancedCustomHumanoidMobPatch.CustomAnimationMotion motion, @Nullable AdvancedCustomHumanoidMobPatch.DamageSourceModifier damageSourceModifier, @Nullable List<CommandEvent.TimeStampedEvent> timeEvents, @Nullable List<CommandEvent.HitEvent> hitEvents, int phase, int hurtResist) {
        return mobpatch -> {
            if (mobpatch instanceof AdvancedCustomHumanoidMobPatch) {
                AdvancedCustomHumanoidMobPatch advancedCustomHumanoidMobPatch = (AdvancedCustomHumanoidMobPatch)((Object)mobpatch);
                advancedCustomHumanoidMobPatch.setHurtResistLevel(hurtResist);
                advancedCustomHumanoidMobPatch.setAttackSpeed(motion.speed());
                advancedCustomHumanoidMobPatch.setBlocking(false);
                if (motion.stamina() != 0.0f) {
                    advancedCustomHumanoidMobPatch.setStamina(advancedCustomHumanoidMobPatch.getStamina() - motion.stamina());
                }
                if (timeEvents != null) {
                    for (Object event : timeEvents) {
                        advancedCustomHumanoidMobPatch.addEvent((CommandEvent.TimeStampedEvent)event);
                    }
                }
                if (hitEvents != null) {
                    for (Object event : hitEvents) {
                        advancedCustomHumanoidMobPatch.addEvent((CommandEvent.HitEvent)event);
                    }
                }
                advancedCustomHumanoidMobPatch.setDamageSourceModifier(damageSourceModifier);
                if (phase >= 0) {
                    advancedCustomHumanoidMobPatch.setPhase(phase);
                }
            }
            if (!mobpatch.getEntityState().turningLocked()) {
                ((Mob)mobpatch.getOriginal()).m_21391_((Entity)mobpatch.getTarget(), 30.0f, 30.0f);
            }
            mobpatch.playAnimationSynchronized(motion.animation(), motion.convertTime(), SPPlayAnimation::new);
        };
    }

    private static AdvancedCustomHumanoidMobPatch.GuardMotion deserializeSpecificGuardMotion(CompoundTag args) {
        StaticAnimation guard = args.m_128441_("guard") ? EpicFightMod.getInstance().animationManager.findAnimationByPath(args.m_128461_("guard")) : GuardAnimations.MOB_LONGSWORD_GUARD;
        float guard_cost = args.m_128441_("stamina_cost_multiply") ? (float)args.m_128459_("stamina_cost_multiply") : 1.0f;
        boolean canBlockProjectile = args.m_128441_("can_block_projectile") && args.m_128471_("can_block_projectile");
        float parry_cost = args.m_128441_("parry_cost_multiply") ? (float)args.m_128459_("parry_cost_multiply") : 0.5f;
        StaticAnimation[] parry_animations = null;
        if (args.m_128441_("parry_animation")) {
            ListTag animationId = args.m_128437_("parry_animation", 8);
            parry_animations = new StaticAnimation[animationId.size()];
            for (int j = 0; j < animationId.size(); ++j) {
                StaticAnimation parry_animation;
                parry_animations[j] = parry_animation = EpicFightMod.getInstance().animationManager.findAnimationByPath(animationId.m_128778_(j));
            }
        }
        return new AdvancedCustomHumanoidMobPatch.GuardMotion(guard, canBlockProjectile, guard_cost, parry_cost, parry_animations);
    }

    public static <T extends MobPatch<?>> Consumer<T> setGuardMotion(int guardTime, boolean parry, int parry_time, int stun_immunity_time, AdvancedCustomHumanoidMobPatch.CounterMotion counter_motion, boolean cancel, @Nullable AdvancedCustomHumanoidMobPatch.GuardMotion guard_motion, int phase, int hurtResist) {
        return mobpatch -> {
            if (mobpatch instanceof AdvancedCustomHumanoidMobPatch) {
                AdvancedCustomHumanoidMobPatch advancedCustomHumanoidMobPatch = (AdvancedCustomHumanoidMobPatch)((Object)mobpatch);
                advancedCustomHumanoidMobPatch.setHurtResistLevel(hurtResist);
                advancedCustomHumanoidMobPatch.specificGuardMotion(guard_motion);
                advancedCustomHumanoidMobPatch.setBlocking(true);
                advancedCustomHumanoidMobPatch.setBlockTick(guardTime);
                advancedCustomHumanoidMobPatch.setParry(parry);
                advancedCustomHumanoidMobPatch.setMaxParryTimes(parry_time);
                advancedCustomHumanoidMobPatch.setStunImmunityTime(stun_immunity_time);
                advancedCustomHumanoidMobPatch.setCounterMotion(counter_motion);
                advancedCustomHumanoidMobPatch.cancelBlock(cancel);
                if (phase >= 0) {
                    advancedCustomHumanoidMobPatch.setPhase(phase);
                }
            }
        };
    }

    public static <T extends MobPatch<?>> Consumer<T> setStrafing(int strafingTime, int inactionTime, float forward, float clockwise, int phase, int hurtResist) {
        return mobpatch -> {
            if (mobpatch instanceof AdvancedCustomHumanoidMobPatch) {
                AdvancedCustomHumanoidMobPatch advancedCustomHumanoidMobPatch = (AdvancedCustomHumanoidMobPatch)((Object)mobpatch);
                advancedCustomHumanoidMobPatch.setHurtResistLevel(hurtResist);
                advancedCustomHumanoidMobPatch.setStrafingTime(strafingTime);
                advancedCustomHumanoidMobPatch.setInactionTime(inactionTime);
                advancedCustomHumanoidMobPatch.setStrafingDirection(forward, clockwise);
                if (phase >= 0) {
                    advancedCustomHumanoidMobPatch.setPhase(phase);
                }
            }
        };
    }

    private static List<CommandEvent.TimeStampedEvent> deserializeTimeCommandList(ListTag args) {
        ArrayList list = Lists.newArrayList();
        for (int k = 0; k < args.size(); ++k) {
            CompoundTag command = args.m_128728_(k);
            boolean execute_at_target = command.m_128441_("execute_at_target") && command.m_128471_("execute_at_target");
            CommandEvent.TimeStampedEvent event = CommandEvent.TimeStampedEvent.CreateTimeCommandEvent(command.m_128457_("time"), command.m_128461_("command"), execute_at_target);
            list.add(event);
        }
        return list;
    }

    private static List<CommandEvent.HitEvent> deserializeHitCommandList(ListTag args) {
        ArrayList list = Lists.newArrayList();
        for (int k = 0; k < args.size(); ++k) {
            CompoundTag command = args.m_128728_(k);
            boolean execute_at_target = command.m_128441_("execute_at_target") && command.m_128471_("execute_at_target");
            CommandEvent.HitEvent event = CommandEvent.HitEvent.CreateHitCommandEvent(command.m_128461_("command"), execute_at_target);
            list.add(event);
        }
        return list;
    }

    private static List<CommandEvent.StunEvent> deserializeStunCommandList(ListTag args) {
        ArrayList list = Lists.newArrayList();
        for (int k = 0; k < args.size(); ++k) {
            CompoundTag command = args.m_128728_(k);
            boolean execute_at_target = command.m_128441_("execute_at_target") && command.m_128471_("execute_at_target");
            CommandEvent.StunEvent event = CommandEvent.StunEvent.CreateStunCommandEvent(command.m_128461_("command"), execute_at_target, StunType.valueOf((String)command.m_128461_("stun_type").toUpperCase(Locale.ROOT)));
            list.add(event);
        }
        return list;
    }

    private static AdvancedCustomHumanoidMobPatch.DamageSourceModifier deserializeDamageModifier(CompoundTag args) {
        float damage = args.m_128441_("damage") ? args.m_128457_("damage") : 1.0f;
        float impact = args.m_128441_("impact") ? args.m_128457_("impact") : 1.0f;
        float armor_negation = args.m_128441_("armor_negation") ? args.m_128457_("armor_negation") : 1.0f;
        return new AdvancedCustomHumanoidMobPatch.DamageSourceModifier(damage, impact, armor_negation);
    }

    private static <T extends MobPatch<?>> CombatBehaviors.BehaviorPredicate<T> deserializeAdvancedBehaviorPredicate(String type, CompoundTag args) {
        Object predicate = null;
        ArrayList loggerNote = Lists.newArrayList();
        switch (type) {
            case "random_chance": {
                if (!args.m_128425_("chance", 6)) {
                    loggerNote.add(new String[]{"random_chance", "chance", "double", "0.0"});
                }
                predicate = new CombatBehaviors.RandomChance((float)args.m_128459_("chance"));
                break;
            }
            case "within_eye_height": {
                predicate = new CombatBehaviors.TargetWithinEyeHeight();
                break;
            }
            case "within_distance": {
                if (!args.m_128425_("min", 6)) {
                    loggerNote.add(new String[]{"within_distance", "min", "double", "0.0"});
                }
                if (!args.m_128425_("max", 6)) {
                    loggerNote.add(new String[]{"within_distance", "max", "double", "0.0"});
                }
                predicate = new CombatBehaviors.TargetWithinDistance(args.m_128459_("min"), args.m_128459_("max"));
                break;
            }
            case "within_angle": {
                if (!args.m_128425_("min", 6)) {
                    loggerNote.add(new String[]{"within_angle", "within_distance", "min", "double", "0.0F"});
                }
                if (!args.m_128425_("max", 6)) {
                    loggerNote.add(new String[]{"within_angle", "max", "double", "0.0F"});
                }
                predicate = new CombatBehaviors.TargetWithinAngle(args.m_128459_("min"), args.m_128459_("max"));
                break;
            }
            case "within_angle_horizontal": {
                if (!args.m_128425_("min", 6)) {
                    loggerNote.add(new String[]{"within_angle_horizontal", "min", "double", "0.0F"});
                }
                if (!args.m_128425_("max", 6)) {
                    loggerNote.add(new String[]{"within_angle_horizontal", "max", "double", "0.0F"});
                }
                predicate = new CombatBehaviors.TargetWithinAngle.Horizontal(args.m_128459_("min"), args.m_128459_("max"));
                break;
            }
            case "health": {
                if (!args.m_128425_("health", 6)) {
                    loggerNote.add(new String[]{"health", "health", "double", "0.0F"});
                }
                if (!args.m_128425_("comparator", 8)) {
                    loggerNote.add(new String[]{"health", "comparator", "string", ""});
                }
                predicate = new CombatBehaviors.Health((float)args.m_128459_("health"), CombatBehaviors.Health.Comparator.valueOf((String)args.m_128461_("comparator").toUpperCase(Locale.ROOT)));
                break;
            }
            case "guard_break": {
                if (!args.m_128441_("invert")) {
                    loggerNote.add(new String[]{"guard_break", "invert", "boolean", ""});
                }
                predicate = new ExtraPredicate.TargetIsGuardBreak(args.m_128471_("invert"));
                break;
            }
            case "knock_down": {
                if (!args.m_128441_("invert")) {
                    loggerNote.add(new String[]{"knock_down", "invert", "boolean", ""});
                }
                predicate = new ExtraPredicate.TargetIsKnockDown(args.m_128471_("invert"));
                break;
            }
            case "attack_level": {
                if (!args.m_128425_("min", 3)) {
                    loggerNote.add(new String[]{"level", "min", "int", ""});
                }
                if (!args.m_128425_("max", 3)) {
                    loggerNote.add(new String[]{"level", "max", "int", ""});
                }
                predicate = new ExtraPredicate.TargetWithinState(args.m_128451_("min"), args.m_128451_("max"));
                break;
            }
            case "stamina": {
                if (!args.m_128425_("stamina", 6)) {
                    loggerNote.add(new String[]{"stamina", "stamina", "double", "0.0F"});
                }
                if (!args.m_128425_("comparator", 8)) {
                    loggerNote.add(new String[]{"stamina", "comparator", "string", ""});
                }
                predicate = new ExtraPredicate.SelfStamina((float)args.m_128459_("stamina"), CombatBehaviors.Health.Comparator.valueOf((String)args.m_128461_("comparator").toUpperCase(Locale.ROOT)));
                break;
            }
            case "using_item": {
                if (!args.m_128441_("edible")) {
                    loggerNote.add(new String[]{"using_item", "edible", "boolean", ""});
                }
                predicate = new ExtraPredicate.TargetIsUsingItem(args.m_128471_("edible"));
                break;
            }
            case "phase": {
                if (!args.m_128425_("min", 3)) {
                    loggerNote.add(new String[]{"phase", "min", "int", ""});
                }
                if (!args.m_128425_("max", 3)) {
                    loggerNote.add(new String[]{"phase", "max", "int", ""});
                }
                predicate = new ExtraPredicate.Phase(args.m_128451_("min"), args.m_128451_("max"));
            }
        }
        for (String[] formatArgs : loggerNote) {
            Indestructible.LOGGER.info(String.format("[Custom Entity Error] can't find a proper argument for %s. [name: %s, type: %s, default: %s]", formatArgs));
        }
        if (predicate == null) {
            throw new IllegalArgumentException("[Custom Entity Error] No predicate type: " + type);
        }
        return predicate;
    }

    public static class AdvancedCustomHumanoidMobPatchProvider
    extends MobPatchReloadListener.AbstractMobPatchProvider {
        protected Map<WeaponCategory, Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>> AHCombatBehaviors;
        protected Map<WeaponCategory, Map<Style, Set<Pair<LivingMotion, StaticAnimation>>>> AHWeaponMotions;
        protected Map<WeaponCategory, Map<Style, AdvancedCustomHumanoidMobPatch.GuardMotion>> guardMotions;
        protected int regenStaminaStandbyTime;
        protected boolean hasStunReduction;
        protected float maxStunShield;
        protected int reganShieldStandbyTime;
        protected float reganShieldMultiply;
        protected float staminaLoseMultiply;
        protected float guardRadius;
        protected float attackRadius;
        protected List<Pair<LivingMotion, StaticAnimation>> defaultAnimations;
        protected Map<StunType, StaticAnimation> stunAnimations;
        protected Map<Attribute, Double> attributeValues;
        protected Faction faction;
        protected double chasingSpeed;
        protected float scale;
        protected boolean hasBossBar;
        protected ResourceLocation bossBar;
        protected String name;
        protected List<CommandEvent.StunEvent> stunEvent;

        public EntityPatch<?> get(Entity entity) {
            return new AdvancedCustomHumanoidMobPatch(this.faction, this);
        }

        public Map<WeaponCategory, Map<Style, Set<Pair<LivingMotion, StaticAnimation>>>> getHumanoidWeaponMotions() {
            return this.AHWeaponMotions;
        }

        public Map<WeaponCategory, Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>> getHumanoidCombatBehaviors() {
            return this.AHCombatBehaviors;
        }

        public Map<WeaponCategory, Map<Style, AdvancedCustomHumanoidMobPatch.GuardMotion>> getGuardMotions() {
            return this.guardMotions;
        }

        public List<Pair<LivingMotion, StaticAnimation>> getDefaultAnimations() {
            return this.defaultAnimations;
        }

        public Map<StunType, StaticAnimation> getStunAnimations() {
            return this.stunAnimations;
        }

        public Map<Attribute, Double> getAttributeValues() {
            return this.attributeValues;
        }

        public double getChasingSpeed() {
            return this.chasingSpeed;
        }

        public float getScale() {
            return this.scale;
        }

        public int getRegenStaminaStandbyTime() {
            return this.regenStaminaStandbyTime;
        }

        public boolean hasStunReduction() {
            return this.hasStunReduction;
        }

        public float getMaxStunShield() {
            return this.maxStunShield;
        }

        public int getReganShieldStandbyTime() {
            return this.reganShieldStandbyTime;
        }

        public float getReganShieldMultiply() {
            return this.reganShieldMultiply;
        }

        public float getStaminaLoseMultiply() {
            return this.staminaLoseMultiply;
        }

        public float getGuardRadius() {
            return this.guardRadius;
        }

        public float getAttackRadius() {
            return this.attackRadius;
        }

        public List<CommandEvent.StunEvent> getStunEvent() {
            return this.stunEvent;
        }

        public boolean hasBossBar() {
            return this.hasBossBar;
        }

        public String getName() {
            return this.name;
        }

        public ResourceLocation getBossBar() {
            return this.bossBar;
        }
    }
}

