/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.forge;

import immersive_paintings.ClientMain;
import immersive_paintings.ServerDataManager;
import immersive_paintings.network.LazyNetworkManager;
import immersive_paintings.resources.PaintingsLoader;
import immersive_paintings.resources.ServerPaintingManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="immersive_paintings", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventBus {
    public static boolean firstLoad = true;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        LazyNetworkManager.tickServer();
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        LazyNetworkManager.tickClient();
    }

    @SubscribeEvent
    public static void onPlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!event.getEntity().f_19853_.f_46443_) {
            ServerDataManager.playerLoggedOff((ServerPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onServerAboutToStart(ServerAboutToStartEvent event) {
        ServerPaintingManager.server = event.getServer();
    }

    @SubscribeEvent
    public static void onClientStart(TickEvent.ClientTickEvent event) {
        if (firstLoad) {
            ClientMain.postLoad();
            firstLoad = false;
        }
    }

    @SubscribeEvent
    public static void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new PaintingsLoader());
    }
}

