/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.illuminations.client.particle.pet;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import ladysnake.illuminations.client.render.GlowyRenderLayer;
import ladysnake.illuminations.client.render.entity.model.pet.LanternModel;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class PlayerLanternParticle
extends Particle {
    public final ResourceLocation texture;
    final RenderType layer;
    public float yaw;
    public float pitch;
    public float prevYaw;
    public float prevPitch;
    protected Player owner;
    Model model;

    protected PlayerLanternParticle(ClientLevel world, double x, double y, double z, ResourceLocation texture, float red, float green, float blue) {
        super(world, x, y, z);
        this.texture = texture;
        this.model = new LanternModel(Minecraft.m_91087_().m_167973_().m_171103_(LanternModel.MODEL_LAYER));
        this.layer = RenderType.m_110473_((ResourceLocation)texture);
        this.f_107226_ = 0.0f;
        this.f_107225_ = 35;
        this.owner = world.m_45941_(TargetingConditions.m_148353_().m_26883_(1.0), this.f_107212_, this.f_107213_, this.f_107214_);
        if (this.owner == null) {
            this.m_107274_();
        }
        this.f_107227_ = red;
        this.f_107228_ = green;
        this.f_107229_ = blue;
        this.f_107230_ = 0.0f;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        Vec3 vec3d = camera.m_90583_();
        float f = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107209_, (double)this.f_107212_) - vec3d.m_7096_());
        float g = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107210_, (double)this.f_107213_) - vec3d.m_7098_());
        float h = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107211_, (double)this.f_107214_) - vec3d.m_7094_());
        PoseStack matrixStack = new PoseStack();
        matrixStack.m_85837_((double)f, (double)g, (double)h);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(Mth.m_14179_((float)g, (float)this.prevYaw, (float)this.yaw) - 180.0f));
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14179_((float)g, (float)this.prevPitch, (float)this.pitch)));
        matrixStack.m_85841_(0.5f, -0.5f, 0.5f);
        matrixStack.m_85837_(0.0, -1.0, 0.0);
        MultiBufferSource.BufferSource immediate = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer vertexConsumer2 = immediate.m_6299_(GlowyRenderLayer.get(this.texture));
        if (this.f_107230_ > 0.0f) {
            this.model.m_7695_(matrixStack, vertexConsumer2, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        immediate.m_109911_();
    }

    public void m_5989_() {
        this.f_107230_ = this.f_107224_ > 10 ? 1.0f : 0.0f;
        if (this.owner != null) {
            this.f_107209_ = this.f_107212_;
            this.f_107210_ = this.f_107213_;
            this.f_107211_ = this.f_107214_;
            if (this.f_107224_++ >= this.f_107225_) {
                this.m_107274_();
            }
            this.m_107264_(this.owner.m_20185_() + Math.cos(this.owner.f_20883_ / 50.0f) * 0.5, this.owner.m_20186_() + (double)this.owner.m_20206_() + 0.5 + Math.sin((float)this.owner.f_19797_ / 12.0f) / 12.0, this.owner.m_20189_() - Math.cos(this.owner.f_20883_ / 50.0f) * 0.5);
            this.prevYaw = this.yaw;
            this.yaw = this.owner.f_19797_ * 2;
        } else {
            this.m_107274_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        private final ResourceLocation texture;
        private final float red;
        private final float green;
        private final float blue;

        public DefaultFactory(SpriteSet spriteProvider, ResourceLocation texture, float red, float green, float blue) {
            this.texture = texture;
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType parameters, ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new PlayerLanternParticle(world, x, y, z, this.texture, this.red, this.green, this.blue);
        }
    }
}

