/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.illuminations.client.particle.aura;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GhostlyAuraParticle
extends TextureSheetParticle {
    private static final Random RANDOM = new Random();
    private final float MAXIMUM_ALPHA = 0.02f;
    private final Player owner;
    private final int variant = RANDOM.nextInt(4);
    private final SpriteSet spriteProvider;
    protected float alpha = 0.0f;
    protected float offsetX = RANDOM.nextFloat() * 0.7f - 0.35f;
    protected float offsetZ = RANDOM.nextFloat() * 0.7f - 0.35f;
    protected float offsetY = 0.0f;

    public GhostlyAuraParticle(ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, SpriteSet spriteProvider) {
        super(world, x, y, z, velocityX, velocityY, velocityZ);
        this.spriteProvider = spriteProvider;
        this.owner = world.m_45941_(TargetingConditions.m_148353_().m_26883_(1.0), this.f_107212_, this.f_107213_, this.f_107214_);
        this.f_107663_ *= 1.0f + RANDOM.nextFloat();
        this.f_107225_ = RANDOM.nextInt(5) + 8;
        this.f_107219_ = true;
        this.m_108337_(spriteProvider.m_5819_(this.variant, 3));
        if (this.owner != null) {
            this.f_107227_ = 1.0f;
            this.f_107228_ = 1.0f;
            this.f_107229_ = 1.0f;
            this.m_107264_(this.owner.m_20185_() + (double)this.offsetX, this.owner.m_20186_() + (double)this.offsetY, this.owner.m_20189_() + (double)this.offsetZ);
        } else {
            this.m_107274_();
        }
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        Quaternion quaternion2;
        Vec3 vec3d = camera.m_90583_();
        float f = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107209_, (double)this.f_107212_) - vec3d.m_7096_());
        float g = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107210_, (double)this.f_107213_) - vec3d.m_7098_());
        float h = (float)(Mth.m_14139_((double)tickDelta, (double)this.f_107211_, (double)this.f_107214_) - vec3d.m_7094_());
        if (this.f_107231_ == 0.0f) {
            quaternion2 = camera.m_90591_();
        } else {
            quaternion2 = new Quaternion(camera.m_90591_());
            float i = Mth.m_14179_((float)tickDelta, (float)this.f_107204_, (float)this.f_107231_);
            quaternion2.m_80148_(Vector3f.f_122227_.m_122270_(i));
        }
        Vector3f Vec3f = new Vector3f(-1.0f, -1.0f, 0.0f);
        Vec3f.m_122251_(quaternion2);
        Vector3f[] Vec3fs = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float j = this.m_5902_(tickDelta);
        for (int k = 0; k < 4; ++k) {
            Vector3f Vec3f2 = Vec3fs[k];
            float tmpY = Vec3f2.m_122260_();
            Vec3f2.m_122245_(Vec3f2.m_122239_(), 0.0f, Vec3f2.m_122269_());
            Vec3f2.m_122251_(quaternion2);
            Vec3f2.m_122245_(Vec3f2.m_122239_() / (1.0f + this.offsetY * this.offsetY), tmpY * this.offsetY, Vec3f2.m_122269_() / (1.0f + this.offsetY * this.offsetY));
            Vec3f2.m_122261_(j);
            Vec3f2.m_122272_(f, g, h);
        }
        float minU = this.m_5970_();
        float maxU = this.m_5952_();
        float minV = this.m_5951_();
        float maxV = this.m_5950_();
        int l = 0xF000F0;
        vertexConsumer.m_5483_((double)Vec3fs[0].m_122239_(), (double)Vec3fs[0].m_122260_(), (double)Vec3fs[0].m_122269_()).m_7421_(maxU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.alpha).m_85969_(l).m_5752_();
        vertexConsumer.m_5483_((double)Vec3fs[1].m_122239_(), (double)Vec3fs[1].m_122260_(), (double)Vec3fs[1].m_122269_()).m_7421_(maxU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.alpha).m_85969_(l).m_5752_();
        vertexConsumer.m_5483_((double)Vec3fs[2].m_122239_(), (double)Vec3fs[2].m_122260_(), (double)Vec3fs[2].m_122269_()).m_7421_(minU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.alpha).m_85969_(l).m_5752_();
        vertexConsumer.m_5483_((double)Vec3fs[3].m_122239_(), (double)Vec3fs[3].m_122260_(), (double)Vec3fs[3].m_122269_()).m_7421_(minU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.alpha).m_85969_(l).m_5752_();
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5989_() {
        if (this.owner != null) {
            this.f_107209_ = this.f_107212_;
            this.f_107210_ = this.f_107213_;
            this.f_107211_ = this.f_107214_;
            if (this.f_107224_++ < this.f_107225_) {
                this.alpha = (float)((double)this.alpha + 0.01);
            } else {
                this.alpha = (float)((double)this.alpha - 0.01);
                if (this.alpha <= 0.0f) {
                    this.m_107274_();
                }
            }
            this.offsetY = (float)((double)this.offsetY + 0.1);
            this.m_107264_(this.owner.m_20185_() + (double)this.offsetX, this.owner.m_20186_() + (double)this.offsetY, this.owner.m_20189_() + (double)this.offsetZ);
        } else {
            this.m_107274_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public DefaultFactory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType defaultParticleType, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            return new GhostlyAuraParticle(clientWorld, d, e, f, g, h, i, this.spriteProvider);
        }
    }
}

