/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iafpatcher;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.iafenvoy.iafpatcher.IceAndFirePatcher;
import com.iafenvoy.iafpatcher.util.RandomHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;

public class TitleScreenRenderManager {
    public static final ResourceLocation splash = new ResourceLocation("iceandfire", "splashes.txt");
    public static final ResourceLocation[] pageFlipTextures;
    public static final ResourceLocation[] drawingTextures;
    private static final ResourceLocation BESTIARY_TEXTURE;
    private static final ResourceLocation TABLE_TEXTURE;
    private static final Font textRenderer;
    private static int layerTick;
    private static List<String> splashText;
    private static boolean isFlippingPage;
    private static int pageFlip;
    private static Picture[] drawnPictures;
    private static float globalAlpha;

    public static String getSplash() {
        if (TitleScreenRenderManager.splashText == null) {
            try {
                BufferedReader bufferedReader = Minecraft.m_91087_().m_91098_().m_215597_(splash);
                TitleScreenRenderManager.splashText = bufferedReader.lines().map(String::trim).filter(splashText -> splashText.hashCode() != 125780783).toList();
                bufferedReader.close();
            }
            catch (IOException var8) {
                TitleScreenRenderManager.splashText = new ArrayList<String>();
            }
        }
        if (TitleScreenRenderManager.splashText.isEmpty()) {
            return null;
        }
        return TitleScreenRenderManager.splashText.get(RandomHelper.nextInt(0, TitleScreenRenderManager.splashText.size() - 1));
    }

    private static void resetDrawnImages() {
        globalAlpha = 0.0f;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        drawnPictures = new Picture[2];
        boolean left = ((Random)random).nextBoolean();
        for (int i = 0; i < drawnPictures.length; ++i) {
            left = !left;
            int x = left ? -15 - ((Random)random).nextInt(20) - 128 : 30 + ((Random)random).nextInt(20);
            int y = ((Random)random).nextInt(25);
            TitleScreenRenderManager.drawnPictures[i] = new Picture(((Random)random).nextInt(drawingTextures.length), x, y, 0.5f, ((Random)random).nextFloat() * 0.5f + 0.5f);
        }
    }

    public static void tick() {
        float flipTick = layerTick % 40;
        if (globalAlpha < 1.0f && !isFlippingPage && flipTick < 30.0f) {
            globalAlpha += 0.1f;
        }
        if (globalAlpha > 0.0f && flipTick > 30.0f) {
            globalAlpha -= 0.1f;
        }
        if (flipTick == 0.0f && !isFlippingPage) {
            isFlippingPage = true;
        }
        if (isFlippingPage) {
            if (layerTick % 2 == 0) {
                ++pageFlip;
            }
            if (pageFlip == 6) {
                pageFlip = 0;
                isFlippingPage = false;
                TitleScreenRenderManager.resetDrawnImages();
            }
        }
        ++layerTick;
    }

    public static void renderBackground(PoseStack ms, int width, int height) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        TitleScreenRenderManager.blit(ms, TABLE_TEXTURE, 0, 0, 0.0f, 0.0f, width, height, width, height);
        TitleScreenRenderManager.blit(ms, BESTIARY_TEXTURE, 50, 0, 0.0f, 0.0f, width - 100, height, width - 100, height);
        if (isFlippingPage) {
            TitleScreenRenderManager.blit(ms, pageFlipTextures[Math.min(5, pageFlip)], 50, 0, 0.0f, 0.0f, width - 100, height, width - 100, height);
        } else {
            int middleX = width / 2;
            int middleY = height / 5;
            float widthScale = (float)width / 427.0f;
            float heightScale = (float)height / 427.0f;
            float imageScale = Math.min(widthScale, heightScale) * 192.0f;
            RenderSystem.m_69478_();
            for (Picture picture : drawnPictures) {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)globalAlpha);
                int x = (int)((float)picture.x * widthScale) + middleX;
                int y = (int)((float)picture.y * heightScale + (float)middleY);
                TitleScreenRenderManager.blit(ms, drawingTextures[picture.image], x, y, 0.0f, 0.0f, (int)imageScale, (int)imageScale, (int)imageScale, (int)imageScale);
            }
            RenderSystem.m_69461_();
        }
    }

    public static void drawModName(PoseStack ms, int height, int alphaFormatted) {
        int textColor = 0xFFFFFF | alphaFormatted;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        textRenderer.m_92883_(ms, "Ice and Fire " + ChatFormatting.YELLOW + IceAndFire.VERSION, 2.0f, (float)(height - 60), textColor);
        textRenderer.m_92883_(ms, "IAF Patcher " + ChatFormatting.YELLOW + IceAndFirePatcher.VERSION, 2.0f, (float)(height - 50), textColor);
    }

    public static void blit(PoseStack ms, ResourceLocation location, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        TitleScreenRenderManager.innerBlit(ms, location, x, x + width, y, y + height, u / (float)textureWidth, (u + (float)width) / (float)textureWidth, v / (float)textureHeight, (v + (float)height) / (float)textureHeight);
    }

    private static void innerBlit(PoseStack stack, ResourceLocation location, int x1, int x2, int y1, int y2, float u1, float u2, float v1, float v2) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)location);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        Matrix4f var11 = stack.m_85850_().m_85861_();
        BufferBuilder var12 = Tesselator.m_85913_().m_85915_();
        var12.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        var12.m_85982_(var11, (float)x1, (float)y1, 0.0f).m_7421_(u1, v1).m_5752_();
        var12.m_85982_(var11, (float)x1, (float)y2, 0.0f).m_7421_(u1, v2).m_5752_();
        var12.m_85982_(var11, (float)x2, (float)y2, 0.0f).m_7421_(u2, v2).m_5752_();
        var12.m_85982_(var11, (float)x2, (float)y1, 0.0f).m_7421_(u2, v1).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)var12.m_231175_());
    }

    static {
        drawingTextures = new ResourceLocation[23];
        BESTIARY_TEXTURE = new ResourceLocation("iceandfire", "textures/gui/main_menu/bestiary_menu.png");
        TABLE_TEXTURE = new ResourceLocation("iceandfire", "textures/gui/main_menu/table.png");
        textRenderer = Minecraft.m_91087_().f_91062_;
        isFlippingPage = false;
        pageFlip = 0;
        globalAlpha = 1.0f;
        pageFlipTextures = new ResourceLocation[]{new ResourceLocation("iceandfire", "textures/gui/main_menu/page_1.png"), new ResourceLocation("iceandfire", "textures/gui/main_menu/page_2.png"), new ResourceLocation("iceandfire", "textures/gui/main_menu/page_3.png"), new ResourceLocation("iceandfire", "textures/gui/main_menu/page_4.png"), new ResourceLocation("iceandfire", "textures/gui/main_menu/page_5.png"), new ResourceLocation("iceandfire", "textures/gui/main_menu/page_6.png")};
        for (int i = 0; i < drawingTextures.length; ++i) {
            TitleScreenRenderManager.drawingTextures[i] = new ResourceLocation("iceandfire", "textures/gui/main_menu/drawing_" + i + ".png");
        }
        TitleScreenRenderManager.resetDrawnImages();
    }

    private static class Picture {
        final int image;
        final int x;
        final int y;
        final float alpha;

        public Picture(int image, int x, int y, float alpha, float scale) {
            this.image = image;
            this.x = x;
            this.y = y;
            this.alpha = alpha;
        }
    }
}

