/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.rawlxxxviii.visual_keybinder;

import com.gmail.rawlxxxviii.visual_keybinder.AlternativeKeybindScreen;
import com.gmail.rawlxxxviii.visual_keybinder.KeyUtil;
import com.gmail.rawlxxxviii.visual_keybinder.KeyboardLayoutKey;
import com.gmail.rawlxxxviii.visual_keybinder.config.ClientConfig;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.settings.KeyConflictContext;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class KeyDetailsList
extends ContainerObjectSelectionList<Entry> {
    private final AlternativeKeybindScreen parentScreen;
    private final KeyboardLayoutKey selectedKey;
    protected final Options options;

    public KeyDetailsList(AlternativeKeybindScreen parentScreen, Minecraft minecraft, Options options, KeyboardLayoutKey selectedKey, int left, int top, int width, int height) {
        super(minecraft, width, height, top, height + top, 20);
        this.options = options;
        this.m_93496_(false);
        this.f_93389_ = height;
        this.f_93393_ = left;
        this.f_93392_ = width + this.f_93393_;
        this.parentScreen = parentScreen;
        this.selectedKey = selectedKey;
        this.buildEndtries();
    }

    private void buildEndtries() {
        this.m_93516_();
        KeyMapping[] allKeyMappings = (KeyMapping[])ArrayUtils.clone((Object[])this.options.f_92059_);
        KeyMapping[] keyMappings = this.parentScreen.getKeyMappings(this.selectedKey);
        boolean hasConflicts = KeyUtil.hasConflict(keyMappings);
        this.m_7085_((AbstractSelectionList.Entry)new DetailsListTitleEntry(hasConflicts));
        if (keyMappings.length == 0) {
            this.m_7085_((AbstractSelectionList.Entry)new TitleEntry((Component)Component.m_237113_((String)"No bindings"), Color.GRAY.getRGB()));
        }
        String c = null;
        for (KeyMapping keyMapping : keyMappings) {
            String category = keyMapping.m_90858_();
            if (!category.equals(c)) {
                c = category;
                this.m_7085_((AbstractSelectionList.Entry)new TitleEntry((Component)Component.m_237115_((String)category), AlternativeKeybindScreen.CATEGORY_COLOR));
            }
            boolean isConflicting = KeyUtil.hasConflict(keyMappings, keyMapping);
            boolean isDefaultConflicting = KeyUtil.hasDefaultConflict(allKeyMappings, keyMapping);
            this.m_7085_((AbstractSelectionList.Entry)new KeyEntry(keyMapping, isConflicting));
            this.m_7085_((AbstractSelectionList.Entry)new KeyInfoEntry(keyMapping, isConflicting, isDefaultConflicting));
        }
        this.m_7085_((AbstractSelectionList.Entry)new EmptyEntry());
    }

    public void onBindingsUpdated() {
        this.buildEndtries();
        this.m_93410_(this.m_93517_());
    }

    public int m_5759_() {
        return this.f_93388_;
    }

    public KeyboardLayoutKey getSelectedKey() {
        return this.selectedKey;
    }

    protected int m_5756_() {
        return this.f_93388_ + this.f_93393_ - 6;
    }

    public Optional<GuiEventListener> m_94729_(double p_94730_, double p_94731_) {
        return super.m_94729_(p_94730_, p_94731_);
    }

    public void m_94757_(double p_94758_, double p_94759_) {
        super.m_94757_(p_94758_, p_94759_);
    }

    public boolean m_6375_(double p_94695_, double p_94696_, int p_94697_) {
        return super.m_6375_(p_94695_, p_94696_, p_94697_);
    }

    public boolean m_6348_(double p_94722_, double p_94723_, int p_94724_) {
        return super.m_6348_(p_94722_, p_94723_, p_94724_);
    }

    public boolean m_7979_(double p_94699_, double p_94700_, int p_94701_, double p_94702_, double p_94703_) {
        return super.m_7979_(p_94699_, p_94700_, p_94701_, p_94702_, p_94703_);
    }

    public boolean m_6050_(double p_94686_, double p_94687_, double p_94688_) {
        return super.m_6050_(p_94686_, p_94687_, p_94688_);
    }

    public boolean m_7933_(int p_94710_, int p_94711_, int p_94712_) {
        return super.m_7933_(p_94710_, p_94711_, p_94712_);
    }

    public boolean m_7920_(int p_94715_, int p_94716_, int p_94717_) {
        return super.m_7920_(p_94715_, p_94716_, p_94717_);
    }

    public boolean m_5534_(char p_94683_, int p_94684_) {
        return super.m_5534_(p_94683_, p_94684_);
    }

    public void m_94718_(@Nullable GuiEventListener p_94719_) {
        super.m_94718_(p_94719_);
    }

    public void m_94725_(@Nullable GuiEventListener p_94726_) {
        super.m_94725_(p_94726_);
    }

    public boolean m_5755_(boolean p_94728_) {
        return super.m_5755_(p_94728_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public class DetailsListTitleEntry
    extends Entry {
        private final boolean hasConflicts;

        public DetailsListTitleEntry(boolean hasConflicts) {
            this.hasConflicts = hasConflicts;
        }

        public void m_6311_(PoseStack poseStack, int p_193889_, int p_193890_, int p_193891_, int p_193892_, int p_193893_, int p_193894_, int p_193895_, boolean p_193896_, float p_193897_) {
            GuiComponent.m_239260_((int)KeyDetailsList.this.getLeft(), (int)KeyDetailsList.this.getTop(), (int)KeyDetailsList.this.getRight(), (int)KeyDetailsList.this.getBottom());
            GuiComponent.m_93172_((PoseStack)poseStack, (int)KeyDetailsList.this.getLeft(), (int)(KeyDetailsList.this.m_7610_(0) - 4), (int)KeyDetailsList.this.getRight(), (int)(KeyDetailsList.this.m_7610_(0) + KeyDetailsList.this.f_93387_), (int)AlternativeKeybindScreen.LIST_TITLE_BACKGROUND_COLOR);
            ((KeyDetailsList)KeyDetailsList.this).f_93386_.f_91062_.m_92889_(poseStack, KeyDetailsList.this.getSelectedKey().getKey().m_84875_(), (float)(KeyDetailsList.this.getLeft() + 5), (float)(p_193890_ + 5), this.hasConflicts ? AlternativeKeybindScreen.CONFLICT_COLOR : Color.white.getRGB());
            GuiComponent.m_240060_();
        }

        public List<? extends GuiEventListener> m_6702_() {
            return List.of();
        }

        public Optional<GuiEventListener> m_94729_(double p_94730_, double p_94731_) {
            return super.m_94729_(p_94730_, p_94731_);
        }

        public void m_94757_(double p_94758_, double p_94759_) {
            super.m_94757_(p_94758_, p_94759_);
        }

        public boolean m_6375_(double p_94695_, double p_94696_, int p_94697_) {
            return super.m_6375_(p_94695_, p_94696_, p_94697_);
        }

        public boolean m_6348_(double p_94722_, double p_94723_, int p_94724_) {
            return super.m_6348_(p_94722_, p_94723_, p_94724_);
        }

        public boolean m_7979_(double p_94699_, double p_94700_, int p_94701_, double p_94702_, double p_94703_) {
            return super.m_7979_(p_94699_, p_94700_, p_94701_, p_94702_, p_94703_);
        }

        public boolean m_6050_(double p_94686_, double p_94687_, double p_94688_) {
            return super.m_6050_(p_94686_, p_94687_, p_94688_);
        }

        public boolean m_7933_(int p_94710_, int p_94711_, int p_94712_) {
            return super.m_7933_(p_94710_, p_94711_, p_94712_);
        }

        public boolean m_7920_(int p_94715_, int p_94716_, int p_94717_) {
            return super.m_7920_(p_94715_, p_94716_, p_94717_);
        }

        public boolean m_5534_(char p_94683_, int p_94684_) {
            return super.m_5534_(p_94683_, p_94684_);
        }

        public void m_94718_(@Nullable GuiEventListener p_94719_) {
            super.m_94718_(p_94719_);
        }

        public void m_94725_(@Nullable GuiEventListener p_94726_) {
            super.m_94725_(p_94726_);
        }

        public boolean m_5755_(boolean p_94728_) {
            return super.m_5755_(p_94728_);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return List.of();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class TitleEntry
    extends Entry {
        final Component name;
        private final int color;

        public TitleEntry(Component p_193886_, int color) {
            this.name = p_193886_;
            this.color = color;
        }

        public void m_6311_(PoseStack p_193888_, int p_193889_, int y, int p_193891_, int p_193892_, int height, int p_193894_, int p_193895_, boolean p_193896_, float p_193897_) {
            GuiComponent.m_239260_((int)KeyDetailsList.this.getLeft(), (int)KeyDetailsList.this.getTop(), (int)KeyDetailsList.this.getRight(), (int)KeyDetailsList.this.getBottom());
            ((KeyDetailsList)KeyDetailsList.this).f_93386_.f_91062_.m_92889_(p_193888_, this.name, (float)(KeyDetailsList.this.getLeft() + 5), (float)(y + height - 4), this.color);
            GuiComponent.m_240060_();
        }

        public List<? extends GuiEventListener> m_6702_() {
            return List.of();
        }

        public Optional<GuiEventListener> m_94729_(double p_94730_, double p_94731_) {
            return super.m_94729_(p_94730_, p_94731_);
        }

        public void m_94757_(double p_94758_, double p_94759_) {
            super.m_94757_(p_94758_, p_94759_);
        }

        public boolean m_6375_(double p_94695_, double p_94696_, int p_94697_) {
            return super.m_6375_(p_94695_, p_94696_, p_94697_);
        }

        public boolean m_6348_(double p_94722_, double p_94723_, int p_94724_) {
            return super.m_6348_(p_94722_, p_94723_, p_94724_);
        }

        public boolean m_7979_(double p_94699_, double p_94700_, int p_94701_, double p_94702_, double p_94703_) {
            return super.m_7979_(p_94699_, p_94700_, p_94701_, p_94702_, p_94703_);
        }

        public boolean m_6050_(double p_94686_, double p_94687_, double p_94688_) {
            return super.m_6050_(p_94686_, p_94687_, p_94688_);
        }

        public boolean m_7933_(int p_94710_, int p_94711_, int p_94712_) {
            return super.m_7933_(p_94710_, p_94711_, p_94712_);
        }

        public boolean m_7920_(int p_94715_, int p_94716_, int p_94717_) {
            return super.m_7920_(p_94715_, p_94716_, p_94717_);
        }

        public boolean m_5534_(char p_94683_, int p_94684_) {
            return super.m_5534_(p_94683_, p_94684_);
        }

        public void m_94718_(@Nullable GuiEventListener p_94719_) {
            super.m_94718_(p_94719_);
        }

        public void m_94725_(@Nullable GuiEventListener p_94726_) {
            super.m_94725_(p_94726_);
        }

        public boolean m_5755_(boolean p_94728_) {
            return super.m_5755_(p_94728_);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return List.of();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class KeyEntry
    extends Entry {
        private final KeyMapping key;
        private final boolean isConflicting;

        KeyEntry(KeyMapping key, boolean isConflicting) {
            this.key = key;
            this.isConflicting = isConflicting;
        }

        public void m_6311_(PoseStack poseStack, int p_193924_, int p_193925_, int p_193926_, int p_193927_, int p_193928_, int p_193929_, int p_193930_, boolean p_193931_, float p_193932_) {
            GuiComponent.m_239260_((int)KeyDetailsList.this.getLeft(), (int)KeyDetailsList.this.getTop(), (int)KeyDetailsList.this.getRight(), (int)KeyDetailsList.this.getBottom());
            ((KeyDetailsList)KeyDetailsList.this).f_93386_.f_91062_.m_92889_(poseStack, (Component)Component.m_237115_((String)this.key.m_90860_()), (float)(KeyDetailsList.this.getLeft() + 5), (float)(p_193925_ + p_193928_ / 2), 0xFFFFFF);
            if (((Boolean)ClientConfig.displayConflictContext.get()).booleanValue() && KeyDetailsList.this.getWidth() > 170) {
                if (this.key.getKeyConflictContext() == KeyConflictContext.GUI) {
                    ((KeyDetailsList)KeyDetailsList.this).f_93386_.f_91062_.m_92889_(poseStack, (Component)Component.m_237113_((String)"In GUI"), (float)(KeyDetailsList.this.getRight() - 75), (float)(p_193925_ + p_193928_ / 2), Color.DARK_GRAY.getRGB());
                } else if (this.key.getKeyConflictContext() == KeyConflictContext.IN_GAME) {
                    ((KeyDetailsList)KeyDetailsList.this).f_93386_.f_91062_.m_92889_(poseStack, (Component)Component.m_237113_((String)"In game"), (float)(KeyDetailsList.this.getRight() - 75), (float)(p_193925_ + p_193928_ / 2), Color.DARK_GRAY.getRGB());
                } else {
                    ((KeyDetailsList)KeyDetailsList.this).f_93386_.f_91062_.m_92889_(poseStack, (Component)Component.m_237113_((String)"In game and GUI"), (float)(KeyDetailsList.this.getRight() - 105), (float)(p_193925_ + p_193928_ / 2), Color.DARK_GRAY.getRGB());
                }
            }
            GuiComponent.m_240060_();
        }

        public List<? extends NarratableEntry> m_142437_() {
            return List.of();
        }

        public List<? extends GuiEventListener> m_6702_() {
            return List.of();
        }

        public Optional<GuiEventListener> m_94729_(double p_94730_, double p_94731_) {
            return super.m_94729_(p_94730_, p_94731_);
        }

        public void m_94757_(double p_94758_, double p_94759_) {
            super.m_94757_(p_94758_, p_94759_);
        }

        public boolean m_6375_(double p_94695_, double p_94696_, int p_94697_) {
            return super.m_6375_(p_94695_, p_94696_, p_94697_);
        }

        public boolean m_6348_(double p_94722_, double p_94723_, int p_94724_) {
            return super.m_6348_(p_94722_, p_94723_, p_94724_);
        }

        public boolean m_7979_(double p_94699_, double p_94700_, int p_94701_, double p_94702_, double p_94703_) {
            return super.m_7979_(p_94699_, p_94700_, p_94701_, p_94702_, p_94703_);
        }

        public boolean m_6050_(double p_94686_, double p_94687_, double p_94688_) {
            return super.m_6050_(p_94686_, p_94687_, p_94688_);
        }

        public boolean m_7933_(int p_94710_, int p_94711_, int p_94712_) {
            return super.m_7933_(p_94710_, p_94711_, p_94712_);
        }

        public boolean m_7920_(int p_94715_, int p_94716_, int p_94717_) {
            return super.m_7920_(p_94715_, p_94716_, p_94717_);
        }

        public boolean m_5534_(char p_94683_, int p_94684_) {
            return super.m_5534_(p_94683_, p_94684_);
        }

        public void m_94718_(@Nullable GuiEventListener p_94719_) {
            super.m_94718_(p_94719_);
        }

        public void m_94725_(@Nullable GuiEventListener p_94726_) {
            super.m_94725_(p_94726_);
        }

        public boolean m_5755_(boolean p_94728_) {
            return super.m_5755_(p_94728_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class KeyInfoEntry
    extends Entry {
        private final KeyMapping key;
        private final Button changeButton;
        private final Button resetButton;
        private final boolean isConflicting;
        private final boolean isDefaultConflicting;

        KeyInfoEntry(KeyMapping key, boolean isConflicting, boolean isDefaultConflicting) {
            this.key = key;
            this.isConflicting = isConflicting;
            this.isDefaultConflicting = isDefaultConflicting;
            this.changeButton = new Button(0, 0, 110, 20, (Component)Component.m_237113_((String)"Edit"), p_193939_ -> KeyDetailsList.this.parentScreen.setKeyMappingToChange(key));
            this.resetButton = new Button(0, 0, 80, 20, (Component)Component.m_237113_((String)"(").m_130946_(key.m_90861_().m_84875_().getString()).m_130946_(")"), p_193935_ -> {
                this.key.setToDefault();
                KeyDetailsList.this.options.m_92159_(key, key.m_90861_());
                KeyMapping.m_90854_();
                KeyDetailsList.this.parentScreen.onBindingsChanged();
            });
        }

        public Button getResetButton() {
            return this.resetButton;
        }

        public Button getChangeButton() {
            return this.changeButton;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.changeButton, (Object)this.resetButton);
        }

        public void m_6311_(PoseStack poseStack, int p_193924_, int p_193925_, int p_193926_, int p_193927_, int p_193928_, int p_193929_, int p_193930_, boolean p_193931_, float p_193932_) {
            GuiComponent.m_239260_((int)KeyDetailsList.this.getLeft(), (int)KeyDetailsList.this.getTop(), (int)KeyDetailsList.this.getRight(), (int)KeyDetailsList.this.getBottom());
            this.changeButton.f_93620_ = KeyDetailsList.this.getLeft() + 5;
            this.changeButton.m_93674_(Math.max(40, Math.min(120, (int)((float)KeyDetailsList.this.getWidth() * 0.4f))));
            this.changeButton.f_93621_ = p_193925_;
            this.changeButton.setFGColor(this.isConflicting ? AlternativeKeybindScreen.CONFLICT_COLOR : Color.white.getRGB());
            this.changeButton.m_93666_((Component)(KeyDetailsList.this.parentScreen.getKeyMappingToChange() == this.key ? Component.m_237113_((String)"> ... <") : this.key.m_90863_()));
            this.changeButton.m_6305_(poseStack, p_193929_, p_193930_, p_193932_);
            this.resetButton.f_93620_ = this.changeButton.f_93620_ + this.changeButton.m_5711_() + 3;
            this.resetButton.m_93674_(Math.max(40, Math.min(100, (int)((float)KeyDetailsList.this.getWidth() * 0.35f))));
            this.resetButton.f_93621_ = p_193925_;
            boolean bl = this.resetButton.f_93623_ = !this.key.m_90864_();
            this.resetButton.setFGColor(this.key.m_90864_() ? Color.gray.getRGB() : (this.isDefaultConflicting ? AlternativeKeybindScreen.CONFLICT_COLOR : AlternativeKeybindScreen.RESET_COLOR));
            this.resetButton.m_6305_(poseStack, p_193929_, p_193930_, p_193932_);
            GuiComponent.m_240060_();
        }

        public List<? extends NarratableEntry> m_142437_() {
            return List.of();
        }

        public Optional<GuiEventListener> m_94729_(double p_94730_, double p_94731_) {
            return super.m_94729_(p_94730_, p_94731_);
        }

        public void m_94757_(double p_94758_, double p_94759_) {
            super.m_94757_(p_94758_, p_94759_);
        }

        public boolean m_6375_(double p_94695_, double p_94696_, int p_94697_) {
            return super.m_6375_(p_94695_, p_94696_, p_94697_);
        }

        public boolean m_6348_(double p_94722_, double p_94723_, int p_94724_) {
            return super.m_6348_(p_94722_, p_94723_, p_94724_);
        }

        public boolean m_7979_(double p_94699_, double p_94700_, int p_94701_, double p_94702_, double p_94703_) {
            return super.m_7979_(p_94699_, p_94700_, p_94701_, p_94702_, p_94703_);
        }

        public boolean m_6050_(double p_94686_, double p_94687_, double p_94688_) {
            return super.m_6050_(p_94686_, p_94687_, p_94688_);
        }

        public boolean m_7933_(int p_94710_, int p_94711_, int p_94712_) {
            return super.m_7933_(p_94710_, p_94711_, p_94712_);
        }

        public boolean m_7920_(int p_94715_, int p_94716_, int p_94717_) {
            return super.m_7920_(p_94715_, p_94716_, p_94717_);
        }

        public boolean m_5534_(char p_94683_, int p_94684_) {
            return super.m_5534_(p_94683_, p_94684_);
        }

        public void m_94718_(@Nullable GuiEventListener p_94719_) {
            super.m_94718_(p_94719_);
        }

        public void m_94725_(@Nullable GuiEventListener p_94726_) {
            super.m_94725_(p_94726_);
        }

        public boolean m_5755_(boolean p_94728_) {
            return super.m_5755_(p_94728_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class EmptyEntry
    extends Entry {
        public List<? extends NarratableEntry> m_142437_() {
            return List.of();
        }

        public void m_6311_(PoseStack p_193888_, int p_193889_, int p_193890_, int p_193891_, int p_193892_, int p_193893_, int p_193894_, int p_193895_, boolean p_193896_, float p_193897_) {
        }

        public List<? extends GuiEventListener> m_6702_() {
            return List.of();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
    }
}

