/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.rawlxxxviii.visual_keybinder;

import com.gmail.rawlxxxviii.visual_keybinder.AlternativeKeybindScreen;
import com.gmail.rawlxxxviii.visual_keybinder.KeyBoardLayout;
import com.gmail.rawlxxxviii.visual_keybinder.KeyUtil;
import com.gmail.rawlxxxviii.visual_keybinder.KeyboardLayoutKey;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class KeyButton
extends ImageButton {
    private final KeyboardLayoutKey keyboardLayoutKey;
    private final AlternativeKeybindScreen parentScreen;
    private final KeyBoardLayout keyBoardLayout;

    public KeyButton(AlternativeKeybindScreen parentScreen, KeyBoardLayout keyBoardLayout, KeyboardLayoutKey keyboardLayoutKey, int x, int y, Button.OnPress onPress) {
        super(x, y, keyboardLayoutKey.isWide() ? 60 : 16, 16, keyboardLayoutKey.isWide() ? 120 : 0, 0, 16, new ResourceLocation("visual_keybinder", "textures/gui/gui.png"), 512, 512, onPress, keyboardLayoutKey.getKey().m_84875_());
        this.keyBoardLayout = keyBoardLayout;
        this.parentScreen = parentScreen;
        this.keyboardLayoutKey = keyboardLayoutKey;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float p_93660_) {
        if (!this.f_93624_) {
            return;
        }
        float scale = this.getScale();
        this.f_93622_ = this.checkIsMouseOver(mouseX, mouseY);
        poseStack.m_85836_();
        poseStack.m_85837_((double)this.getDiffX(), (double)this.getDiffY(), 1.0);
        poseStack.m_85841_(scale, scale, 1.0f);
        this.m_6303_(poseStack, mouseX, mouseY, p_93660_);
        poseStack.m_85849_();
    }

    private float getScale() {
        float minScale = 0.3f;
        float maxScale = 1.2f;
        float scaleX = Math.max(minScale, Math.min(maxScale, (float)this.parentScreen.getLayoutWidth() / (float)this.keyBoardLayout.getWidth()));
        float scaleY = Math.max(minScale, Math.min(maxScale, (float)this.parentScreen.getLayoutHeight() / (float)this.keyBoardLayout.getHeight()));
        return Math.min(scaleX, scaleY);
    }

    private float getDiffX() {
        float scale = this.getScale();
        int centerXOrigin = this.parentScreen.getLayoutLeft() + this.parentScreen.getLayoutWidth() / 2;
        float centerXAfterScale = (float)centerXOrigin * scale;
        return (float)centerXOrigin - centerXAfterScale;
    }

    private float getDiffY() {
        float scale = this.getScale();
        int centerYOrigin = this.parentScreen.getLayoutTop() + this.parentScreen.getLayoutHeight() / 2;
        float centerYAfterScale = (float)centerYOrigin * scale;
        return (float)centerYOrigin - centerYAfterScale;
    }

    private boolean checkIsMouseOver(double mouseX, double mouseY) {
        float scale = this.getScale();
        float diffX = this.getDiffX();
        float diffY = this.getDiffY();
        return mouseX >= (double)((float)this.f_93620_ * scale + diffX) && mouseY >= (double)((float)this.f_93621_ * scale + diffY) && mouseX < (double)((float)(this.f_93620_ + this.f_93618_) * scale + diffX) && mouseY < (double)((float)(this.f_93621_ + this.f_93619_) * scale + diffY);
    }

    protected boolean m_93680_(double mouseX, double mouseY) {
        return this.f_93623_ && this.f_93624_ && this.checkIsMouseOver(mouseX, mouseY);
    }

    public void m_6303_(PoseStack poseStack, int p_94283_, int p_94284_, float p_94285_) {
        super.m_6303_(poseStack, p_94283_, p_94284_, p_94285_);
        this.renderOverlay(poseStack, p_94283_, p_94284_, p_94285_);
    }

    public KeyMapping[] getKeymappings() {
        return this.parentScreen.getKeyMappings(this.keyboardLayoutKey);
    }

    public boolean isEmpty() {
        return this.getKeymappings().length < 1;
    }

    public boolean hasConflict() {
        return KeyUtil.hasConflict(this.getKeymappings());
    }

    private void renderOverlay(PoseStack poseStack, int p_94283_, int p_94284_, float p_94285_) {
        int canvasX;
        boolean isEmpty = this.isEmpty();
        boolean hasConflict = this.hasConflict();
        int n = canvasX = this.keyboardLayoutKey.isWide() ? 120 : 0;
        KeyButton.m_93133_((PoseStack)poseStack, (int)this.f_93620_, (int)this.f_93621_, (float)(isEmpty ? (float)(canvasX + 3 * this.f_93618_) : (hasConflict ? (float)(canvasX + this.f_93618_) : (float)(canvasX + 2 * this.f_93618_))), (float)(this.m_198029_() ? 16 : 0), (int)this.f_93618_, (int)this.f_93619_, (int)512, (int)512);
        if (this.parentScreen.getDetailsList() != null && this.parentScreen.getDetailsList().getSelectedKey().getKey().m_84873_() == this.keyboardLayoutKey.getKey().m_84873_()) {
            KeyButton.m_93133_((PoseStack)poseStack, (int)this.f_93620_, (int)this.f_93621_, (float)(canvasX + 4 * this.f_93618_), (float)0.0f, (int)this.f_93618_, (int)this.f_93619_, (int)512, (int)512);
        }
        KeyButton.m_93215_((PoseStack)poseStack, (Font)this.parentScreen.getMinecraft().f_91062_, (Component)this.keyboardLayoutKey.getKey().m_84875_(), (int)(this.f_93620_ + this.f_93618_ / 2), (int)(this.f_93621_ + (this.f_93619_ - 8) / 2), (int)(isEmpty ? Color.gray.getRGB() : (hasConflict ? AlternativeKeybindScreen.CONFLICT_COLOR : Color.WHITE.getRGB())));
    }
}

