/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.rawlxxxviii.visual_keybinder;

import com.gmail.rawlxxxviii.visual_keybinder.DefaultKeyBindsList;
import com.gmail.rawlxxxviii.visual_keybinder.FilterEditBox;
import com.gmail.rawlxxxviii.visual_keybinder.KeyBoardLayout;
import com.gmail.rawlxxxviii.visual_keybinder.KeyButton;
import com.gmail.rawlxxxviii.visual_keybinder.KeyDetailsList;
import com.gmail.rawlxxxviii.visual_keybinder.KeyUtil;
import com.gmail.rawlxxxviii.visual_keybinder.KeyboardLayoutKey;
import com.gmail.rawlxxxviii.visual_keybinder.config.ClientConfig;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.settings.KeyModifier;
import org.apache.commons.lang3.ArrayUtils;

public class AlternativeKeybindScreen
extends OptionsSubScreen {
    public static final int CATEGORY_COLOR = new Color(143, 178, 236).getRGB();
    public static final int CONFLICT_COLOR = new Color(243, 164, 39).getRGB();
    public static final int RESET_COLOR = new Color(161, 200, 123).getRGB();
    public static final int UNBOUND_COLOR = new Color(142, 149, 154).getRGB();
    public static final int LIST_TITLE_BACKGROUND_COLOR = new Color(0, 0, 0, 158).getRGB();
    public static final int KEY_BUTTON_WIDTH = 16;
    public static final int WIDE_KEY_BUTTON_WIDTH = 60;
    public static final int KEY_BUTTON_HEIGHT = 16;
    private DefaultKeyBindsList defaultKeyBindsList;
    private Button rotateLayoutButton;
    private Button resetButton;
    private Button unbindAllButton;
    private EditBox keyMappingNameFilterEditBox;
    private EditBox keyMappingCategoryFilterEditBox;
    private List<KeyBoardLayout> keyboardLayouts = new ArrayList<KeyBoardLayout>();
    private KeyBoardLayout activeKeyboardLayout;
    private int activeKeyboardLayoutIndex = 0;
    private List<KeyButton> keyButtons = new ArrayList<KeyButton>();
    private static final int PAGE_PADDING_TOP = 30;
    private static final int FILTERS_HEIGHT = 25;
    private static final int PAGE_PADDING_BOTTOM = 35;
    private static final int PAGE_PADDING_RIGHT = 5;
    private static final int PAGE_PADDING_LEFT = 5;
    private static final int PAGE_MID_GAP_HORIZONTAL = 5;
    private static final int PAGE_MID_GAP_VERTICAL = 10;
    private int defaultListWidth = 30;
    private int defaultListHeight = 30;
    private int defaultListTop = 30;
    private int defaultListLeft = 30;
    private int layoutTop = 30;
    private int layoutLeft = 30;
    private int layoutWidth = 30;
    private int layoutHeight = 30;
    private int detailsListTop = 30;
    private int detailsListLeft = 30;
    private int detailsListWidth = 30;
    private int detailsListHeight = 30;
    private KeyDetailsList detailsList;
    private KeyMapping keyMappingToChange;

    public AlternativeKeybindScreen(Screen screen, Options options) {
        super(screen, options, (Component)Component.m_237113_((String)"Visual keybinder"));
        this.getKeyboardLayouts();
    }

    protected void m_7856_() {
        this.layoutHeight = (int)((double)(this.f_96544_ - 30 - 35 - 10) * 0.45);
        this.detailsListHeight = this.f_96544_ - this.layoutHeight - 30 - 35 - 10;
        this.defaultListHeight = this.detailsListHeight - 25;
        this.layoutTop = 30 + this.detailsListHeight + 10;
        this.defaultListTop = 55;
        this.detailsListTop = 30;
        this.detailsListWidth = (int)((double)this.f_96543_ * 0.45 - 5.0 - 5.0);
        this.defaultListWidth = this.f_96543_ - this.detailsListWidth - 5 - 5 - 5;
        this.layoutLeft = 5;
        this.layoutWidth = this.f_96543_ - 5 - this.layoutLeft;
        this.detailsListLeft = 5;
        this.defaultListLeft = this.detailsListLeft + this.detailsListWidth + 5;
        this.defaultKeyBindsList = (DefaultKeyBindsList)this.m_7787_((GuiEventListener)new DefaultKeyBindsList(this, this.f_96541_, this.f_96282_, this.defaultListLeft, this.defaultListTop, this.defaultListWidth, this.defaultListHeight));
        this.setActiveKeyboardLayout(this.activeKeyboardLayoutIndex);
        this.rotateLayoutButton = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 155, 5, 150, 20, (Component)Component.m_237119_(), button -> this.setActiveKeyboardLayout(this.getActiveKeyboardLayoutIndex() + 1)));
        this.m_142416_((GuiEventListener)new Button(5, this.f_96544_ - 25, 150, 20, CommonComponents.f_130655_, button -> this.f_96541_.m_91152_(this.f_96281_)));
        this.resetButton = (Button)this.m_142416_((GuiEventListener)new Button(80, 5, 70, 20, (Component)Component.m_237115_((String)"controls.resetAll").m_130940_(ChatFormatting.GRAY), button -> {
            for (KeyMapping keymapping : this.f_96282_.f_92059_) {
                keymapping.setToDefault();
            }
            KeyMapping.m_90854_();
            this.onBindingsChanged();
        }));
        this.unbindAllButton = (Button)this.m_142416_((GuiEventListener)new Button(5, 5, 70, 20, (Component)Component.m_237113_((String)"Unbind all").m_130940_(ChatFormatting.GRAY), button -> {
            for (KeyMapping keymapping : this.f_96282_.f_92059_) {
                keymapping.setKeyModifierAndCode(KeyModifier.NONE, InputConstants.f_84822_);
            }
            KeyMapping.m_90854_();
            this.onBindingsChanged();
        }));
        if (this.detailsList != null) {
            this.setDetailsList(this.detailsList.getSelectedKey());
        }
        this.keyMappingNameFilterEditBox = (EditBox)this.m_7787_((GuiEventListener)new FilterEditBox(this.f_96547_, this.defaultListLeft, this.defaultListTop - 25, this.defaultListWidth / 2 - 5, 20, (Component)Component.m_237113_((String)"Name filter")));
        this.keyMappingCategoryFilterEditBox = (EditBox)this.m_7787_((GuiEventListener)new FilterEditBox(this.f_96547_, this.defaultListLeft + this.defaultListWidth / 2, this.defaultListTop - 25, this.defaultListWidth / 2, 20, (Component)Component.m_237113_((String)"Category filter")));
        this.keyMappingCategoryFilterEditBox.m_94202_(CATEGORY_COLOR);
        this.keyMappingCategoryFilterEditBox.m_94151_(this.defaultKeyBindsList::setCategoryFilter);
        this.keyMappingNameFilterEditBox.m_94151_(this.defaultKeyBindsList::setKeyMappingFilter);
    }

    public void m_86600_() {
        this.keyMappingCategoryFilterEditBox.m_94120_();
        this.keyMappingNameFilterEditBox.m_94120_();
    }

    public int getLayoutLeft() {
        return this.layoutLeft;
    }

    public int getLayoutTop() {
        return this.layoutTop;
    }

    public int getLayoutWidth() {
        return this.layoutWidth;
    }

    public int getLayoutHeight() {
        return this.layoutHeight;
    }

    public int getActiveKeyboardLayoutIndex() {
        return this.activeKeyboardLayoutIndex;
    }

    private void getKeyboardLayouts() {
        this.keyboardLayouts.clear();
        this.keyboardLayouts.addAll(ClientConfig.getKeyboardLayoutsFromConfig());
    }

    public KeyBoardLayout getActiveKeyboardLayout() {
        return this.activeKeyboardLayout;
    }

    public void setActiveKeyboardLayout(int index) {
        if (this.keyboardLayouts.isEmpty()) {
            this.activeKeyboardLayout = null;
            this.activeKeyboardLayoutIndex = index;
            return;
        }
        if (index >= this.keyboardLayouts.size()) {
            index = 0;
        } else if (index < 0) {
            index = this.keyboardLayouts.size() - 1;
        }
        this.activeKeyboardLayout = this.keyboardLayouts.get(index);
        this.activeKeyboardLayoutIndex = index;
        this.createLayoutButtons(this.activeKeyboardLayout);
    }

    public boolean m_7933_(int p_193987_, int p_193988_, int p_193989_) {
        if (this.keyMappingToChange != null && !KeyModifier.isKeyCodeModifier((InputConstants.Key)InputConstants.m_84827_((int)p_193987_, (int)p_193988_))) {
            if (p_193987_ == 256) {
                this.keyMappingToChange.setKeyModifierAndCode(KeyModifier.NONE, InputConstants.f_84822_);
                this.f_96282_.m_92159_(this.keyMappingToChange, InputConstants.f_84822_);
            } else {
                this.keyMappingToChange.setKeyModifierAndCode(KeyModifier.getActiveModifier(), InputConstants.m_84827_((int)p_193987_, (int)p_193988_));
                this.f_96282_.m_92159_(this.keyMappingToChange, InputConstants.m_84827_((int)p_193987_, (int)p_193988_));
            }
            this.keyMappingToChange = null;
            KeyMapping.m_90854_();
            this.onBindingsChanged();
            return true;
        }
        try {
            return super.m_7933_(p_193987_, p_193988_, p_193989_);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean m_7920_(int p_193987_, int p_193988_, int p_193989_) {
        InputConstants.Key pressedKey = InputConstants.m_84827_((int)p_193987_, (int)p_193988_);
        if (this.keyMappingToChange != null && KeyModifier.isKeyCodeModifier((InputConstants.Key)pressedKey)) {
            this.keyMappingToChange.setKeyModifierAndCode(KeyModifier.NONE, InputConstants.m_84827_((int)p_193987_, (int)p_193988_));
            this.f_96282_.m_92159_(this.keyMappingToChange, pressedKey);
            this.keyMappingToChange = null;
            KeyMapping.m_90854_();
            this.onBindingsChanged();
            return true;
        }
        return super.m_7920_(p_193987_, p_193988_, p_193989_);
    }

    public boolean m_6375_(double p_193983_, double p_193984_, int p_19394_) {
        if (this.keyMappingToChange != null) {
            this.keyMappingToChange.setKeyModifierAndCode(KeyModifier.getActiveModifier(), InputConstants.Type.MOUSE.m_84895_(p_19394_));
            this.f_96282_.m_92159_(this.keyMappingToChange, InputConstants.Type.MOUSE.m_84895_(p_19394_));
            this.keyMappingToChange = null;
            KeyMapping.m_90854_();
            this.onBindingsChanged();
            return true;
        }
        return super.m_6375_(p_193983_, p_193984_, p_19394_);
    }

    public void m_7522_(@Nullable GuiEventListener p_94677_) {
        GuiEventListener currentFocused = this.m_7222_();
        if (currentFocused instanceof EditBox) {
            EditBox editBox = (EditBox)currentFocused;
            if (!currentFocused.equals(p_94677_)) {
                editBox.m_94178_(false);
            }
        }
        super.m_7522_(p_94677_);
    }

    public KeyMapping getKeyMappingToChange() {
        return this.keyMappingToChange;
    }

    public void setKeyMappingToChange(KeyMapping keyMappingToChange) {
        this.keyMappingToChange = keyMappingToChange;
    }

    public KeyDetailsList getDetailsList() {
        return this.detailsList;
    }

    public void onBindingsChanged() {
        if (this.detailsList != null) {
            this.detailsList.onBindingsUpdated();
        }
        this.defaultKeyBindsList.onBindingsUpdated();
    }

    public KeyMapping[] getKeyMappings(KeyboardLayoutKey key) {
        return (KeyMapping[])Arrays.stream((KeyMapping[])ArrayUtils.clone((Object[])this.f_96282_.f_92059_)).filter(x -> x.getKey().m_84873_() == key.getKey().m_84873_() || x.getKeyModifier().matches(key.getKey())).toArray(KeyMapping[]::new);
    }

    private void createLayoutButtons(KeyBoardLayout keyboardLayout) {
        this.keyButtons.forEach(item -> this.m_169411_((GuiEventListener)item));
        this.keyButtons.clear();
        keyboardLayout.getKeyboardLayoutKeys().forEach(item -> {
            KeyButton btn = new KeyButton(this, keyboardLayout, (KeyboardLayoutKey)item, this.layoutLeft + item.getX() + (this.layoutWidth / 2 - keyboardLayout.getWidth() / 2) - keyboardLayout.getMinX(), this.layoutTop + item.getY() + (this.layoutHeight / 2 - keyboardLayout.getHeight() / 2) - keyboardLayout.getMinY(), x -> {
                if (this.detailsList != null && this.detailsList.getSelectedKey().getKey().m_84873_() == item.getKey().m_84873_()) {
                    this.m_169411_((GuiEventListener)this.detailsList);
                    this.detailsList = null;
                    return;
                }
                this.setDetailsList((KeyboardLayoutKey)item);
            });
            this.keyButtons.add((KeyButton)this.m_142416_((GuiEventListener)btn));
        });
    }

    public void setDetailsList(KeyboardLayoutKey keyboardLayoutKey) {
        if (this.detailsList != null) {
            this.m_169411_((GuiEventListener)this.detailsList);
        }
        this.detailsList = (KeyDetailsList)this.m_7787_((GuiEventListener)new KeyDetailsList(this, this.f_96541_, this.f_96282_, keyboardLayoutKey, this.detailsListLeft, this.detailsListTop, this.detailsListWidth, this.detailsListHeight));
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float p_193994_) {
        this.m_96626_(0);
        this.m_93179_(poseStack, 0, this.f_96544_ - 30, this.f_96543_, this.f_96544_, new Color(0, 0, 0, 120).getRGB(), new Color(0, 0, 0, 120).getRGB());
        if (this.detailsList != null) {
            this.detailsList.m_6305_(poseStack, mouseX, mouseY, p_193994_);
        }
        this.defaultKeyBindsList.m_6305_(poseStack, mouseX, mouseY, p_193994_);
        AlternativeKeybindScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)8, (int)0xFFFFFF);
        this.resetButton.f_93623_ = this.hasNonDefaultBindings();
        this.unbindAllButton.f_93623_ = this.hasBoundBindings();
        if (this.activeKeyboardLayout == null) {
            this.rotateLayoutButton.m_93666_((Component)Component.m_237113_((String)(this.keyboardLayouts.isEmpty() ? "No layouts.." : "Select layout")));
        } else {
            this.rotateLayoutButton.m_93666_((Component)Component.m_237113_((String)this.activeKeyboardLayout.getName().getString()).m_130946_(" " + (this.getActiveKeyboardLayoutIndex() + 1) + "/" + this.keyboardLayouts.size()));
        }
        this.rotateLayoutButton.f_93621_ = this.f_96544_ - 25;
        this.rotateLayoutButton.m_6305_(poseStack, mouseX, mouseY, p_193994_);
        if (this.getDetailsList() == null) {
            this.renderNoSelectionInfo(poseStack, mouseX, mouseY, p_193994_);
        }
        if (((Boolean)ClientConfig.displayLayoutButtonTooltips.get()).booleanValue()) {
            this.keyButtons.forEach(keyButton -> {
                if (keyButton.m_198029_()) {
                    ArrayList<Object> componentList = new ArrayList<Object>();
                    componentList.add(keyButton.m_6035_());
                    KeyMapping[] keyMappings = keyButton.getKeymappings();
                    if (keyMappings.length == 0) {
                        componentList.add(Component.m_237113_((String)"No bindings").m_130940_(ChatFormatting.DARK_GRAY));
                    } else {
                        componentList.add(Component.m_237113_((String)""));
                        for (KeyMapping keymapping : keyMappings) {
                            componentList.add(Component.m_237113_((String)" - ").m_7220_((Component)Component.m_237115_((String)keymapping.m_90860_())).m_130940_(KeyUtil.hasConflict(keyMappings, keymapping) ? ChatFormatting.GOLD : ChatFormatting.GRAY));
                        }
                    }
                    this.m_96597_(poseStack, componentList, mouseX, mouseY);
                }
            });
        }
        if (((Boolean)ClientConfig.displayChangeAndResetButtonTooltips.get()).booleanValue()) {
            if (this.detailsList != null) {
                this.detailsList.m_94729_(mouseX, mouseY).ifPresent(x -> {
                    if (x instanceof KeyDetailsList.KeyInfoEntry) {
                        KeyDetailsList.KeyInfoEntry keyInfoEntry = (KeyDetailsList.KeyInfoEntry)((Object)x);
                        if (keyInfoEntry.getResetButton().m_198029_()) {
                            this.m_96602_(poseStack, (Component)Component.m_237115_((String)"controls.reset"), mouseX, mouseY);
                        } else if (keyInfoEntry.getChangeButton().m_198029_()) {
                            this.m_96602_(poseStack, (Component)Component.m_237113_((String)"Change binding"), mouseX, mouseY);
                        }
                    }
                });
            }
            this.defaultKeyBindsList.m_94729_(mouseX, mouseY).ifPresent(x -> {
                if (x instanceof DefaultKeyBindsList.KeyEntry) {
                    DefaultKeyBindsList.KeyEntry keyInfoEntry = (DefaultKeyBindsList.KeyEntry)((Object)x);
                    if (keyInfoEntry.getResetButton().m_198029_()) {
                        this.m_96602_(poseStack, (Component)Component.m_237115_((String)"controls.reset"), mouseX, mouseY);
                    } else if (keyInfoEntry.getChangeButton().m_198029_()) {
                        this.m_96602_(poseStack, (Component)Component.m_237113_((String)"Change binding"), mouseX, mouseY);
                    }
                }
            });
        }
        this.keyMappingNameFilterEditBox.m_6305_(poseStack, mouseX, mouseY, p_193994_);
        if (this.keyMappingNameFilterEditBox.m_94155_().isEmpty()) {
            AlternativeKeybindScreen.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)Component.m_237113_((String)"Filter name"), (int)(this.defaultListLeft + 4), (int)36, (int)Color.darkGray.getRGB());
        }
        this.keyMappingCategoryFilterEditBox.m_6305_(poseStack, mouseX, mouseY, p_193994_);
        if (this.keyMappingCategoryFilterEditBox.m_94155_().isEmpty()) {
            AlternativeKeybindScreen.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)Component.m_237113_((String)"Filter category "), (int)(this.defaultListLeft + this.defaultListWidth / 2 + 4), (int)36, (int)Color.darkGray.getRGB());
        }
        super.m_6305_(poseStack, mouseX, mouseY, p_193994_);
    }

    public void renderNoSelectionInfo(PoseStack poseStack, int p_193992_, int p_193993_, float p_193994_) {
        this.f_96541_.f_91062_.m_92889_(poseStack, (Component)Component.m_237113_((String)"Select a key to view/edit bindings"), (float)(this.detailsListLeft + 10), (float)(this.defaultListTop + 30), Color.GRAY.getRGB());
    }

    private boolean hasNonDefaultBindings() {
        for (KeyMapping keymapping : this.f_96282_.f_92059_) {
            if (keymapping.m_90864_()) continue;
            return true;
        }
        return false;
    }

    private boolean hasBoundBindings() {
        for (KeyMapping keymapping : this.f_96282_.f_92059_) {
            if (keymapping.m_90862_()) continue;
            return true;
        }
        return false;
    }
}

