/*
 * Decompiled with CFR 0.152.
 */
package dev.shwg.smoothswapping.mixin;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import dev.shwg.smoothswapping.SmoothSwapping;
import dev.shwg.smoothswapping.SwapUtil;
import dev.shwg.smoothswapping.config.CatmullRomWidget;
import dev.shwg.smoothswapping.config.Config;
import dev.shwg.smoothswapping.config.ConfigManager;
import dev.shwg.smoothswapping.config.ConfigScreen;
import dev.shwg.smoothswapping.swaps.InventorySwap;
import dev.shwg.smoothswapping.swaps.ItemToCursorInventorySwap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.NonNullList;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemRenderer.class})
public abstract class ItemRendererMixin {
    @Shadow
    public float f_115093_;

    @Inject(method={"renderItem(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/render/model/json/ModelTransformation$Mode;ZLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;IILnet/minecraft/client/render/model/BakedModel;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void onRenderItem(ItemStack stack, ItemTransforms.TransformType renderMode, boolean leftHanded, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay, BakedModel model, CallbackInfo cbi) {
        Minecraft client = Minecraft.m_91087_();
        if (this.f_115093_ < 100.0f && !(client.f_91080_ instanceof ConfigScreen)) {
            return;
        }
        if (renderMode == ItemTransforms.TransformType.GUI) {
            if (client.f_91074_ == null && !(client.f_91080_ instanceof ConfigScreen)) {
                return;
            }
            try {
                this.doSwap(client, stack, renderMode, leftHanded, matrices, vertexConsumers, light, overlay, model, this.f_115093_, cbi);
            }
            catch (Exception e) {
                SwapUtil.reset();
            }
        }
    }

    @Inject(method={"renderGuiItemOverlay(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRenderOverlay(Font renderer, ItemStack stack, int x, int y, String countLabel, CallbackInfo cbi) {
        Minecraft client = Minecraft.m_91087_();
        if (this.f_115093_ < 100.0f && !(client.f_91080_ instanceof ConfigScreen)) {
            return;
        }
        try {
            this.doOverlayRender((ItemRenderer)this, stack, renderer, x, y, cbi);
        }
        catch (Exception e) {
            SwapUtil.reset();
        }
    }

    private void doSwap(Minecraft client, ItemStack stack, ItemTransforms.TransformType renderMode, boolean leftHanded, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay, BakedModel model, float zOffset, CallbackInfo ci) {
        float lastFrameDuration = client.m_91297_();
        ItemRenderer renderer = (ItemRenderer)this;
        int index = SwapUtil.getSlotIndex(stack);
        if (SmoothSwapping.swaps.containsKey(index)) {
            List<InventorySwap> swapList = SmoothSwapping.swaps.get(index);
            boolean renderDestinationSlot = true;
            for (int i = 0; i < swapList.size(); ++i) {
                InventorySwap swap2 = swapList.get(i);
                swap2.setRenderDestinationSlot(swap2.isChecked());
                if (!swap2.renderDestinationSlot()) {
                    renderDestinationSlot = false;
                }
                ItemRendererMixin.renderSwap(renderer, swap2, lastFrameDuration, stack.m_41777_(), leftHanded, vertexConsumers, light, overlay, model);
                if (!SwapUtil.hasArrived(swap2)) continue;
                SwapUtil.setRenderToTrue(swapList);
                swapList.remove(swap2);
            }
            if (renderDestinationSlot) {
                renderer.m_115143_(stack.m_41777_(), renderMode, leftHanded, matrices, vertexConsumers, light, overlay, model);
            }
            if (swapList.size() == 0) {
                SmoothSwapping.swaps.remove(index);
            }
            ci.cancel();
        } else if (SmoothSwapping.swaps.containsKey(-2)) {
            List<InventorySwap> swapList = SmoothSwapping.swaps.get(-2).stream().filter(swap -> !((ItemToCursorInventorySwap)swap).isArrived()).toList();
            if (!swapList.isEmpty() && ItemRendererMixin.swapListIndexOf(swapList, swap -> ((ItemToCursorInventorySwap)swap).getCopiedStackHash() == stack.hashCode()) == -1) {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                AbstractContainerMenu handler = null;
                if (player != null) {
                    handler = player.f_36096_;
                }
                for (InventorySwap inventorySwap : swapList) {
                    ItemToCursorInventorySwap swap3 = (ItemToCursorInventorySwap)inventorySwap;
                    if (!swap3.isStartedRender()) {
                        swap3.setStartedRender(true);
                        continue;
                    }
                    if (swap3.isArrived() || handler == null) continue;
                    NonNullList inventoryStacks = handler.m_38927_();
                    if (swap3.getTargetStackHash() == -1 || handler.m_142621_().hashCode() == swap3.getTargetStackHash()) {
                        if (inventoryStacks.contains((Object)stack)) continue;
                        ItemStack copiedStack = swap3.getSwapItem().m_41777_();
                        swap3.setCopiedStackHash(copiedStack.hashCode());
                        if (swap3.getTargetStackHash() == -1) {
                            swap3.setTargetStackHash(stack.hashCode());
                        }
                        ItemRendererMixin.renderSwap(renderer, swap3, lastFrameDuration, copiedStack, leftHanded, vertexConsumers, light, overlay, model);
                        if (!SwapUtil.hasArrived(swap3)) continue;
                        swap3.setArrived(true);
                        continue;
                    }
                    swap3.setArrived(true);
                }
            }
            if (swapList.stream().allMatch(swap -> ((ItemToCursorInventorySwap)swap).isArrived())) {
                SmoothSwapping.swaps.remove(-2);
            }
        }
    }

    private static int swapListIndexOf(List<InventorySwap> list, Function<InventorySwap, Boolean> prediction) {
        for (int i = 0; i < list.size(); ++i) {
            if (!prediction.apply(list.get(i)).booleanValue()) continue;
            return i;
        }
        return -1;
    }

    private void doOverlayRender(ItemRenderer itemRenderer, ItemStack stack, Font renderer, int x, int y, CallbackInfo cbi) {
        int index = SwapUtil.getSlotIndex(stack);
        if (SmoothSwapping.swaps.containsKey(index)) {
            List<InventorySwap> swapList = SmoothSwapping.swaps.get(index);
            Config config = ConfigManager.getConfig();
            int stackCount = stack.m_41613_();
            boolean renderToSlot = true;
            for (InventorySwap swap : swapList) {
                if (!ItemStack.m_41758_((ItemStack)stack, (ItemStack)swap.getSwapItem())) {
                    SmoothSwapping.swaps.remove(index);
                    return;
                }
                stackCount -= swap.getAmount();
                if (!swap.renderDestinationSlot()) {
                    renderToSlot = false;
                }
                if (swap.getAmount() <= 1) continue;
                String amount = String.valueOf(swap.getAmount());
                MultiBufferSource.BufferSource immediate = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                PoseStack textMatrices = new PoseStack();
                textMatrices.m_85836_();
                double swapX = swap.getX();
                double swapY = swap.getY();
                double angle = swap.getAngle();
                double progress = 1.0 - SwapUtil.map(Math.hypot(swapX, swapY), 0.0, swap.getDistance(), 1.0, 0.0);
                List<CatmullRomWidget.CatmullRomSpline> splines = config.getSplines();
                double ease = CatmullRomWidget.getProgress(progress, splines);
                double renderX = -swap.getStartX() - Math.cos(angle) * swap.getDistance() * ease;
                double renderY = swap.getStartY() + Math.sin(angle) * swap.getDistance() * ease;
                textMatrices.m_85837_(renderX, -renderY, (double)(this.f_115093_ + 250.0f));
                renderer.m_92811_(amount, (float)(x + 19 - 2 - renderer.m_92895_(amount)), (float)(y + 6 + 3), 0xFFFFFF, true, textMatrices.m_85850_().m_85861_(), (MultiBufferSource)immediate, false, 0, 0xF000F0);
                immediate.m_109911_();
                textMatrices.m_85849_();
            }
            if (renderToSlot && stackCount > 1) {
                itemRenderer.m_115174_(renderer, stack.m_41777_(), x, y, String.valueOf(stackCount));
            }
            cbi.cancel();
        }
    }

    private static void renderSwap(ItemRenderer itemRenderer, InventorySwap swap, float lastFrameDuration, ItemStack stack, boolean leftHanded, MultiBufferSource vertexConsumers, int light, int overlay, BakedModel model) {
        Config config = ConfigManager.getConfig();
        PoseStack matrices = new PoseStack();
        matrices.m_85836_();
        double x = swap.getX();
        double y = swap.getY();
        double angle = swap.getAngle();
        double progress = 1.0 - SwapUtil.map(Math.hypot(x, y), 0.0, swap.getDistance(), 1.0, 0.0);
        List<CatmullRomWidget.CatmullRomSpline> splines = config.getSplines();
        double ease = CatmullRomWidget.getProgress(progress, splines);
        double renderX = -swap.getStartX() - Math.cos(angle) * swap.getDistance() * ease;
        double renderY = swap.getStartY() + Math.sin(angle) * swap.getDistance() * ease;
        matrices.m_85837_(renderX / 16.0, renderY / 16.0, 5.0);
        itemRenderer.m_115143_(stack, ItemTransforms.TransformType.GUI, leftHanded, matrices, vertexConsumers, light, overlay, model);
        double speed = swap.getDistance() / 10.0 * (double)config.getAnimationSpeedFormatted();
        swap.setX(x + (double)lastFrameDuration * speed * Math.cos(angle));
        swap.setY(y + (double)lastFrameDuration * speed * Math.sin(angle));
        matrices.m_85849_();
    }
}

