/*
 * Decompiled with CFR 0.152.
 */
package dev.shwg.smoothswapping;

import dev.shwg.smoothswapping.SmoothSwapping;
import dev.shwg.smoothswapping.SwapStacks;
import dev.shwg.smoothswapping.Vec2;
import dev.shwg.smoothswapping.swaps.InventorySwap;
import dev.shwg.smoothswapping.swaps.ItemToCursorInventorySwap;
import dev.shwg.smoothswapping.swaps.ItemToItemInventorySwap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class SwapUtil {
    public static boolean hasArrived(InventorySwap swap) {
        int quadrant = SwapUtil.getQuadrant(swap.getAngle());
        double x = swap.getX();
        double y = swap.getY();
        if (quadrant == 0 && x > 0.0 && y > 0.0) {
            return true;
        }
        if (quadrant == 1 && x < 0.0 && y > 0.0) {
            return true;
        }
        if (quadrant == 2 && x < 0.0 && y < 0.0) {
            return true;
        }
        return quadrant == 3 && x > 0.0 && y < 0.0;
    }

    public static int getSlotIndex(ItemStack stack) {
        for (int i = 0; i < SmoothSwapping.currentStacks.size(); ++i) {
            ItemStack s = (ItemStack)SmoothSwapping.currentStacks.get(i);
            if (s.hashCode() != stack.hashCode()) continue;
            return i;
        }
        return -1;
    }

    public static void setRenderToTrue(List<InventorySwap> swapList) {
        for (InventorySwap swap : swapList) {
            swap.setRenderDestinationSlot(true);
        }
    }

    private static int getQuadrant(double angle) {
        return (int)(Math.floor(2.0 * angle / Math.PI) % 4.0 + 4.0) % 4;
    }

    public static double map(double in, double inMin, double inMax, double outMax, double outMin) {
        return (in - inMin) / (inMax - inMin) * (outMax - outMin) + outMin;
    }

    public static void addI2IInventorySwap(int index, Slot fromSlot, Slot toSlot, boolean checked, int amount) {
        List swaps = SmoothSwapping.swaps.getOrDefault(index, new ArrayList());
        if (ItemStack.m_41758_((ItemStack)toSlot.m_7993_(), (ItemStack)Items.f_41852_.m_7968_())) {
            return;
        }
        swaps.add(new ItemToItemInventorySwap(fromSlot, toSlot, checked, amount));
        SmoothSwapping.swaps.put(index, swaps);
    }

    public static void assignI2CSwaps(List<SwapStacks> lessStacks, Vec2 mousePos, AbstractContainerMenu handler) {
        ItemStack cursorStack = handler.m_142621_();
        for (SwapStacks lessStack : lessStacks) {
            Slot lessSlot = handler.m_38853_(lessStack.getSlotID());
            List swaps = SmoothSwapping.swaps.getOrDefault(-2, new ArrayList());
            if (ItemStack.m_41758_((ItemStack)cursorStack, (ItemStack)Items.f_41852_.m_7968_())) {
                return;
            }
            swaps.add(new ItemToCursorInventorySwap(lessSlot, mousePos, lessStack.getOldStack(), false, lessStack.itemCountToChange));
            SmoothSwapping.swaps.put(-2, swaps);
        }
    }

    public static void assignI2ISwaps(List<SwapStacks> moreStacks, List<SwapStacks> lessStacks, AbstractContainerMenu handler) {
        for (int i = 0; i < moreStacks.size(); ++i) {
            SwapStacks moreStack = moreStacks.get(i);
            if (moreStack.itemCountToChange == 0) {
                moreStacks.remove(moreStack);
            }
            Slot moreSlot = handler.m_38853_(moreStack.getSlotID());
            int c = 0;
            block1: while (moreStack.itemCountToChange < 0 && c < 64) {
                ++c;
                for (int j = 0; j < lessStacks.size(); ++j) {
                    SwapStacks lessStack = lessStacks.get(j);
                    int amount = 0;
                    while (lessStack.itemCountToChange != 0 && moreStack.itemCountToChange != 0) {
                        --lessStack.itemCountToChange;
                        ++moreStack.itemCountToChange;
                        ++amount;
                    }
                    Slot lessSlot = handler.m_38853_(lessStack.getSlotID());
                    SwapUtil.addI2IInventorySwap(moreStack.getSlotID(), lessSlot, moreSlot, ItemStack.m_41758_((ItemStack)moreStack.getOldStack(), (ItemStack)moreStack.getNewStack()), amount);
                    if (lessStack.itemCountToChange == 0) {
                        lessStacks.remove(lessStack);
                    }
                    if (moreStack.itemCountToChange == 0) continue block1;
                }
            }
        }
    }

    public static int getCount(ItemStack stack) {
        return ItemStack.m_41758_((ItemStack)stack, (ItemStack)Items.f_41852_.m_7968_()) ? 0 : stack.m_41613_();
    }

    public static void copyStacks(NonNullList<ItemStack> src, NonNullList<ItemStack> dst) {
        dst.clear();
        src.stream().map(ItemStack::m_41777_).forEach(arg_0 -> dst.add(arg_0));
    }

    public static void reset() {
        SmoothSwapping.clickSwap = false;
        SmoothSwapping.clickSwapStack = null;
        SmoothSwapping.swaps.clear();
        SmoothSwapping.oldStacks.clear();
        SmoothSwapping.currentStacks.clear();
        SmoothSwapping.oldCursorStack = null;
    }
}

