/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.gothic.init;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mcreator.gothic.GothicMod;
import net.mcreator.gothic.init.GothicModBlocks;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GothicModVillagerProfessions {
    private static final Map<String, ProfessionPoiType> POI_TYPES = new HashMap<String, ProfessionPoiType>();
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.VILLAGER_PROFESSIONS, (String)"gothic");
    public static final RegistryObject<VillagerProfession> SWAMP_CAMP_TRADER = GothicModVillagerProfessions.registerProfession("swamp_camp_trader", () -> (Block)GothicModBlocks.STONE_BOWL.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.work_toolsmith")));
    public static final RegistryObject<VillagerProfession> OLD_CAMP_TRADER = GothicModVillagerProfessions.registerProfession("old_camp_trader", () -> (Block)GothicModBlocks.GUARDIAN_TABLE.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.work_toolsmith")));
    public static final RegistryObject<VillagerProfession> FARM_TRADER = GothicModVillagerProfessions.registerProfession("farm_trader", () -> (Block)GothicModBlocks.FARMER_TABLE.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.work_armorer")));
    public static final RegistryObject<VillagerProfession> PALADIN_TRADER = GothicModVillagerProfessions.registerProfession("paladin_trader", () -> (Block)GothicModBlocks.PALADIN_TABLE.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.work_toolsmith")));
    public static final RegistryObject<VillagerProfession> NEW_CAMP_TRADER = GothicModVillagerProfessions.registerProfession("new_camp_trader", () -> (Block)GothicModBlocks.BURGLAR_TABLE.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.work_toolsmith")));
    public static final RegistryObject<VillagerProfession> HUNTER_TRADER = GothicModVillagerProfessions.registerProfession("hunter_trader", () -> (Block)GothicModBlocks.HUNTER_TABLE.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.work_armorer")));
    public static final RegistryObject<VillagerProfession> MINER_TRADER = GothicModVillagerProfessions.registerProfession("miner_trader", () -> (Block)GothicModBlocks.MINER_TABLE.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.work_armorer")));
    public static final RegistryObject<VillagerProfession> BLACKSMITH = GothicModVillagerProfessions.registerProfession("blacksmith", () -> (Block)GothicModBlocks.BLACKSMITH_ANVIL.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.smithing_table.use")));
    public static final RegistryObject<VillagerProfession> PIRATE = GothicModVillagerProfessions.registerProfession("pirate", () -> (Block)GothicModBlocks.PIRATE_TABLE.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.smithing_table.use")));
    public static final RegistryObject<VillagerProfession> NORDMAR_TRADER = GothicModVillagerProfessions.registerProfession("nordmar_trader", () -> (Block)GothicModBlocks.NORDMAR_TABLE.get(), () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.work_armorer")));

    private static RegistryObject<VillagerProfession> registerProfession(String name, Supplier<Block> block, Supplier<SoundEvent> soundEvent) {
        POI_TYPES.put(name, new ProfessionPoiType(block, null));
        return PROFESSIONS.register(name, () -> {
            Predicate<Holder> poiPredicate = poiTypeHolder -> GothicModVillagerProfessions.POI_TYPES.get((Object)name).poiType != null && poiTypeHolder.get() == GothicModVillagerProfessions.POI_TYPES.get((Object)name).poiType.get();
            return new VillagerProfession("gothic:" + name, poiPredicate, poiPredicate, ImmutableSet.of(), ImmutableSet.of(), (SoundEvent)soundEvent.get());
        });
    }

    @SubscribeEvent
    public static void registerProfessionPointsOfInterest(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.POI_TYPES, registerHelper -> {
            for (Map.Entry<String, ProfessionPoiType> entry : POI_TYPES.entrySet()) {
                Block block = entry.getValue().block.get();
                String name = entry.getKey();
                Optional existingCheck = PoiTypes.m_218075_((BlockState)block.m_49966_());
                if (existingCheck.isPresent()) {
                    GothicMod.LOGGER.error("Skipping villager profession " + name + " that uses POI block " + block + " that is already in use by " + existingCheck);
                    continue;
                }
                PoiType poiType = new PoiType((Set)ImmutableSet.copyOf((Collection)block.m_49965_().m_61056_()), 1, 1);
                registerHelper.register(name, (Object)poiType);
                entry.getValue().poiType = (Holder)ForgeRegistries.POI_TYPES.getHolder((Object)poiType).get();
            }
        });
    }

    private static class ProfessionPoiType {
        final Supplier<Block> block;
        Holder<PoiType> poiType;

        ProfessionPoiType(Supplier<Block> block, Holder<PoiType> poiType) {
            this.block = block;
            this.poiType = poiType;
        }
    }
}

