/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.gothic;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mcreator.gothic.init.GothicModBlocks;
import net.mcreator.gothic.init.GothicModEntities;
import net.mcreator.gothic.init.GothicModFeatures;
import net.mcreator.gothic.init.GothicModItems;
import net.mcreator.gothic.init.GothicModMenus;
import net.mcreator.gothic.init.GothicModMobEffects;
import net.mcreator.gothic.init.GothicModParticleTypes;
import net.mcreator.gothic.init.GothicModSounds;
import net.mcreator.gothic.init.GothicModTabs;
import net.mcreator.gothic.init.GothicModVillagerProfessions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib3.GeckoLib;

@Mod(value="gothic")
public class GothicMod {
    public static final Logger LOGGER = LogManager.getLogger(GothicMod.class);
    public static final String MODID = "gothic";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("gothic", "gothic"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public GothicMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        GothicModTabs.load();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        GothicModSounds.REGISTRY.register(bus);
        GothicModBlocks.REGISTRY.register(bus);
        GothicModItems.REGISTRY.register(bus);
        GothicModEntities.REGISTRY.register(bus);
        GothicModFeatures.REGISTRY.register(bus);
        GothicModMobEffects.REGISTRY.register(bus);
        GothicModParticleTypes.REGISTRY.register(bus);
        GothicModMenus.REGISTRY.register(bus);
        GothicModVillagerProfessions.PROFESSIONS.register(bus);
        GeckoLib.initialize();
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

