/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.world.spawner;

import com.mrcrayfish.goblintraders.world.spawner.GoblinData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class GoblinTraderData
extends SavedData {
    private static final String DATA_NAME = "goblintraders_goblin_trader";
    private final Map<String, GoblinData> data = new HashMap<String, GoblinData>();

    public GoblinData getGoblinData(String key) {
        return this.data.computeIfAbsent(key, s -> new GoblinData(this));
    }

    public GoblinTraderData read(CompoundTag tag) {
        if (tag.m_128425_("GoblinTraderSpawnDelay", 3)) {
            this.getGoblinData("GoblinTrader").setGoblinTraderSpawnDelay(tag.m_128451_("GoblinTraderSpawnDelay"));
        }
        if (tag.m_128425_("GoblinTraderSpawnChance", 3)) {
            this.getGoblinData("GoblinTrader").setGoblinTraderSpawnChance(tag.m_128451_("GoblinTraderSpawnChance"));
        }
        if (tag.m_128425_("Data", 9)) {
            this.data.clear();
            ListTag list = tag.m_128437_("Data", 10);
            list.forEach(nbt -> {
                CompoundTag goblinTag = (CompoundTag)nbt;
                String key = goblinTag.m_128461_("Key");
                GoblinData data = new GoblinData(this);
                data.read(goblinTag);
                this.data.put(key, data);
            });
        }
        return this;
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        ListTag list = new ListTag();
        this.data.forEach((s, goblinData) -> {
            CompoundTag goblinTag = new CompoundTag();
            goblinData.write(goblinTag);
            goblinTag.m_128359_("Key", s);
            list.add((Object)goblinTag);
        });
        compound.m_128365_("Data", (Tag)list);
        return compound;
    }

    public static GoblinTraderData get(MinecraftServer server) {
        ServerLevel level = server.m_129880_(Level.f_46428_);
        return (GoblinTraderData)level.m_8895_().m_164861_(tag -> new GoblinTraderData().read((CompoundTag)tag), GoblinTraderData::new, DATA_NAME);
    }
}

